/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import java.util.List;
import org.eclipse.vjet.dsf.common.binding.BaseValueBinding;
import org.eclipse.vjet.dsf.common.binding.IListValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class ListValueBinding<T>
extends BaseValueBinding<T>
implements IListValueBinding<T> {
    private static final long serialVersionUID = 1L;
    private List<T> m_data;
    private int m_index;

    public ListValueBinding(List<T> list, int indexKey, Class<T> valueType) {
        super(valueType);
        this.setList(list);
        this.setIndex(indexKey);
    }

    @Override
    public void setList(List<T> list) {
        this.assertNotNull(list, "Target List must not be null");
        this.m_data = list;
    }

    @Override
    public List<T> getList() {
        return this.m_data;
    }

    @Override
    public void setIndex(int index) {
        if (index < 0) {
            this.chuck("List index must be a positive value");
        }
        this.m_index = index;
    }

    @Override
    public int getIndex() {
        return this.m_index;
    }

    @Override
    public T getValue() {
        this.assertState();
        return this.getList().get(this.getIndex());
    }

    @Override
    public void setValue(T value) {
        this.assertState();
        this.getList().set(this.getIndex(), value);
    }

    protected final void assertState() {
        if (this.m_data == null) {
            throw new DsfRuntimeException("List target must not be null");
        }
    }

    public String toString() {
        return this.m_index + " on: " + this.m_data;
    }
}

