/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.IDsfNodeEventQueue;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfPhaseEvent;
import org.eclipse.vjet.dsf.common.event.EventHelper;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.phase.PhaseId;
import org.eclipse.vjet.kernel.stage.IStage;

public final class DefaultDsfNodeEventQueue
implements IDsfNodeEventQueue {
    private List<DsfPhaseEvent> m_nodeEvents = new ArrayList<DsfPhaseEvent>();
    private DsfCtx m_context;

    public DefaultDsfNodeEventQueue() {
        this(DsfCtx.ctx());
    }

    public DefaultDsfNodeEventQueue(DsfCtx context) {
        if (context == null) {
            this.chuck("Context must not be null");
        }
        this.m_context = context;
    }

    @Override
    public void enqueueEvent(DsfPhaseEvent event) {
        IStage currentPhase;
        if (event == null) {
            this.chuck("Event being enqueued must not be null");
        }
        if ((currentPhase = this.m_context.getPhaseDriver().getManager().getCurrent()) != null) {
            EventAssociator.setOriginatingPhaseId(event, (PhaseId)((Object)currentPhase.getId()));
        }
        this.m_nodeEvents.add(event);
    }

    @Override
    public boolean dequeueEvent(DsfPhaseEvent event) {
        return this.m_nodeEvents.remove((Object)event);
    }

    @Override
    public void deliverEvents(PhaseId phaseId) {
        int maxLooping;
        if (phaseId == null) {
            this.chuck("PhaseId must not be null");
        }
        maxLooping = (maxLooping = 10 * this.m_nodeEvents.size()) < 100 ? 100 : maxLooping;
        int index = 0;
        while (index < this.m_nodeEvents.size()) {
            DsfPhaseEvent event;
            if (--maxLooping < 0) {
                this.chuck("Possible infinite event loop detected.");
            }
            if ((event = this.m_nodeEvents.get(index)).shouldFire(phaseId)) {
                try {
                    event.getSource().dsfBroadcast(event);
                }
                catch (AbortDsfEventProcessingException abortDsfEventProcessingException) {}
            }
            if (event.shouldDelete(phaseId)) {
                this.m_nodeEvents.remove(index);
                continue;
            }
            ++index;
        }
    }

    void clear() {
        this.m_nodeEvents.clear();
    }

    private void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    private static class EventAssociator
    extends EventHelper {
        private EventAssociator() {
        }

        protected static void setOriginatingPhaseId(DsfPhaseEvent event, PhaseId phaseId) {
            EventHelper.setOriginatingPhaseId(event, phaseId);
        }
    }
}

