/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.actions.FoldingActionGroup;
import org.eclipse.dltk.mod.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class BasicScriptEditorActionContributor
extends BasicTextEditorActionContributor {
    private List fPartListeners = new ArrayList();
    private RetargetTextEditorAction fGotoMatchingBracket;
    private RetargetTextEditorAction fShowOutline;
    private RetargetTextEditorAction fOpenHierarchy;
    private RetargetAction fRetargetShowScriptDoc;
    private RetargetTextEditorAction fShowScriptDoc;
    private RetargetTextEditorAction fGotoNextMemberAction;
    private RetargetTextEditorAction fGotoPreviousMemberAction;
    private RetargetTextEditorAction fRetargetShowInformationAction;

    public BasicScriptEditorActionContributor() {
        ResourceBundle b = DLTKEditorMessages.getBundleForConstructedKeys();
        this.fRetargetShowInformationAction = new RetargetTextEditorAction(b, "Editor.ShowInformation.");
        this.fRetargetShowInformationAction.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.fRetargetShowScriptDoc = new RetargetAction("org.eclipse.dltk.mod.ui.actions.ShowDocumentaion", DLTKEditorMessages.ShowScriptDoc_label);
        this.fRetargetShowScriptDoc.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.show.documentation");
        this.markAsPartListener(this.fRetargetShowScriptDoc);
        this.fShowScriptDoc = new RetargetTextEditorAction(b, "ShowDocumentation.");
        this.fShowScriptDoc.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.show.documentation");
        this.fGotoMatchingBracket = new RetargetTextEditorAction(b, "GotoMatchingBracket.");
        this.fGotoMatchingBracket.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.goto.matching.bracket");
        this.fShowOutline = new RetargetTextEditorAction(DLTKEditorMessages.getBundleForConstructedKeys(), "ShowOutline.");
        this.fShowOutline.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.show.outline");
        this.fOpenHierarchy = new RetargetTextEditorAction(DLTKEditorMessages.getBundleForConstructedKeys(), "OpenHierarchy.");
        this.fOpenHierarchy.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.open.hierarchy");
        this.fGotoNextMemberAction = new RetargetTextEditorAction(b, "GotoNextMember.");
        this.fGotoNextMemberAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.goto.next.member");
        this.fGotoPreviousMemberAction = new RetargetTextEditorAction(b, "GotoPreviousMember.");
        this.fGotoPreviousMemberAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.goto.previous.member");
    }

    protected final void markAsPartListener(RetargetAction action) {
        this.fPartListeners.add(action);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            page.addPartListener((IPartListener)((RetargetAction)e.next()));
        }
        super.init(bars, page);
        bars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.ShowDocumentaion", (IAction)this.fShowScriptDoc);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager gotoMenu;
        block5: {
            IMenuManager navigateMenu;
            super.contributeToMenu(menu);
            IMenuManager editMenu = menu.findMenuUsingPath("edit");
            if (editMenu != null) {
                MenuManager structureSelection = new MenuManager(DLTKEditorMessages.ExpandSelectionMenu_label, "expandSelection");
                editMenu.insertAfter(ITextEditorActionConstants.SELECT_ALL, (IContributionItem)structureSelection);
                editMenu.appendToGroup("group.information", (IAction)this.fRetargetShowInformationAction);
            }
            if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
                try {
                    navigateMenu.appendToGroup("show.ext", (IAction)this.fShowOutline);
                    navigateMenu.appendToGroup("show.ext", (IAction)this.fOpenHierarchy);
                }
                catch (IllegalArgumentException e) {
                    if (!DLTKCore.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        if ((gotoMenu = menu.findMenuUsingPath("navigate/goTo")) != null) {
            gotoMenu.add((IContributionItem)new Separator("additions2"));
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoPreviousMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoNextMemberAction);
            gotoMenu.appendToGroup("additions2", (IAction)this.fGotoMatchingBracket);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        this.fShowOutline.setAction(this.getAction(textEditor, "org.eclipse.dltk.mod.ui.edit.text.script.show.outline"));
        this.fOpenHierarchy.setAction(this.getAction(textEditor, "org.eclipse.dltk.mod.ui.edit.text.script.open.hierarchy"));
        this.fGotoMatchingBracket.setAction(this.getAction(textEditor, "GotoMatchingBracket"));
        this.fGotoNextMemberAction.setAction(this.getAction(textEditor, "GoToNextMember"));
        this.fGotoPreviousMemberAction.setAction(this.getAction(textEditor, "GoToPreviousMember"));
        this.fRetargetShowInformationAction.setAction(this.getAction(textEditor, "ShowInformation"));
        if (part instanceof ScriptEditor) {
            ScriptEditor editor = (ScriptEditor)part;
            editor.getActionGroup().fillActionBars(this.getActionBars());
            FoldingActionGroup foldingActions = editor.getFoldingActionGroup();
            if (foldingActions != null) {
                foldingActions.updateActionBars();
            }
        }
        IActionBars actionBars = this.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.setMessage(null);
        manager.setErrorMessage(null);
        IAction action = this.getAction(textEditor, ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.getAction(textEditor, ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
    }

    public void dispose() {
        Iterator e = this.fPartListeners.iterator();
        while (e.hasNext()) {
            this.getPage().removePartListener((IPartListener)((RetargetAction)e.next()));
        }
        this.fPartListeners.clear();
        this.setActiveEditor(null);
        super.dispose();
    }
}

