/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.typehierarchy;

import java.util.List;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.dltk.mod.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.dltk.mod.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.dltk.mod.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class SuperTypeHierarchyViewer
extends TypeHierarchyViewer {
    public SuperTypeHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part, IPreferenceStore store) {
        super(parent, (IContentProvider)new SuperTypeHierarchyContentProvider(lifeCycle), lifeCycle, part, store);
    }

    @Override
    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.SuperTypeHierarchyViewer_filtered_title;
        }
        return TypeHierarchyMessages.SuperTypeHierarchyViewer_title;
    }

    @Override
    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            this.expandAll();
        }
        this.getTree().setRedraw(true);
    }

    public static class SuperTypeHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public SuperTypeHierarchyContentProvider(TypeHierarchyLifeCycle lifeCycle) {
            super(lifeCycle);
        }

        @Override
        protected final void getTypesInHierarchy(IType type, List res) {
            IType[] types;
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null && (types = hierarchy.getSupertypes(type)) != null) {
                int i = 0;
                while (i < types.length) {
                    res.add(types[i]);
                    ++i;
                }
            }
        }

        @Override
        protected IType[] getParentType(IType type) {
            return null;
        }
    }
}

