/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.actions;

import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.mod.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.mod.internal.ui.search.SearchMessages;
import org.eclipse.dltk.mod.ui.actions.FindAction;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsAction;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsInHierarchyAction;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsInProjectAction;
import org.eclipse.dltk.mod.ui.actions.FindDeclarationsInWorkingSetAction;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.mod.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class DeclarationsSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_declarations;
    private IWorkbenchSite fSite;
    private ScriptEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindDeclarationsAction fFindDeclarationsAction;
    private FindDeclarationsInProjectAction fFindDeclarationsInProjectAction;
    private FindDeclarationsInWorkingSetAction fFindDeclarationsInWorkingSetAction;
    private FindDeclarationsInHierarchyAction fFindDeclarationsInHierarchyAction;
    private final IDLTKLanguageToolkit toolkit;

    public DeclarationsSearchGroup(IWorkbenchSite site, IDLTKLanguageToolkit tk) {
        this.fSite = site;
        this.toolkit = tk;
        this.fGroupId = "group.search";
        this.fFindDeclarationsAction = new FindDeclarationsAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.workspace");
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.project");
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.hierarchy");
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(site){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.working.set");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindDeclarationsAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInProjectAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInHierarchyAction, provider, selection);
        this.registerAction(this.fFindDeclarationsInWorkingSetAction, provider, selection);
    }

    public DeclarationsSearchGroup(ScriptEditor editor, IDLTKLanguageToolkit tk) {
        this.toolkit = tk;
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindDeclarationsAction = new FindDeclarationsAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.workspace");
        this.fEditor.setAction("SearchDeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
        this.fFindDeclarationsInProjectAction = new FindDeclarationsInProjectAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInProjectAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.project");
        this.fEditor.setAction("SearchDeclarationsInProjects", (IAction)this.fFindDeclarationsInProjectAction);
        this.fFindDeclarationsInHierarchyAction = new FindDeclarationsInHierarchyAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInHierarchyAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.hierarchy");
        this.fEditor.setAction("SearchDeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
        this.fFindDeclarationsInWorkingSetAction = new FindDeclarationsInWorkingSetAction(this.fEditor){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        };
        this.fFindDeclarationsInWorkingSetAction.setActionDefinitionId("org.eclipse.dltk.mod.ui.edit.text.script.search.declarations.in.working.set");
        this.fEditor.setAction("SearchDeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindDeclarationsInWorkingSetAction(this.fEditor, workingSets){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        }, SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindDeclarationsInWorkingSetAction(this.fSite, workingSets){

            @Override
            protected IDLTKLanguageToolkit getLanguageToolkit() {
                return DeclarationsSearchGroup.this.toolkit;
            }
        }, SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindDeclarationsAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindDeclarationsAction, provider);
            this.disposeAction(this.fFindDeclarationsInProjectAction, provider);
            this.disposeAction(this.fFindDeclarationsInHierarchyAction, provider);
            this.disposeAction(this.fFindDeclarationsInWorkingSetAction, provider);
        }
        this.fFindDeclarationsAction = null;
        this.fFindDeclarationsInProjectAction = null;
        this.fFindDeclarationsInHierarchyAction = null;
        this.fFindDeclarationsInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.DeclarationsInWorkspace", (IAction)this.fFindDeclarationsAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.DeclarationsInProject", (IAction)this.fFindDeclarationsInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.DeclarationsInHierarchy", (IAction)this.fFindDeclarationsInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.dltk.mod.ui.actions.DeclarationsInWorkingSet", (IAction)this.fFindDeclarationsInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

