/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.browsing.ext;

import org.eclipse.dltk.mod.ui.browsing.ext.ColumnForm;
import org.eclipse.dltk.mod.ui.browsing.ext.ColumnFormData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

class ColumnFormLayout
extends Layout {
    ColumnFormLayout() {
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        ColumnForm sashForm = (ColumnForm)composite;
        Control[] cArray = sashForm.getControls(true);
        int width = 0;
        int height = 0;
        if (cArray.length == 0) {
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }
        int maxValue = 0;
        int i = 0;
        while (i < cArray.length) {
            Point size = cArray[i].computeSize(-1, hHint, flushCache);
            if (size.x > maxValue) {
                maxValue = size.x;
            }
            height = Math.max(height, size.y);
            ++i;
        }
        width += sashForm.getBorderWidth() * 2;
        height += sashForm.getBorderWidth() * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean flushCache) {
        int i;
        Sash[] newSashes;
        ColumnForm columnForm = (ColumnForm)composite;
        Rectangle area = columnForm.getClientArea();
        if (area.width <= 1 || area.height <= 1) {
            return;
        }
        Control[] newControls = columnForm.getControls(true);
        if (columnForm.controls.length == 0 && newControls.length == 0) {
            Rectangle oldBounds = columnForm.getBounds();
            Rectangle bounds = columnForm.getParent().getBounds();
            if (bounds.width != 0) {
                columnForm.setBounds(oldBounds.x, oldBounds.y, bounds.width, oldBounds.height);
            }
            return;
        }
        columnForm.controls = newControls;
        Control[] controls = columnForm.controls;
        if (columnForm.sashes.length < controls.length) {
            newSashes = new Sash[controls.length];
            System.arraycopy(columnForm.sashes, 0, newSashes, 0, columnForm.sashes.length);
            i = columnForm.sashes.length;
            while (i < newSashes.length) {
                newSashes[i] = new Sash((Composite)columnForm, columnForm.columnStyle);
                newSashes[i].setBackground(columnForm.background);
                newSashes[i].setForeground(columnForm.foreground);
                newSashes[i].addListener(13, columnForm.sashListener);
                ++i;
            }
            columnForm.sashes = newSashes;
        }
        if (columnForm.sashes.length > controls.length) {
            if (controls.length == 0) {
                int i2 = 0;
                while (i2 < columnForm.sashes.length) {
                    columnForm.sashes[i2].dispose();
                    ++i2;
                }
                columnForm.sashes = new Sash[0];
            } else {
                newSashes = new Sash[controls.length];
                System.arraycopy(columnForm.sashes, 0, newSashes, 0, newSashes.length);
                i = controls.length;
                while (i < columnForm.sashes.length) {
                    columnForm.sashes[i].dispose();
                    ++i;
                }
                columnForm.sashes = newSashes;
            }
        }
        if (controls.length == 0) {
            return;
        }
        Sash[] sashes = columnForm.sashes;
        int[] widths = new int[controls.length];
        int i3 = 0;
        while (i3 < controls.length) {
            Object data = controls[i3].getLayoutData();
            if (data != null && data instanceof ColumnFormData) {
                widths[i3] = ((ColumnFormData)data).width;
            } else {
                data = new ColumnFormData();
                controls[i3].setLayoutData(data);
                widths[i3] = 200;
                ((ColumnFormData)data).width = 200;
            }
            int cfr_ignored_0 = widths[i3];
            ++i3;
        }
        int sashwidth = sashes.length > 0 ? columnForm.SASH_WIDTH + sashes[0].getBorderWidth() * 2 : columnForm.SASH_WIDTH;
        int width = widths[0];
        int x = area.x;
        controls[0].setBounds(x, area.y, width, area.height);
        x += width;
        int i4 = 1;
        while (i4 < controls.length) {
            sashes[i4 - 1].setBounds(x, area.y, sashwidth, area.height);
            width = widths[i4];
            controls[i4].setBounds(x += sashwidth, area.y, width, area.height);
            x += width;
            ++i4;
        }
        if (controls.length > 0) {
            sashes[controls.length - 1].setBounds(x, area.y, sashwidth, area.height);
        }
        Rectangle oldBounds = columnForm.getBounds();
        Rectangle bounds = columnForm.getParent().getBounds();
        if (bounds.width < x + sashwidth + 3) {
            columnForm.setBounds(oldBounds.x, oldBounds.y, x + sashwidth + 3, oldBounds.height);
        } else {
            columnForm.setBounds(oldBounds.x, oldBounds.y, bounds.width, oldBounds.height);
        }
    }
}

