/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusUtil;
import org.eclipse.dltk.mod.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public abstract class AbstractConfigurationBlock
implements IPreferenceConfigurationBlock {
    protected static final int INDENT = 20;
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private ArrayList fRadioButtons = new ArrayList();
    private Map fComboBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private SelectionListener fComboBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Combo combo = (Combo)e.widget;
            Map data = (Map)AbstractConfigurationBlock.this.fComboBoxes.get(combo);
            String key = (String)combo.getData();
            String value = (String)data.get(combo.getText());
            AbstractConfigurationBlock.this.fStore.setValue(key, value);
        }
    };
    private SelectionListener fRadioButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < AbstractConfigurationBlock.this.fRadioButtons.size()) {
                Button button = (Button)AbstractConfigurationBlock.this.fRadioButtons.get(i);
                if (button.getSelection()) {
                    String[] info = (String[])button.getData();
                    AbstractConfigurationBlock.this.fStore.setValue(info[0], Integer.parseInt(info[1]));
                }
                ++i;
            }
        }
    };
    private Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractConfigurationBlock.this.fStore.setValue((String)AbstractConfigurationBlock.this.fTextFields.get(text), text.getText());
        }
    };
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AbstractConfigurationBlock.this.numberFieldChanged((Text)e.widget);
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private StatusInfo fStatus;
    private final PreferencePage fMainPage;
    private FontMetrics fFontMetrics;

    protected Shell getShell() {
        return this.fMainPage.getShell();
    }

    public AbstractConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fMainPage = null;
    }

    public AbstractConfigurationBlock(OverlayPreferenceStore store, PreferencePage mainPreferencePage) {
        Assert.isNotNull((Object)store);
        Assert.isNotNull((Object)mainPreferencePage);
        this.fStore = store;
        this.fMainPage = mainPreferencePage;
    }

    protected final ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private final ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    protected void updateSectionStyle(ExpandableComposite excomposite) {
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    private boolean isNestedInScrolledComposite(Composite parent) {
        return this.getParentScrolledComposite((Control)parent) != null;
    }

    protected Composite createComposite(Composite parent, Font font, int columns, int hspan, int fill, int marginwidth, int marginheight) {
        return SWTFactory.createComposite(parent, font, columns, hspan, fill, marginwidth, marginheight);
    }

    protected Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        return SWTFactory.createGroup(parent, text, columns, hspan, fill);
    }

    protected Label createLabel(Composite parent, String text, int hspan) {
        return SWTFactory.createLabel(parent, text, hspan);
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.makeScrollableCompositeAware((Control)checkBox);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected Combo addComboBox(Composite parent, String label, String key, String[] items, String[] values) {
        if (values == null || items == null || label == null || items.length != values.length) {
            throw new IllegalArgumentException(PreferencesMessages.AbstractConfigurationBlock_valuesItemsAndLabelMustNotBeNull);
        }
        GridData gd = new GridData(32);
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(32);
        combo.setFont(parent.getFont());
        combo.setItems(items);
        combo.setLayoutData((Object)gd);
        combo.setData((Object)key);
        combo.addSelectionListener(this.fComboBoxListener);
        this.makeScrollableCompositeAware((Control)combo);
        HashMap<String, String> data = new HashMap<String, String>();
        int i = 0;
        while (i < items.length) {
            data.put(items[i], values[i]);
            ++i;
        }
        this.fComboBoxes.put(combo, data);
        return combo;
    }

    protected Button addRadioButton(Composite parent, String label, String key, int value) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setData((Object)new String[]{key, String.valueOf(value)});
        button.addSelectionListener(this.fRadioButtonListener);
        button.setLayoutData((Object)gd);
        button.setSelection(value == this.getPreferenceStore().getInt(key));
        this.fRadioButtons.add(button);
        return button;
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber, IInputValidator validator) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(textLimit + 2);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        if (validator != null) {
            textControl.setData((Object)validator);
        }
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return new Control[]{labelControl, textControl};
    }

    protected Control[] addLabelledTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        return this.addLabelledTextField(composite, label, key, textLimit, indentation, isNumber, null);
    }

    protected void createDependency(Button master, Control slave) {
        this.createDependency(master, new Control[]{slave});
    }

    protected void createDependency(final Button master, final Control[] slaves) {
        Assert.isTrue((slaves.length > 0 ? 1 : 0) != 0);
        AbstractConfigurationBlock.indent(slaves[0]);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = master.getSelection();
                int i = 0;
                while (i < slaves.length) {
                    slaves[i].setEnabled(state);
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        ((GridData)control.getLayoutData()).horizontalIndent += 20;
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    protected void initializeFields() {
        boolean isForTabOnly = false;
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        int i = 0;
        while (i < this.fRadioButtons.size()) {
            String val;
            Button button;
            String[] info = (String[])(button = (Button)this.fRadioButtons.get(i)).getData();
            int dflt = this.fStore.getInt(info[0]);
            button.setSelection(dflt == Integer.parseInt(val = info[1]));
            ++i;
        }
        block2: for (Combo b : this.fComboBoxes.keySet()) {
            String value = this.fStore.getString((String)b.getData());
            Map data = (Map)this.fComboBoxes.get(b);
            for (String title : data.keySet()) {
                if (!data.get(title).equals(value)) continue;
                b.setText(title);
                if (!title.equals("Tabs only")) continue block2;
                isForTabOnly = true;
                continue block2;
            }
        }
        for (Text t : this.fTextFields.keySet()) {
            String key = (String)this.fTextFields.get(t);
            t.setText(this.fStore.getString(key));
            if (!isForTabOnly || !"formatter.tabulation.size".equals(key)) continue;
            t.setEnabled(false);
            isForTabOnly = false;
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
        this.updateStatus(new StatusInfo());
    }

    @Override
    public void performOk() {
    }

    @Override
    public void performDefaults() {
        this.initializeFields();
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    @Override
    public void dispose() {
    }

    private void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IInputValidator validator = (IInputValidator)textControl.getData();
        if (validator == null) {
            IStatus status = this.validatePositiveNumber(number);
            if (!status.matches(4)) {
                this.fStore.setValue((String)this.fTextFields.get(textControl), number);
            }
            this.updateStatus(status);
        } else {
            StatusInfo status = new StatusInfo();
            String res = validator.isValid(number);
            if (res != null) {
                status.setError(res);
            } else {
                this.fStore.setValue((String)this.fTextFields.get(textControl), number);
            }
            this.updateStatus(status);
        }
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.DLTKEditorPreferencePage_empty_input);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(Messages.format(PreferencesMessages.DLTKEditorPreferencePage_invalid_input, number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(Messages.format(PreferencesMessages.DLTKEditorPreferencePage_invalid_input, number));
            }
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        if (this.fMainPage == null) {
            return;
        }
        this.fMainPage.setValid(status.isOK());
        StatusUtil.applyToStatusLine((DialogPage)this.fMainPage, status);
    }

    protected final OverlayPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    protected Composite createSubsection(Composite parent, SectionManager manager, String label) {
        if (manager != null) {
            return manager.createSection(label);
        }
        Group group = new Group(parent, 32);
        group.setText(label);
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    protected void initializeDialogUnits(Control testControl) {
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fFontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected int convertWidthInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertWidthInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected int convertHeightInCharsToPixels(int chars) {
        if (this.fFontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)this.fFontMetrics, (int)chars);
    }

    protected static class FilePathValidator
    implements IInputValidator {
        protected FilePathValidator() {
        }

        public String isValid(String newText) {
            IPath path = Path.fromOSString((String)newText);
            File file = path.toFile();
            String error = null;
            if ("".equals(newText)) {
                error = PreferencesMessages.AbstractConfigurationBlock_emptyPath;
            } else if (!file.exists()) {
                error = PreferencesMessages.AbstractConfigurationBlock_fileDoesntExist;
            } else if (!file.isFile()) {
                error = PreferencesMessages.AbstractConfigurationBlock_pathIsntAFile;
            }
            return error;
        }
    }

    protected final class SectionManager {
        private static final String __NONE = "__none";
        private Set fSections = new HashSet();
        private boolean fIsBeingManaged = false;
        private ExpansionAdapter fListener = new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrolledPageContent parentScrolledComposite;
                ExpandableComposite exComp;
                ExpandableComposite source = (ExpandableComposite)e.getSource();
                AbstractConfigurationBlock.this.updateSectionStyle(source);
                if (SectionManager.this.fIsBeingManaged) {
                    return;
                }
                if (e.getState()) {
                    try {
                        SectionManager.this.fIsBeingManaged = true;
                        for (ExpandableComposite composite : SectionManager.this.fSections) {
                            if (composite == source) continue;
                            composite.setExpanded(false);
                        }
                    }
                    finally {
                        SectionManager.this.fIsBeingManaged = false;
                    }
                    if (SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                        SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, source.getText());
                    }
                } else if (!SectionManager.this.fIsBeingManaged && SectionManager.this.fLastOpenKey != null && SectionManager.this.fDialogSettingsStore != null) {
                    SectionManager.this.fDialogSettingsStore.setValue(SectionManager.this.fLastOpenKey, SectionManager.__NONE);
                }
                if ((exComp = AbstractConfigurationBlock.this.getParentExpandableComposite((Control)source)) != null) {
                    exComp.layout(true, true);
                }
                if ((parentScrolledComposite = AbstractConfigurationBlock.this.getParentScrolledComposite((Control)source)) != null) {
                    parentScrolledComposite.reflow(true);
                }
            }
        };
        private Composite fBody;
        private final String fLastOpenKey;
        private final IPreferenceStore fDialogSettingsStore;
        private ExpandableComposite fFirstChild = null;

        public SectionManager() {
            this(null, null);
        }

        public SectionManager(IPreferenceStore dialogSettingsStore, String lastOpenKey) {
            this.fDialogSettingsStore = dialogSettingsStore;
            this.fLastOpenKey = lastOpenKey;
        }

        private void manage(ExpandableComposite section) {
            if (section == null) {
                throw new NullPointerException();
            }
            if (this.fSections.add(section)) {
                section.addExpansionListener((IExpansionListener)this.fListener);
            }
            AbstractConfigurationBlock.this.makeScrollableCompositeAware((Control)section);
        }

        public Composite createSectionComposite(Composite parent) {
            ScrolledPageContent composite;
            Assert.isTrue((this.fBody == null ? 1 : 0) != 0);
            boolean isNested = AbstractConfigurationBlock.this.isNestedInScrolledComposite(parent);
            if (isNested) {
                composite = new Composite(parent, 0);
                this.fBody = composite;
            } else {
                composite = new ScrolledPageContent(parent);
                this.fBody = composite.getBody();
            }
            this.fBody.setLayout((Layout)new GridLayout());
            return composite;
        }

        public Composite createSection(String label) {
            Assert.isNotNull((Object)this.fBody);
            ExpandableComposite excomposite = new ExpandableComposite(this.fBody, 0, 50);
            if (this.fFirstChild == null) {
                this.fFirstChild = excomposite;
            }
            excomposite.setText(label);
            String last = null;
            if (this.fLastOpenKey != null && this.fDialogSettingsStore != null) {
                last = this.fDialogSettingsStore.getString(this.fLastOpenKey);
            }
            if (this.fFirstChild == excomposite && !__NONE.equals(last) || label.equals(last)) {
                excomposite.setExpanded(true);
                if (this.fFirstChild != excomposite) {
                    this.fFirstChild.setExpanded(false);
                }
            } else {
                excomposite.setExpanded(false);
            }
            excomposite.setLayoutData((Object)new GridData(4, 1, true, false));
            AbstractConfigurationBlock.this.updateSectionStyle(excomposite);
            this.manage(excomposite);
            Composite contents = new Composite((Composite)excomposite, 0);
            excomposite.setClient((Control)contents);
            return contents;
        }
    }
}

