/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text.completion;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.mod.ui.text.completion.HTMLPrinter;

public class ProposalInfo {
    private boolean fScriptdocResolved = false;
    private String fScriptdoc = null;
    protected IModelElement fElement;
    protected String fKeyword;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    public ProposalInfo(IScriptProject scriptProject, String keyword) {
        this.fElement = scriptProject;
        this.fKeyword = keyword;
    }

    protected ProposalInfo() {
    }

    public IModelElement getModelElement() throws ModelException {
        return this.fElement;
    }

    public String getKeyword() {
        return this.fKeyword;
    }

    public String getInfo(IProgressMonitor monitor) {
        if (!this.fScriptdocResolved) {
            this.fScriptdocResolved = true;
            this.fScriptdoc = this.computeInfo(monitor);
        }
        return this.fScriptdoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            String keyword = this.getKeyword();
            if (keyword != null) {
                return this.extractScriptdoc(keyword);
            }
            IModelElement modelElement = this.getModelElement();
            if (modelElement instanceof IMember) {
                IMember member = (IMember)modelElement;
                return this.extractScriptdoc(member, monitor);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        catch (IOException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private String extractScriptdoc(String content) throws ModelException, IOException {
        IDLTKLanguageToolkit languageToolkit;
        Reader reader;
        if (content != null && this.fElement != null && (reader = ScriptDocumentationAccess.getHTMLContentReader((languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)this.fElement)).getNatureId(), content)) != null) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.addParagraph(buffer, reader);
            if (buffer.length() > 0) {
                if (!HTMLPrinter.hasEpilog(buffer)) {
                    HTMLPrinter.addPageEpilog(buffer);
                }
                return buffer.toString();
            }
        }
        return null;
    }

    private String extractScriptdoc(IMember member, IProgressMonitor monitor) throws ModelException, IOException {
        Reader reader;
        if (member != null && (reader = this.getHTMLContentReader(member, monitor)) != null) {
            return ProposalInfo.getString(reader);
        }
        return null;
    }

    private Reader getHTMLContentReader(IMember member, IProgressMonitor monitor) throws ModelException {
        String nature = null;
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)member);
        if (languageToolkit == null) {
            return null;
        }
        nature = languageToolkit.getNatureId();
        if (nature == null) {
            return null;
        }
        return ScriptDocumentationAccess.getHTMLContentReader(nature, member, true, false);
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }
}

