/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarClassData;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.jar.JarDictionary;

public class JarDictionaryUtil {
    public static void fillJarEntries(File jarFile, List<String> jarEntryNames) throws IOException {
        try {
            JarFile theFile = new JarFile(jarFile);
            Enumeration<JarEntry> e = theFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                jarEntryNames.add(jarEntry.getName());
            }
            theFile.close();
        }
        catch (ZipException zipException) {}
    }

    public static void fillJarDictionary(URL jarUrl, JarDictionary jarDictionary) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarUrl.getPath());
        }
        catch (IOException iOException) {
            return;
        }
        HashMap<String, JarClassData> jarEntryNamesSet = new HashMap<String, JarClassData>(jarFile.size() * 2 + 1);
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String resourceName = jarEntry.getName();
            jarEntryNamesSet.put(resourceName, new JarClassData(jarUrl, jarEntry.getName(), jarEntry.getCodeSigners()));
        }
        jarDictionary.setJarDictionary(jarEntryNamesSet);
        jarFile.close();
    }

    public static byte[] getBytes(InputStream in, int len) throws IOException {
        byte[] b;
        try {
            if (len != -1) {
                b = new byte[len];
                while (len > 0) {
                    int n = in.read(b, b.length - len, len);
                    if (n == -1) {
                        throw new IOException("unexpected EOF");
                    }
                    len -= n;
                }
            } else {
                byte[] tmp;
                b = new byte[1024];
                int total = 0;
                while ((len = in.read(b, total, b.length - total)) != -1) {
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
        }
        finally {
            in.close();
        }
        return b;
    }
}

