/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.dbgp.IDbgpSession;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.mod.internal.launching.LaunchConfigurationUtils;
import org.eclipse.dltk.mod.launching.sourcelookup.Messages;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceModule;
import org.eclipse.vjet.eclipse.internal.launching.VjoDBGPSourceStorage;

public class VjetDBGPSourceLookupParticipant
extends AbstractSourceLookupParticipant
implements ISourceLookupParticipant {
    public String getSourceName(Object object) throws CoreException {
        if (!(object instanceof ScriptStackFrame)) {
            return null;
        }
        ScriptStackFrame frame = (ScriptStackFrame)object;
        URI uri = frame.getFileName();
        if ("dbgp".equals(uri.getScheme())) {
            return MessageFormat.format(Messages.DBGPSourceLookupParticipant_debugResource, uri.getPath());
        }
        return uri.toString();
    }

    public Object[] findSourceElements(Object object) throws CoreException {
        if (!(object instanceof ScriptStackFrame) && !(object instanceof URI)) {
            return new Object[0];
        }
        URI uri = null;
        IDbgpSession session = null;
        if (object instanceof ScriptStackFrame) {
            ScriptStackFrame frame = (ScriptStackFrame)object;
            uri = frame.getFileName();
            session = frame.getScriptThread().getDbgpSession();
        } else {
            uri = (URI)object;
        }
        IProject project = this.getProject();
        ScriptProject scriptProject = (ScriptProject)DLTKCore.create((IProject)project);
        IScriptFolder[] folders = scriptProject.getScriptFolders();
        if (folders.length == 0) {
            return new Object[0];
        }
        IScriptFolder folder = folders[0];
        if (!"dbgp".equals(uri.getScheme())) {
            return null;
        }
        return new Object[]{new VjoDBGPSourceModule((ScriptFolder)folder, uri.getPath(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, true, new VjoDBGPSourceStorage(uri, session))};
    }

    private IProject getProject() {
        ILaunchConfiguration launchConfiguration = this.getDirector().getLaunchConfiguration();
        IProject project = LaunchConfigurationUtils.getProject((ILaunchConfiguration)launchConfiguration);
        return project;
    }
}

