/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.ui.preferences.IPreferenceConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetPreferenceMessages;

class VjetMarkOccurrencesConfigurationBlock
implements IPreferenceConfigurationBlock {
    private OverlayPreferenceStore fStore;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            VjetMarkOccurrencesConfigurationBlock.this.fStore.setValue((String)VjetMarkOccurrencesConfigurationBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private ArrayList fMasterSlaveListeners = new ArrayList();
    private StatusInfo fStatus;

    public VjetMarkOccurrencesConfigurationBlock(OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markMethodOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markFieldOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "markLocalVariableOccurrences"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "stickyOccurrences"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        String label = VjetPreferenceMessages.MarkOccurrencesConfigurationBlock_markOccurrences;
        Button master = this.addCheckBox(composite, label, "markOccurrences", 0);
        label = VjetPreferenceMessages.MarkOccurrencesConfigurationBlock_markMethodOccurrences;
        Button slave = this.addCheckBox(composite, label, "markMethodOccurrences", 0);
        this.createDependency(master, "markMethodOccurrences", (Control)slave);
        label = VjetPreferenceMessages.MarkOccurrencesConfigurationBlock_markFieldOccurrences;
        slave = this.addCheckBox(composite, label, "markFieldOccurrences", 0);
        this.createDependency(master, "markFieldOccurrences", (Control)slave);
        label = VjetPreferenceMessages.MarkOccurrencesConfigurationBlock_markLocalVariableOccurrences;
        slave = this.addCheckBox(composite, label, "markLocalVariableOccurrences", 0);
        this.createDependency(master, "markLocalVariableOccurrences", (Control)slave);
        this.addFiller(composite);
        label = VjetPreferenceMessages.MarkOccurrencesConfigurationBlock_stickyOccurrences;
        slave = this.addCheckBox(composite, label, "stickyOccurrences", 0);
        this.createDependency(master, "stickyOccurrences", (Control)slave);
        return composite;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void createDependency(final Button master, String masterKey, final Control slave) {
        VjetMarkOccurrencesConfigurationBlock.indent(slave);
        boolean masterState = this.fStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    private static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    public void initialize() {
        this.initializeFields();
    }

    void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fStore.getBoolean(key));
        }
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    public void performOk() {
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        this.initializeFields();
    }

    private void restoreFromPreferences() {
    }

    IStatus getStatus() {
        if (this.fStatus == null) {
            this.fStatus = new StatusInfo();
        }
        return this.fStatus;
    }

    public void dispose() {
    }
}

