/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.FileBinding;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.SimpleBinding;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.JstCommentHelper;
import org.eclipse.vjet.dsf.jstojava.translator.JsDocHelper;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.JavaDoc2HTMLTextReader;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.osgi.framework.Bundle;

public class VjoProposalAditionalInfoGenerator {
    private static final String PERS_FILENAME = "additionalCompletionTemplate.html";
    private static String PERS_FOLDER = "ccAdditionalPanel";
    private static String fgCSSStyles;

    public static String getAdditionalPropesalInfo(IJstNode node) {
        String info = null;
        String css = VjoProposalAditionalInfoGenerator.getCSSStyles();
        ArrayList<String> allSupportedExplorers = new ArrayList<String>();
        IJstProperty property = null;
        IJstMethod method = null;
        if (node instanceof IJstProperty) {
            property = (IJstProperty)node;
        } else if (node instanceof IJstMethod) {
            method = (IJstMethod)node;
        }
        String briefInfo = "";
        if (property != null && VjoProposalAditionalInfoGenerator.isBindingOk(property.getOwnerType().getSource()) && property.getCommentLocations() != null && !node.getCommentLocations().isEmpty()) {
            List strings = JstCommentHelper.getCommentsAsString((IJstType)node.getOwnerType(), (List)node.getCommentLocations());
            StringBuilder sb = new StringBuilder();
            for (String str : strings) {
                if (str != null) {
                    sb.append(JsDocHelper.cleanJsDocComment((String)str));
                }
                sb.append("<br>");
            }
            info = sb.toString();
            briefInfo = VjoProposalAditionalInfoGenerator.getElementBriefDesc(property);
            VjoProposalAditionalInfoGenerator.fillAllSupportedExplorer(property, allSupportedExplorers);
        } else if (method != null && method.getDoc() != null) {
            info = method.getDoc().getComment();
            briefInfo = VjoProposalAditionalInfoGenerator.getElementBriefDesc(method);
            VjoProposalAditionalInfoGenerator.fillAllSupportedExplorer(method, allSupportedExplorers);
        } else if (property != null && property.getDoc() != null) {
            info = property.getDoc().getComment();
            briefInfo = VjoProposalAditionalInfoGenerator.getElementBriefDesc(property);
            VjoProposalAditionalInfoGenerator.fillAllSupportedExplorer(property, allSupportedExplorers);
        }
        if (info != null) {
            try {
                File persFile = VjoProposalAditionalInfoGenerator.getTemplateFile();
                if (!persFile.exists()) {
                    try {
                        persFile.createNewFile();
                    }
                    catch (IOException iOException) {}
                    VjoProposalAditionalInfoGenerator.copyHtmlTemplateFromBundleToTemp();
                    VjoProposalAditionalInfoGenerator.copyIconsFromBundleToTemp();
                }
                info = info.replace("/", "");
                info = info.replace("*", "");
                if (persFile != null) {
                    FileReader readerSuc = new FileReader(persFile);
                    JavaDoc2HTMLTextReader reader2 = new JavaDoc2HTMLTextReader(readerSuc);
                    String wholeInfo = VjoProposalAditionalInfoGenerator.getString((Reader)((Object)reader2));
                    wholeInfo = wholeInfo.replace("<%=browserSupported%>", VjoProposalAditionalInfoGenerator.getSupportedTypesStirng(allSupportedExplorers, "BrowserType."));
                    String domLevel = VjoProposalAditionalInfoGenerator.getSupportedTypesStirng(allSupportedExplorers, "DomLevel.");
                    wholeInfo = domLevel.length() > 0 ? wholeInfo.replace("<%=DOMLevel%>", "<b>DOM level</b><br>" + VjoProposalAditionalInfoGenerator.getSupportedTypesStirng(allSupportedExplorers, "DomLevel.") + "<br>") : wholeInfo.replace("<%=DOMLevel%>", "");
                    wholeInfo = wholeInfo.replace("<%=MinJSVersion%>", VjoProposalAditionalInfoGenerator.translateCharacterToNumber(VjoProposalAditionalInfoGenerator.getSupportedTypesStirng(allSupportedExplorers, "JsVersion.")));
                    wholeInfo = wholeInfo.replace("<%=briefInfo%>", briefInfo);
                    wholeInfo = wholeInfo.replace("<%=images%>", VjoProposalAditionalInfoGenerator.getIcon(allSupportedExplorers));
                    wholeInfo = wholeInfo.replace("<%=description%>", info);
                    StringBuffer buffer = new StringBuffer();
                    HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)css);
                    buffer.append(wholeInfo);
                    HTMLPrinter.addPageEpilog((StringBuffer)buffer);
                    wholeInfo = buffer.toString();
                    return wholeInfo;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return info;
    }

    private static boolean isBindingOk(JstSource source) {
        if (source != null && source.getBinding() != null) {
            if (source.getBinding() instanceof FileBinding) {
                return ((FileBinding)source.getBinding()).getFile() != null;
            }
            if (source.getBinding() instanceof SimpleBinding) {
                return ((SimpleBinding)source.getBinding()).toText() != null;
            }
        }
        return false;
    }

    private static String getCSSStyles() {
        String css;
        Bundle bundle;
        URL url;
        if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)"org.eclipse.vjet.eclipse.ui")).getEntry("/DocumentationHoverStyleSheet.css")) != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgCSSStyles = buffer.toString();
            }
            catch (IOException ex) {
                DLTKUIPlugin.log((Throwable)ex);
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.mod.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    public static String getElementBriefDesc(IJstProperty property) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(property.getOwnerType().getName()) + "\n");
        buffer.append(String.valueOf(VjoProposalAditionalInfoGenerator.getModifierListStr(property.getModifiers())) + " <b>");
        buffer.append(property.getName() + "</b> ");
        return buffer.toString();
    }

    public static String getElementBriefDesc(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        String rtnTypeName = "";
        IJstType rtnType = method.getRtnType();
        if (rtnType != null) {
            rtnTypeName = rtnType.getName();
        }
        buffer.append(" <b>" + rtnTypeName + "</b> ");
        buffer.append(String.valueOf(VjoProposalAditionalInfoGenerator.getModifierListStr(method.getModifiers())) + " " + method.getName());
        buffer.append("(" + VjoProposalAditionalInfoGenerator.combineParameters(method) + ")");
        return buffer.toString();
    }

    private static String combineParameters(IJstMethod method) {
        String par = "";
        if (method != null) {
            List args = method.getArgs();
            String comma = "";
            int i = 0;
            for (JstArg arg : args) {
                if (i != 0) {
                    comma = ", ";
                }
                par = String.valueOf(par) + comma + arg.getType().getSimpleName() + " " + arg.getName();
                ++i;
            }
        }
        return par;
    }

    public static String getModifierListStr(JstModifiers jstModifiers) {
        List list = jstModifiers.getChildren();
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            BaseJstNode cfr_ignored_0 = (BaseJstNode)it.next();
            buffer.append("");
        }
        return buffer.toString();
    }

    private static String getSupportedTypesStirng(List<String> supportedTypes, String type) {
        String imageLine = "";
        String comma = "";
        int i = 0;
        for (String oneType : supportedTypes) {
            if (!oneType.startsWith(type)) continue;
            if (i != 0) {
                comma = ", ";
            }
            imageLine = String.valueOf(imageLine) + comma + oneType.substring(type.length());
            ++i;
        }
        boolean noBrowserInfo = VjoProposalAditionalInfoGenerator.noBrowserInfo(supportedTypes);
        if (noBrowserInfo) {
            "BrowserType.".equals(type);
        }
        return imageLine;
    }

    private static String getIcon(List<String> supportedTypes) {
        String imageLine = "";
        String path = VjoProposalAditionalInfoGenerator.getDir().getPath();
        boolean noBrowserInfo = false;
        if (VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "FIREFOX").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/firefox.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "MOZILLA") + "\">";
        }
        if (VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "IE").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/ie.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "IE") + "\">";
        }
        if (VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "OPERA").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/opera.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "OPERA") + "\">";
        }
        if (VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "SAFARI").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/safari.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "SAFARI") + "\">";
        }
        if (VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "CHROME").trim().length() > 0 || noBrowserInfo) {
            imageLine = String.valueOf(imageLine) + "<img aligh=\"right\" src=\"" + path + "/chrome.gif\" height=\"25\" width=\"25\" border=\"0\" title=\"" + VjoProposalAditionalInfoGenerator.getDescOfSupport(supportedTypes, "CHROME") + "\">";
        }
        return imageLine;
    }

    private static boolean noBrowserInfo(List supportedTypes) {
        boolean noBrowserInfo = true;
        for (Object type : supportedTypes) {
            if (!((String)type).contains("BrowserType.")) continue;
            noBrowserInfo = false;
            break;
        }
        return noBrowserInfo;
    }

    private static List<String> fillAllSupportedExplorer(Object jstElement, List<String> allSupportedExplorers) {
        if (jstElement instanceof IJstProperty) {
            List annotations = ((IJstProperty)jstElement).getAnnotations();
            VjoProposalAditionalInfoGenerator.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
            if (annotations.size() == 0) {
                VjoProposalAditionalInfoGenerator.fillAllSupportedExplorer(((IJstProperty)jstElement).getOwnerType(), allSupportedExplorers);
            }
        } else if (jstElement instanceof IJstMethod) {
            List annotations = ((IJstMethod)jstElement).getAnnotations();
            VjoProposalAditionalInfoGenerator.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
            if (annotations.size() == 0) {
                VjoProposalAditionalInfoGenerator.fillAllSupportedExplorer(((IJstMethod)jstElement).getOwnerType(), allSupportedExplorers);
            }
        } else if (jstElement instanceof IJstType) {
            List annotations = ((IJstType)jstElement).getAnnotations();
            VjoProposalAditionalInfoGenerator.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
        }
        return allSupportedExplorers;
    }

    public static boolean isBrowserNoneNode(IJstNode node) {
        if (!(node instanceof IJstMethod) && !(node instanceof IJstProperty)) {
            return false;
        }
        List annotations = node.getAnnotations();
        if (annotations.size() != 1) {
            return false;
        }
        ArrayList<String> allSupportedExplorers = new ArrayList<String>();
        VjoProposalAditionalInfoGenerator.getExplorerInfoFromAnnotation(allSupportedExplorers, annotations);
        return allSupportedExplorers.size() != 0 && "BrowserType.NONE".equals(allSupportedExplorers.get(0));
    }

    static void getExplorerInfoFromAnnotation(List<String> allSupportedExplorers, List<IJstAnnotation> annotations) {
        for (IJstAnnotation annotation : annotations) {
            if ((!(annotation instanceof JstAnnotation) || !"JsSupport".equals(((JstAnnotation)annotation).getName().getName())) && !"BrowserSupport".equals(((JstAnnotation)annotation).getName().getName()) && !"DOMSupport".equals(((JstAnnotation)annotation).getName().getName())) continue;
            for (IExpr expr : ((JstAnnotation)annotation).values()) {
                JstArrayInitializer init;
                String typeString;
                String typeName;
                if (expr instanceof JstIdentifier && !allSupportedExplorers.contains(typeName = expr.toExprText())) {
                    allSupportedExplorers.add(typeName);
                }
                if (expr instanceof JstArrayInitializer && (typeString = (init = (JstArrayInitializer)expr).toExprText()).length() > 1) {
                    String[] type;
                    if (typeString.startsWith("[") && typeString.endsWith("]")) {
                        typeString = typeString.substring(1, typeString.length() - 1);
                    }
                    String[] stringArray = type = typeString.split(",");
                    int n = type.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String typeName2 = stringArray[n2];
                        if (!allSupportedExplorers.contains(typeName2)) {
                            allSupportedExplorers.add(typeName2);
                        }
                        ++n2;
                    }
                }
                if (!(expr instanceof AssignExpr)) continue;
                List supportTypes = ((AssignExpr)expr).getExpr().getChildren();
                for (Object supportType : supportTypes) {
                    String[] type;
                    String typeString2;
                    if (!(supportType instanceof JstIdentifier) || (typeString2 = ((JstIdentifier)supportType).getParentNode().toString()).length() <= 1) continue;
                    if (typeString2.startsWith("[") && typeString2.endsWith("]")) {
                        typeString2 = typeString2.substring(1, typeString2.length() - 1);
                    }
                    String[] stringArray = type = typeString2.split(",");
                    int n = type.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String typeName3 = stringArray[n3];
                        if (!allSupportedExplorers.contains(typeName3)) {
                            allSupportedExplorers.add(typeName3);
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private static void copyHtmlTemplateFromBundleToTemp() {
        String[] htmlFiles;
        String[] stringArray = htmlFiles = new String[]{PERS_FILENAME};
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            VjoProposalAditionalInfoGenerator.copyFileFromBundleToTemp("templates", file);
            ++n2;
        }
    }

    private static void copyIconsFromBundleToTemp() {
        String[] icons;
        String[] stringArray = icons = new String[]{"chrome.gif", "firefox.gif", "ie.gif", "opera.gif", "safari.gif"};
        int n = icons.length;
        int n2 = 0;
        while (n2 < n) {
            String icon = stringArray[n2];
            VjoProposalAditionalInfoGenerator.copyFileFromBundleToTemp("icons", icon);
            ++n2;
        }
    }

    private static File getDir() {
        File dir = VjetUIPlugin.getDefault().getStateLocation().toFile();
        if (!(dir = new File(dir, PERS_FOLDER)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getTemplateFile() {
        File dir = VjoProposalAditionalInfoGenerator.getDir();
        File persFile = new File(dir, PERS_FILENAME);
        return persFile;
    }

    private static void copyFileFromBundleToTemp(String folderName, String fileName) {
        try {
            File persFile = new File(VjoProposalAditionalInfoGenerator.getDir(), fileName);
            URL url = VjetUIPlugin.getDefault().getBundle().getEntry(String.valueOf(folderName) + "/" + fileName);
            InputStream stream = url.openStream();
            byte[] bs = new byte[stream.available()];
            stream.read(bs);
            FileOutputStream fop = new FileOutputStream(persFile);
            if (persFile.exists()) {
                fop.write(bs);
                fop.flush();
                fop.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static String getDescOfSupport(List<String> supportedTypes, String type) {
        for (String everyType : supportedTypes) {
            if (!everyType.contains(type)) continue;
            return everyType;
        }
        return "";
    }

    private static String translateCharacterToNumber(String desc) {
        if (desc != null) {
            String[] numbers = new String[]{"_ZERO", "_ONE", "_TWO", "_THREE", "_FOUR", "_FIVE", "_SIX", "_SEVEN", "_EIGHT", "_NINE"};
            int i = 0;
            while (i < numbers.length) {
                if (desc.contains(numbers[i])) {
                    desc = desc.replace(numbers[i], String.valueOf(i));
                }
                ++i;
            }
            if (desc.contains("_DOT")) {
                desc = desc.replace("_DOT", ".");
            }
        }
        return desc;
    }

    private static void generateTempFolder(URL baseUrl, boolean create) {
        if (baseUrl == null) {
            return;
        }
        try {
            URL url = new URL(baseUrl, PERS_FOLDER);
            File dir = new File(url.getFile());
            if (!dir.exists() && create) {
                dir.mkdir();
            }
        }
        catch (IOException iOException) {}
    }
}

