/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ILog;
import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ISourceReference;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.corext.SourceRange;
import org.eclipse.dltk.mod.ui.text.folding.AbstractASTFoldingStructureProvider;
import org.eclipse.dltk.mod.ui.text.folding.IElementCommentResolver;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IJSType;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.IScanner;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.PublicScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.IJavaScriptPartitions;
import org.eclipse.vjet.eclipse.internal.ui.text.JavascriptPartitionScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.folding.VjetElementCommentResolver;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjoFoldingStructureProvider
extends AbstractASTFoldingStructureProvider {
    private boolean m_CollapseImportContainer = true;
    private boolean m_CollapseJavadoc = false;
    private boolean m_CollapseInnerTypes = false;
    private boolean m_CollapseMembers = false;
    private boolean m_CollapseHeaderComments = true;

    protected String[] getCommentPartition() {
        return new String[]{"__javascript_multi_comment", "__javascript_doc"};
    }

    protected ILog getLog() {
        return null;
    }

    protected String getNatureId() {
        return "org.eclipse.vjet.core.nature";
    }

    protected String getPartition() {
        return "__javascript_partitioning";
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return new JavascriptPartitionScanner();
    }

    protected String[] getPartitionTypes() {
        return IJavaScriptPartitions.JS_PARTITION_TYPES;
    }

    protected boolean initiallyCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return false;
    }

    protected boolean mayCollapse(ASTNode s, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) {
        return false;
    }

    protected boolean computeFoldingStructure(String contents, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx2) {
        FoldingStructureComputationContext2 ctx = (FoldingStructureComputationContext2)ctx2;
        try {
            IModelElement element = this.getInputElement();
            if (CodeassistUtils.isVjoSourceModule((IModelElement)element) && CodeassistUtils.isModuleInBuildPath((IModelElement)element)) {
                IModelElement[] elements = ((IParent)this.getInputElement()).getChildren();
                this.computeFoldingStructure(elements, (AbstractASTFoldingStructureProvider.FoldingStructureComputationContext)ctx);
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
            return false;
        }
        if (this.fCommentsFolding) {
            IRegion[] commentRegions = this.computeCommentsRanges(contents);
            if (commentRegions.length == 0) {
                return true;
            }
            HashMap<Position, AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation> typeAnnotationList = new HashMap<Position, AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation>();
            int i = 0;
            while (i < commentRegions.length) {
                Position position;
                IRegion normalized = this.alignRegion(commentRegions[i], ctx);
                if (normalized != null && (position = this.createCommentPosition(normalized)) != null) {
                    int hash = contents.substring(normalized.getOffset(), normalized.getOffset() + normalized.getLength()).hashCode();
                    IModelElement element = null;
                    IElementCommentResolver res = this.getElementCommentResolver();
                    if (res != null && this.fInput != null) {
                        element = res.getElementByCommentPosition((ISourceModule)this.fInput, position.offset, position.length);
                    }
                    boolean toAdd = this.initiallyCollapseComments(normalized, ctx);
                    AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation annotation = new AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation(toAdd, true, new AbstractASTFoldingStructureProvider.SourceRangeStamp(hash, normalized.getLength()), element);
                    typeAnnotationList.put(position, annotation);
                    if (element instanceof IType && !this.isInnerType((IType)element) && !ctx.hasFirstType()) {
                        ctx.setFirstType((IType)element);
                    }
                }
                ++i;
            }
            this.handleHeaderComment(ctx, contents, typeAnnotationList);
            Set positionSet = typeAnnotationList.keySet();
            for (Position pos : positionSet) {
                ctx.addProjectionRange((AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation)typeAnnotationList.get(pos), pos);
            }
        }
        return true;
    }

    private void handleHeaderComment(FoldingStructureComputationContext2 ctx, String contents, Map<Position, AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation> typeAnnotationMap) {
        try {
            if (!ctx.hasHeaderComment() && this.fInput != null && ((ISourceModule)this.fInput).hasChildren()) {
                Set<Position> positionSet;
                List<Position> positions;
                ISourceModule module = (ISourceModule)this.fInput;
                int firstElementOffset = this.getFirstElementOffset(module);
                List<Position> headerCommentPositions = this.getHeaderCommentList(firstElementOffset, positions = this.getSortedPositionList(positionSet = typeAnnotationMap.keySet()));
                if (headerCommentPositions == null || headerCommentPositions.isEmpty()) {
                    return;
                }
                ctx.setHasHeaderComment();
                if (headerCommentPositions.size() > 1) {
                    Position lastHeaderComment = headerCommentPositions.get(headerCommentPositions.size() - 1);
                    IModelElement firstElement = typeAnnotationMap.get(lastHeaderComment).getElement();
                    int newOffset = headerCommentPositions.get((int)0).offset;
                    int newLength = lastHeaderComment.getOffset() + lastHeaderComment.getLength() - newOffset;
                    Position newHeaderCommentPosition = this.createCommentPosition((IRegion)new Region(newOffset, newLength));
                    int hash = contents.substring(newOffset, newOffset + newLength).hashCode();
                    AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation newHeaderCommentAnnotation = new AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation(ctx.collapseHeaderComments(), true, new AbstractASTFoldingStructureProvider.SourceRangeStamp(hash, newLength), firstElement);
                    for (Position p : headerCommentPositions) {
                        typeAnnotationMap.remove(p);
                    }
                    typeAnnotationMap.put(newHeaderCommentPosition, newHeaderCommentAnnotation);
                } else {
                    AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation headerCommentAnno = typeAnnotationMap.get(headerCommentPositions.get(0));
                    if (ctx.collapseHeaderComments()) {
                        headerCommentAnno.markCollapsed();
                    } else {
                        headerCommentAnno.markExpanded();
                    }
                }
            }
        }
        catch (ModelException e) {
            VjetUIPlugin.log((Exception)((Object)e));
        }
    }

    private List<Position> getHeaderCommentList(int firstElementOffset, List<Position> positions) {
        List<Position> headerCommentPositions = null;
        int len = positions.size();
        int i = -1;
        i = 0;
        while (i < len) {
            if (firstElementOffset < positions.get(i).getOffset()) {
                headerCommentPositions = positions.subList(0, i);
                break;
            }
            ++i;
        }
        if (i == len) {
            headerCommentPositions = positions;
        }
        return headerCommentPositions;
    }

    private List<Position> getSortedPositionList(Set<Position> positionSet) {
        ArrayList<Position> positions = new ArrayList<Position>(positionSet);
        if (positionSet.size() > 1) {
            Collections.sort(positions, new Comparator<Position>(){

                @Override
                public int compare(Position o1, Position o2) {
                    return o1.getOffset() - o2.getOffset();
                }
            });
        }
        return positions;
    }

    private int getFirstElementOffset(ISourceModule module) throws ModelException {
        int firstElementOffset = -1;
        if (module.hasChildren()) {
            IModelElement[] children;
            ArrayList<ISourceRange> ranges = new ArrayList<ISourceRange>();
            IModelElement[] iModelElementArray = children = module.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                if (child instanceof ISourceReference) {
                    ranges.add(((ISourceReference)child).getSourceRange());
                }
                ++n2;
            }
            if (ranges.size() > 0) {
                Collections.sort(ranges, new Comparator<ISourceRange>(){

                    @Override
                    public int compare(ISourceRange object1, ISourceRange object2) {
                        return object1.getOffset() - object2.getOffset();
                    }
                });
                firstElementOffset = ((ISourceRange)ranges.get(0)).getOffset();
            }
        }
        return firstElementOffset;
    }

    protected boolean initiallyCollapseComments(IRegion commentRegion, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx2) {
        FoldingStructureComputationContext2 ctx = (FoldingStructureComputationContext2)ctx2;
        return ctx.collapseJavadoc() && ctx.allowCollapsing();
    }

    private void computeFoldingStructure(IModelElement[] elements, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx) throws ModelException {
        int i = 0;
        while (i < elements.length) {
            IModelElement element = elements[i];
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++i;
        }
    }

    public IElementCommentResolver getElementCommentResolver() {
        return new VjetElementCommentResolver();
    }

    protected AbstractASTFoldingStructureProvider.FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return new FoldingStructureComputationContext2(doc, model, allowCollapse);
    }

    private boolean isAnonymousEnum(IType type) {
        if (type instanceof IJSType) {
            IJSType jsType = (IJSType)type;
            try {
                return jsType.isEnum() && jsType.getElementName().length() == 0;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        return false;
    }

    private boolean isInnerType(IType type) {
        return type.getDeclaringType() != null && !this.isAnonymousEnum(type);
    }

    protected void computeFoldingStructure(IModelElement element, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx2) {
        IRegion normalized;
        FoldingStructureComputationContext2 ctx = (FoldingStructureComputationContext2)ctx2;
        boolean collapse = false;
        boolean collapseCode = true;
        switch (element.getElementType()) {
            case 12: {
                collapse = ctx.allowCollapsing() && this.m_CollapseImportContainer;
                break;
            }
            case 7: {
                collapseCode = this.isInnerType((IType)element);
                collapse = ctx.collapseInnerTypes() && collapseCode;
                break;
            }
            case 8: 
            case 9: {
                collapse = ctx.allowCollapsing() && this.m_CollapseMembers;
                break;
            }
            case 11: {
                collapse = ctx.allowCollapsing() && this.m_CollapseMembers;
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] regions = this.computeProjectionRanges((ISourceReference)element, ctx);
        if (regions.length > 0 && collapseCode && (normalized = this.alignRegion(regions[regions.length - 1], ctx)) != null) {
            Position position;
            Position position2 = position = element instanceof IMember ? this.createMemberPosition(normalized, (IMember)element) : this.createCommentPosition(normalized);
            if (position != null) {
                ctx.addProjectionRange(new AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation(collapse, false, new AbstractASTFoldingStructureProvider.SourceRangeStamp(0, position.length), element), position);
            }
        }
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference reference, AbstractASTFoldingStructureProvider.FoldingStructureComputationContext ctx2) {
        try {
            ISourceRange actuallyMemberSourceRange;
            FoldingStructureComputationContext2 cfr_ignored_0 = (FoldingStructureComputationContext2)ctx2;
            ISourceRange range = reference.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return new IRegion[0];
            }
            String contents = reference.getSource();
            if (contents == null) {
                return new IRegion[0];
            }
            if (reference instanceof IType && this.isInnerType((IType)reference)) {
                IType innerType = (IType)reference;
                innerType.getSourceRange();
            }
            if (reference instanceof IMethod && (actuallyMemberSourceRange = ((IMember)reference).getNameRange()).getOffset() > range.getOffset()) {
                int end = range.getOffset() + range.getLength();
                range = new SourceRange(actuallyMemberSourceRange.getOffset(), end - actuallyMemberSourceRange.getOffset());
            }
            ArrayList<Region> regions = new ArrayList<Region>();
            regions.add(new Region(range.getOffset(), range.getLength()));
            IRegion[] result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new IRegion[0];
        }
    }

    protected final Position createMemberPosition(IRegion aligned, IMember member) {
        return new ScriptElementPosition(aligned.getOffset(), aligned.getLength());
    }

    protected void initializePreferences(IPreferenceStore store) {
        this.m_CollapseInnerTypes = store.getBoolean("editor_folding_default_innertypes");
        this.m_CollapseImportContainer = store.getBoolean("editor_folding_default_imports");
        this.m_CollapseJavadoc = store.getBoolean("editor_folding_default_javadoc");
        this.m_CollapseMembers = store.getBoolean("editor_folding_default_methods");
        this.m_CollapseHeaderComments = store.getBoolean("editor_folding_default_headers");
        super.initializePreferences(store);
    }

    protected AbstractASTFoldingStructureProvider.CodeBlock[] getCodeBlocks(String code, int offset) {
        return null;
    }

    protected final class FoldingStructureComputationContext2
    extends AbstractASTFoldingStructureProvider.FoldingStructureComputationContext {
        private IType fFirstType;
        private boolean fHasHeaderComment;
        private IScanner fScanner;

        public FoldingStructureComputationContext2(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing) {
            super((AbstractASTFoldingStructureProvider)VjoFoldingStructureProvider.this, document, model, allowCollapsing);
        }

        private void setFirstType(IType type) {
            if (this.hasFirstType()) {
                throw new IllegalStateException();
            }
            this.fFirstType = type;
        }

        boolean hasFirstType() {
            return this.fFirstType != null;
        }

        private IType getFirstType() {
            return this.fFirstType;
        }

        private boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        private void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        private IScanner getScanner() {
            if (this.fScanner == null) {
                this.fScanner = new PublicScanner(true, false, false, 4L, null, null, true);
            }
            return this.fScanner;
        }

        public void addProjectionRange(AbstractASTFoldingStructureProvider.ScriptProjectionAnnotation annotation, Position position) {
            this.fMap.put(annotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.allowCollapsing() && VjoFoldingStructureProvider.this.m_CollapseHeaderComments;
        }

        public boolean collapseImportContainer() {
            return this.allowCollapsing() && VjoFoldingStructureProvider.this.m_CollapseImportContainer;
        }

        public boolean collapseInnerTypes() {
            return this.allowCollapsing() && VjoFoldingStructureProvider.this.m_CollapseInnerTypes;
        }

        public boolean collapseJavadoc() {
            return this.allowCollapsing() && VjoFoldingStructureProvider.this.m_CollapseJavadoc;
        }

        public boolean collapseMembers() {
            return this.allowCollapsing() && VjoFoldingStructureProvider.this.m_CollapseMembers;
        }
    }

    private static final class ScriptElementPosition
    extends Position
    implements IProjectionPosition {
        public ScriptElementPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int nameStart = this.offset;
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            return 0;
        }
    }
}

