/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.view.scriptunit;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalFileEditorInput;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.INodePrinter;
import org.eclipse.vjet.eclipse.internal.ui.nodeprinter.NodePrinterFactory;
import org.eclipse.vjet.eclipse.internal.ui.view.scriptunit.CheckNodeAction;
import org.eclipse.vjet.eclipse.internal.ui.view.scriptunit.JstAstInfoVisitor;
import org.eclipse.vjet.eclipse.internal.ui.view.scriptunit.ScriptUnitTreeContentProvider;
import org.eclipse.vjet.eclipse.internal.ui.view.scriptunit.ScriptUnitTreeLabelProvider;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class ScriptUnitView
extends ViewPart
implements ISelectionListener {
    private TreeViewer viewer;
    private Label offsetLabel;
    private VjoEditor vjoEditor;
    private IPartListener partListener = new PartListener();
    private IDocumentListener documentListener = new DocumentListener();
    private IJstType jstType;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(parent);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)new ScriptUnitTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScriptUnitTreeLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                if (!(structuredSelection.getFirstElement() instanceof IJstNode)) {
                    return;
                }
                IJstNode jstNode = (IJstNode)structuredSelection.getFirstElement();
                JstSource jstSource = jstNode.getSource();
                if (jstSource == null) {
                    return;
                }
                ScriptUnitView.this.vjoEditor.getScriptSourceViewer().revealRange(jstSource.getStartOffSet(), jstSource.getLength());
                ScriptUnitView.this.vjoEditor.getScriptSourceViewer().setSelectedRange(jstSource.getStartOffSet(), jstSource.getLength());
            }
        });
        this.offsetLabel = new Label(parent, 4);
        this.offsetLabel.setLayoutData((Object)new GridData(768));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.fillActionBar();
        this.initContextMenu();
    }

    private void fillActionBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)new CheckNodeAction(this.viewer));
    }

    private void initContextMenu() {
        MenuManager popupMenuManager = new MenuManager("#PopupMenu");
        popupMenuManager.add((IAction)new Action("Copy Structure"){

            public void run() {
                Object selectedNode = ((IStructuredSelection)ScriptUnitView.this.viewer.getSelection()).getFirstElement();
                String structure = ScriptUnitView.this.copyStructure(selectedNode, 0);
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{structure}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        popupMenuManager.add((IAction)new Action("Copy Properties"){

            public void run() {
                Object selectedNode = ((IStructuredSelection)ScriptUnitView.this.viewer.getSelection()).getFirstElement();
                String properties = ScriptUnitView.this.copyProperties(selectedNode);
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{properties}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        popupMenuManager.add((IAction)new Action("Copy XPath"){

            public void run() {
                Object selectedNode = ((IStructuredSelection)ScriptUnitView.this.viewer.getSelection()).getFirstElement();
                String xpath = "";
                if (selectedNode instanceof IJstNode) {
                    IJstNode node = (IJstNode)selectedNode;
                    ITreeContentProvider contentProvider = (ITreeContentProvider)ScriptUnitView.this.viewer.getContentProvider();
                    xpath = ScriptUnitView.this.getXPathTestString(node, contentProvider);
                    System.out.println("Here is my XPath === : \n" + xpath);
                }
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{xpath}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        Menu popupMenu = popupMenuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(popupMenu);
        this.getSite().registerContextMenu(popupMenuManager, (ISelectionProvider)this.viewer);
    }

    private String getXPathTestString(IJstNode node, ITreeContentProvider contentProvider) {
        StringBuffer testString = new StringBuffer("<testcase number='1'>\n\t");
        node.getOwnerType().getName();
        testString.append("<file>" + node.getRootType().getName() + "</file>\n\t");
        testString.append("<jxpath>\n\t\t");
        String nodeToPut = "";
        nodeToPut = this.getNodeName(node).equals("") ? node.getClass().getSimpleName() : String.valueOf(node.getClass().getSimpleName()) + "[@Name='" + this.getNodeName(node) + "']";
        String str = this.getXPath(nodeToPut, node, contentProvider);
        testString.append("<pathname>" + str + "</pathname>\n\t\t");
        testString.append("<nodecount>1</nodecount>\n\t\t");
        testString.append("<node position='1' status='pass'>\n\t\t\t");
        if (node instanceof JstIdentifier) {
            IJstNode bNode = ((JstIdentifier)node).getJstBinding();
            String bName = ScriptUnitView.getNodeName(bNode);
            String bType = this.getTypeList(bNode);
            String bClass = bNode.getClass().getSimpleName();
            String bParent = this.getTypeList(bNode.getParentNode());
            System.out.println(String.valueOf(bName) + " ; " + bType + " ; " + bClass + " ; " + bParent);
            testString.append("<bindingnode>" + ScriptUnitView.getNodeName(bNode) + "</bindingnode>\n\t\t\t");
            testString.append("<bindingtype>" + this.getTypeList(bNode) + "</bindingtype>\n\t\t\t");
            testString.append("<bindingclass>" + bNode.getClass().getSimpleName() + "</bindingclass>\n\t\t\t");
            testString.append("<bindingparent>" + this.getTypeList(bNode.getParentNode()) + "</bindingparent>\n\t\t");
        } else {
            testString.append("<bindingnode>" + ScriptUnitView.getNodeName(node) + "</bindingnode>\n\t\t\t");
            testString.append("<bindingtype>" + this.getTypeList(node) + "</bindingtype>\n\t\t");
        }
        testString.append("</node>\n\t");
        testString.append("</jxpath>\n");
        testString.append("</testcase>");
        return testString.toString();
    }

    private String getXPath(String str, Object obj, ITreeContentProvider contentProvider) {
        String returnStr = "";
        if (contentProvider.getParent(obj) != null) {
            Object parent = contentProvider.getParent(obj);
            String addIt = "";
            addIt = this.getNodeName(parent).equals("") ? parent.getClass().getSimpleName() : String.valueOf(parent.getClass().getSimpleName()) + "[@Name='" + this.getNodeName(parent) + "']";
            if (this.getNodeName(obj).equals("") && this.getPosition((IJstNode)obj, (IJstNode)parent) > 1) {
                str = str.indexOf("/") == -1 ? String.valueOf(str) + "[@Position='" + this.getPosition((IJstNode)obj, (IJstNode)parent) + "']" : str.replaceFirst("/", "[@Position='" + this.getPosition((IJstNode)obj, (IJstNode)parent) + "']/");
            }
            str = String.valueOf(addIt) + "/" + str;
            if (parent.getClass().getSimpleName().equals(JstType.class.getSimpleName())) {
                return str;
            }
            returnStr = this.getXPath(str, parent, contentProvider);
        }
        return returnStr;
    }

    private int getPosition(IJstNode child, IJstNode parent) {
        int position = 0;
        for (IJstNode node : parent.getChildren()) {
            if (!node.getClass().equals(child.getClass())) continue;
            ++position;
            if (ScriptUnitView.getNodeName(node).equals(ScriptUnitView.getNodeName(child))) break;
        }
        return position;
    }

    private static String getNodeName(IJstNode node) {
        String value = null;
        try {
            JstAstInfoVisitor visitor = new JstAstInfoVisitor();
            Method method = JstAstInfoVisitor.class.getMethod("visit", node.getClass());
            method.invoke((Object)visitor, node);
            value = visitor.getValue();
        }
        catch (Exception exception) {}
        return value;
    }

    private String getNodeName(Object node) {
        String str = "";
        if (node instanceof JstMethod) {
            str = ((JstMethod)node).getName().getName();
        } else if (node instanceof JstProperty) {
            str = ((JstProperty)node).getName().getName();
        } else if (node instanceof JstIdentifier) {
            str = ((JstIdentifier)node).getName();
        } else if (node instanceof SimpleLiteral) {
            str = ((SimpleLiteral)node).getValue();
        }
        return str;
    }

    private String getTypeList(IJstNode node) {
        String retStr = "";
        try {
            JstAstInfoVisitor visitor = new JstAstInfoVisitor();
            Method method = JstAstInfoVisitor.class.getMethod("visit", node.getClass());
            method.invoke((Object)visitor, node);
            List<String> actualType = visitor.getType();
            for (String s : actualType) {
                retStr = retStr.equals("") ? String.valueOf(retStr) + s : String.valueOf(retStr) + "," + s;
            }
        }
        catch (Exception exception) {}
        return retStr;
    }

    private String copyStructure(Object node, int tier) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        StringBuilder structureBuilder = new StringBuilder(labelProvider.getText(node));
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        Object[] children = contentProvider.getChildren(node);
        ++tier;
        int i = 0;
        while (i < children.length) {
            String childrenStructure = this.copyStructure(children[i], tier);
            structureBuilder.append("\n");
            int j = 0;
            while (j < tier) {
                structureBuilder.append("\t");
                ++j;
            }
            structureBuilder.append(childrenStructure);
            ++i;
        }
        return structureBuilder.toString();
    }

    private String copyProperties(Object node) {
        INodePrinter nodePrinter = NodePrinterFactory.getNodePrinter(node);
        if (nodePrinter == null) {
            return "";
        }
        String[] names = nodePrinter.getPropertyNames(node);
        if (names.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] values = nodePrinter.getPropertyValuies(node);
        int i = 0;
        while (i < names.length) {
            stringBuilder.append(String.valueOf(names[i]) + ":" + values[i]);
            if (i != names.length - 1) {
                stringBuilder.append("\n");
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(part instanceof IEditorPart)) {
            return;
        }
        if (!(part instanceof VjoEditor)) {
            this.cleanUp();
            return;
        }
        if (this.vjoEditor != part) {
            IModelElement modelElement = null;
            IEditorInput editorInput = ((VjoEditor)part).getEditorInput();
            modelElement = editorInput instanceof ExternalFileEditorInput ? ((ExternalFileEditorInput)editorInput).getModelElement() : ((VjoEditor)part).getInputModelElement();
            if (!(modelElement instanceof VjoSourceModule)) {
                this.cleanUp();
                return;
            }
            VjoSourceModule sourceModule = (VjoSourceModule)modelElement;
            IJstType scriptUnit = sourceModule.getJstType();
            if (scriptUnit == null) {
                return;
            }
            this.jstType = scriptUnit;
            this.vjoEditor = (VjoEditor)part;
            this.vjoEditor.getScriptSourceViewer().getDocument().addDocumentListener(this.documentListener);
            ((ScriptUnitTreeContentProvider)this.viewer.getContentProvider()).setScriptUnit(scriptUnit);
            this.viewer.setInput((Object)new Object[]{scriptUnit});
        }
        if (selection instanceof ITextSelection && this.jstType != null) {
            ITextSelection textSelection = (ITextSelection)selection;
            int startOffset = textSelection.getOffset();
            int endOffset = startOffset + textSelection.getLength();
            if (textSelection.getLength() > 0) {
                endOffset = startOffset + textSelection.getLength() - 1;
            }
            String offsetInfo = "Offset:" + textSelection.getOffset() + "  Length:" + textSelection.getLength();
            this.offsetLabel.setText(offsetInfo);
            BaseJstNode node = JstUtil.getLeafNode((IJstType)this.jstType, (int)startOffset, (int)endOffset);
            if (node != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
            } else {
                this.viewer.setSelection(null);
            }
        }
    }

    private IJstType getScriptUnit(VjoSourceModule sourceModule, VjoEditor vjoEditor) {
        try {
            String groupName = sourceModule.getGroupName();
            sourceModule.getTypeName().typeName();
            System.out.println(groupName);
            if (groupName.equals(".org.eclipse.dltk.mod.core.external.folders")) {
                return TypeSpaceMgr.getInstance().findType((TypeName)sourceModule.getTypeName());
            }
            String source = sourceModule.getSource();
            VjoParserToJstAndIType m_parser = new VjoParserToJstAndIType();
            if (VjetPlugin.TRACE_PARSER) {
                System.out.println("parsing for " + ((Object)((Object)this)).getClass().getName());
            }
            return m_parser.parse(groupName, sourceModule.getTypeName().typeName(), source);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean needUpdate(IJstType jstType) {
        return this.jstType != jstType;
    }

    private void cleanUp() {
        this.viewer.setInput((Object)new Object[0]);
        if (this.vjoEditor != null) {
            this.vjoEditor.getScriptSourceViewer().getDocument().removeDocumentListener(this.documentListener);
        }
        this.vjoEditor = null;
    }

    public void dispose() {
        if (this.vjoEditor != null) {
            this.vjoEditor.getScriptSourceViewer().getDocument().removeDocumentListener(this.documentListener);
        }
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        this.getSite().getPage().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
    }

    private class DocumentListener
    implements IDocumentListener {
        private DocumentListener() {
        }

        public void documentChanged(DocumentEvent event) {
            IModelElement element = ScriptUnitView.this.vjoEditor.getInputModelElement();
            if (!(element instanceof VjoSourceModule)) {
                return;
            }
            VjoSourceModule sourceModule = (VjoSourceModule)element;
            IJstType scriptUnit = ScriptUnitView.this.getScriptUnit(sourceModule, ScriptUnitView.this.vjoEditor);
            ScriptUnitView.this.jstType = scriptUnit;
            ((ScriptUnitTreeContentProvider)ScriptUnitView.this.viewer.getContentProvider()).setScriptUnit(scriptUnit);
            ScriptUnitView.this.viewer.setInput((Object)new Object[]{scriptUnit});
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (ScriptUnitView.this.vjoEditor == part) {
                ScriptUnitView.this.cleanUp();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

