/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.wizards.NewPackageWizardPage;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjetWizardMessages;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoNameValidator;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoSourceModulePage;

public final class VjoNewPackageWizardPage
extends NewPackageWizardPage {
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final String PACKAGE = "NewPackageWizardPage.package";
    private IStatus fPackageStatus;
    private IStatus fDUlpackageStatus;

    protected String getRequiredNature() {
        return "org.eclipse.vjet.core.nature";
    }

    public String getTitle() {
        return VjetWizardMessages.PackageCreationWizard_page_title;
    }

    public String getDescription() {
        return VjetWizardMessages.PackageCreationWizard_page_description;
    }

    public IResource getModifiedResource() {
        IProjectFragment root = this.getProjectFragment();
        if (root != null) {
            String text = this.getPackageText();
            text = this.replaceDotToSlash(text);
            return root.getScriptFolder(text).getResource();
        }
        return null;
    }

    private String replaceDotToSlash(String text) {
        text = text.replace('.', '/');
        return text;
    }

    public void createPackage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProjectFragment root = this.getProjectFragment();
        String packName = this.getPackageText();
        packName = this.replaceDotToSlash(packName);
        this.fCreatedScriptFolder = root.createScriptFolder(packName, true, monitor);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (this.containerStatus.getSeverity() != 0) {
            this.updateStatus(new IStatus[]{this.containerStatus});
            return;
        }
        this.fPackageStatus = this.packageTextChanged();
        this.fDUlpackageStatus = this.sourceFolderTextChanged();
        if (this.fPackageStatus != null && this.fPackageStatus.getSeverity() != 0) {
            this.updateStatus(new IStatus[]{this.fPackageStatus});
            return;
        }
        if (this.fDUlpackageStatus != null && this.fDUlpackageStatus.getSeverity() != 0) {
            this.updateStatus(new IStatus[]{this.fDUlpackageStatus});
            return;
        }
    }

    private IStatus packageTextChanged() {
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        if (VjoSourceModulePage.isEmptyName(packName) != null) {
            return new StatusInfo(4, VjetWizardMessages.convention_package_nullName);
        }
        if (packName.length() == 0) {
            return new StatusInfo(4, VjetWizardMessages.convention_package_emptyName);
        }
        if (VjoNameValidator.startOrEndWithDot(packName) != null) {
            return VjoNameValidator.startOrEndWithDot(packName);
        }
        if (packName.length() > 0) {
            this.checkCorrectName(status, packName);
        } else {
            this.enterName(status);
        }
        return status;
    }

    private IStatus sourceFolderTextChanged() {
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        IProjectFragment root = this.getProjectFragment();
        if (root != null && root.getScriptProject().exists()) {
            IScriptFolder pack = root.getScriptFolder(packName);
            try {
                this.checkExistence(status, pack);
            }
            catch (CoreException e) {
                DLTKUIPlugin.log((Throwable)e);
            }
        }
        return status;
    }

    private void checkCorrectName(StatusInfo status, String packName) {
        IStatus val = JavaConventions.validatePackageName((String)packName);
        if (val.getSeverity() == 4) {
            this.invalidPackageName(status, val, packName);
        } else if (val.getSeverity() == 2) {
            this.discouragedPackageName(status, val);
        }
    }

    private void discouragedPackageName(StatusInfo status, IStatus val) {
        String m = VjetWizardMessages.PackageCreationWizard_discouraged_package_name;
        status.setWarning(Messages.format((String)m, (Object)val.getMessage()));
    }

    private void invalidPackageName(StatusInfo status, IStatus val, String packName) {
        if (packName != null && packName.length() > 0 && (Character.isDigit(packName.charAt(0)) || VjoSourceModulePage.containInvalidCharInPackageName(packName))) {
            String m = VjetWizardMessages.PackageCreationWizard_invalid_package_name;
            status.setError(Messages.format((String)m, (Object)("'" + packName + "'" + " is not a valid name")));
        }
    }

    private void enterName(StatusInfo status) {
        status.setError(NewWizardMessages.NewPackageWizardPage_error_EnterName);
    }

    private void checkExistence(StatusInfo status, IScriptFolder pack) throws ModelException, CoreException {
        if (pack.exists()) {
            if (pack.containsScriptResources() || !pack.hasSubfolders()) {
                this.packageExist(status);
            } else {
                this.packageNotShown(status);
            }
        } else {
            IFileStore store;
            URI location = pack.getResource().getLocationURI();
            if (location != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                this.packageExistDifferenseCase(status);
            }
        }
    }

    private void packageExistDifferenseCase(StatusInfo status) {
        String m = NewWizardMessages.NewPackageWizardPage_error_PackageExistsDifferentCase;
        status.setError(m);
    }

    private void packageNotShown(StatusInfo status) {
        String m = NewWizardMessages.NewPackageWizardPage_error_PackageNotShown;
        status.setError(m);
    }

    private void packageExist(StatusInfo status) {
        String m = NewWizardMessages.NewPackageWizardPage_error_PackageExists;
        status.setError(m);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.vjet.eclipse.ui.new_package_wizard_page_context");
    }
}

