/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.eclipse.internal.ui.editor.VjoEditor;
import org.eclipse.vjet.eclipse.internal.ui.text.completion.VjoProposalLabelUtil;
import org.eclipse.vjet.eclipse.ui.VjetUIUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;

public class VjoAddCommentAction
extends SelectionDispatchAction {
    private VjoEditor m_Editor;

    public VjoAddCommentAction(IWorkbenchSite site) {
        super(site);
        this.setText("Add Method Annotation");
    }

    public VjoAddCommentAction(VjoEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.m_Editor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private boolean checkEnabledEditor() {
        return true;
    }

    public void run() {
        super.run();
    }

    public void run(IStructuredSelection selection) {
        super.run(selection);
    }

    public void run(ITextSelection selection) {
        IJstType jstType = VjetUIUtils.getJstType(this.m_Editor);
        if (jstType == null) {
            return;
        }
        BaseJstNode node = JstUtil.getLeafNode((IJstType)jstType, (int)selection.getOffset(), (int)(selection.getOffset() + selection.getLength()), (boolean)false, (boolean)true);
        if (node == null) {
            return;
        }
        if ((node = VjetUIUtils.getCommentableJstNode((IJstNode)node)) == null) {
            return;
        }
        IDocument document = VjetUIUtils.getDocument(this.m_Editor);
        String text = "";
        int offset = -1;
        if (node instanceof JstVars) {
            text = VjetUIUtils.getCommentText((JstVars)node);
            offset = VjetUIUtils.getCommentOffset((JstVars)node, document);
            if (StringUtils.isBlankOrEmpty((String)text) || offset == -1) {
                return;
            }
            text = "//<" + text;
        } else if (node instanceof IJstProperty) {
            text = VjetUIUtils.getCommentText((IJstProperty)node);
            offset = VjetUIUtils.getCommentOffset((IJstProperty)node, document);
            if (StringUtils.isBlankOrEmpty((String)text) || offset == -1) {
                return;
            }
            text = "//<" + text;
        } else if (node instanceof IJstMethod) {
            text = VjetUIUtils.getCommentText((IJstMethod)node);
            offset = VjetUIUtils.getCommentOffset((IJstMethod)node, document);
            if (StringUtils.isBlankOrEmpty((String)text) || offset == -1) {
                return;
            }
            text = String.valueOf(TextUtilities.getDefaultLineDelimiter((IDocument)document)) + "//> " + text;
            text = VjoProposalLabelUtil.evaluateIndent(text, document, offset);
        }
        try {
            VjetUIUtils.performChange(this.m_Editor, text, offset);
        }
        catch (CoreException coreException) {}
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabledEditor());
    }
}

