/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.mod.wst.jsdt.core.ast.IArgument;
import org.eclipse.mod.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends Statement
implements IAbstractFunctionDeclaration,
ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    private MethodScope prevScope;
    public char[] selector;
    public char[] potentialName;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public Argument[] arguments;
    public Statement[] statements;
    public int explicitDeclarations;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public boolean resolveChildStatments = true;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public boolean errorInSignature = false;
    public int exprStackPtr;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    @Override
    public void setArguments(IArgument[] args) {
        if (args instanceof Argument[]) {
            this.arguments = (Argument[])args;
        }
    }

    @Override
    public IArgument[] getArguments() {
        return this.arguments;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
        }
        throw new AbortMethod(this.compilationResult, problem);
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isClinit() {
        return false;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output);
    }

    @Override
    public StringBuffer print(int tab, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(tab, output);
        }
        AbstractMethodDeclaration.printIndent(tab, output);
        output.append("function ");
        if (this.selector != null) {
            output.append(this.selector);
        }
        output.append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        this.printBody(tab + 1, output);
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return output.append(';');
        }
        output.append(" {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        }
        output.append('\n');
        AbstractMethodDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output;
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, Scope classScope) {
    }

    @Override
    public int getASTType() {
        return 1;
    }

    @Override
    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    @Override
    public IProgramElement[] getStatements() {
        return this.statements;
    }

    @Override
    public char[] getName() {
        return this.selector != null ? this.selector : this.potentialName;
    }

    public char[] getSafeName() {
        if (this.selector != null) {
            return this.selector;
        }
        return new char[0];
    }
}

