/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IEqualExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression
implements IEqualExpression {
    public EqualExpression(Expression left, Expression right, int operator) {
        super(left, right, operator);
    }

    private void checkNullComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse) {
        LocalVariableBinding local = this.left.localVariableBinding();
        if (local != null && (local.type.tagBits & 2L) == 0L) {
            this.checkVariableComparison(scope, flowContext, flowInfo, initsWhenTrue, initsWhenFalse, local, this.right.nullStatus(flowInfo), this.left);
        }
        if ((local = this.right.localVariableBinding()) != null && (local.type.tagBits & 2L) == 0L) {
            this.checkVariableComparison(scope, flowContext, flowInfo, initsWhenTrue, initsWhenFalse, local, this.left.nullStatus(flowInfo), this.right);
        }
    }

    private void checkVariableComparison(BlockScope scope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo initsWhenTrue, FlowInfo initsWhenFalse, LocalVariableBinding local, int nullStatus, Expression reference) {
        switch (nullStatus) {
            case 1: {
                if ((this.bits & 0xFC0) >> 6 == 18) {
                    flowContext.recordUsingNullReference(scope, local, reference, 256, flowInfo);
                    initsWhenTrue.markAsComparedEqualToNull(local);
                    initsWhenFalse.markAsComparedEqualToNonNull(local);
                    break;
                }
                flowContext.recordUsingNullReference(scope, local, reference, 512, flowInfo);
                initsWhenTrue.markAsComparedEqualToNonNull(local);
                initsWhenFalse.markAsComparedEqualToNull(local);
                break;
            }
            case -1: {
                if ((this.bits & 0xFC0) >> 6 == 18) {
                    flowContext.recordUsingNullReference(scope, local, reference, 513, flowInfo);
                    initsWhenTrue.markAsComparedEqualToNonNull(local);
                    break;
                }
                flowContext.recordUsingNullReference(scope, local, reference, 257, flowInfo);
            }
        }
    }

    public final void computeConstant(TypeBinding leftType, TypeBinding rightType) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, leftType.id, this.right.constant, rightType.id);
            if ((this.bits & 0xFC0) >> 6 == 29) {
                this.constant = BooleanConstant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = Constant.NotAConstant;
        }
    }

    @Override
    public boolean isCompactableOperation() {
        return false;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 31;
    }
}

