/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IForInStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class ForInStatement
extends Statement
implements IForInStatement {
    public Statement iterationVariable;
    public Expression collection;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForInStatement(Statement iterationVariable, Expression collection, Statement action, boolean neededScope, int s, int e) {
        this.sourceStart = s;
        this.sourceEnd = e;
        this.iterationVariable = iterationVariable;
        this.collection = collection;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.neededScope = neededScope;
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        ForInStatement.printIndent(tab, output).append("for (");
        if (this.iterationVariable != null) {
            if (this.iterationVariable instanceof AbstractVariableDeclaration) {
                AbstractVariableDeclaration variable = (AbstractVariableDeclaration)this.iterationVariable;
                variable.printAsExpression(0, output);
            } else {
                this.iterationVariable.print(0, output);
            }
        }
        output.append(" in ");
        if (this.collection != null) {
            this.collection.printExpression(0, output);
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        BlockScope visitScope;
        BlockScope blockScope2 = visitScope = this.scope != null ? this.scope : blockScope;
        if (visitor.visit(this, blockScope)) {
            if (this.iterationVariable != null) {
                this.iterationVariable.traverse(visitor, visitScope);
            }
            if (this.collection != null) {
                this.collection.traverse(visitor, visitScope);
            }
            if (this.action != null) {
                this.action.traverse(visitor, visitScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 40;
    }
}

