/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.parser;

import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredLocalVariable
extends RecoveredStatement {
    public LocalDeclaration localDeclaration;
    boolean alreadyCompletedLocalInitialization;

    public RecoveredLocalVariable(LocalDeclaration localDeclaration, RecoveredElement parent, int bracketBalance) {
        super(localDeclaration, parent, bracketBalance);
        this.localDeclaration = localDeclaration;
        this.alreadyCompletedLocalInitialization = localDeclaration.initialization != null;
    }

    @Override
    public RecoveredElement add(Statement stmt, int bracketBalanceValue) {
        if (this.alreadyCompletedLocalInitialization || !(stmt instanceof Expression)) {
            return super.add(stmt, bracketBalanceValue);
        }
        this.alreadyCompletedLocalInitialization = true;
        this.localDeclaration.initialization = (Expression)stmt;
        this.localDeclaration.declarationSourceEnd = stmt.sourceEnd;
        this.localDeclaration.declarationEnd = stmt.sourceEnd;
        return this;
    }

    @Override
    public ASTNode parseTree() {
        return this.localDeclaration;
    }

    @Override
    public int sourceEnd() {
        return this.localDeclaration.declarationSourceEnd;
    }

    @Override
    public String toString(int tab) {
        return String.valueOf(this.tabString(tab)) + "Recovered local variable:\n" + this.localDeclaration.print(tab + 1, new StringBuffer(10));
    }

    @Override
    public Statement updatedStatement() {
        return this.localDeclaration;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                this.alreadyCompletedLocalInitialization = true;
            }
            return this;
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(braceStart, braceEnd);
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        if (this.localDeclaration.declarationSourceEnd == 0 && (this.localDeclaration.type instanceof ArrayTypeReference || this.localDeclaration.type instanceof ArrayQualifiedTypeReference) && !this.alreadyCompletedLocalInitialization) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(braceStart - 1, braceEnd - 1);
        return this.parent.updateOnOpeningBrace(braceStart, braceEnd);
    }

    @Override
    public void updateParseTree() {
        this.updatedStatement();
    }

    @Override
    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.localDeclaration.declarationSourceEnd == 0) {
            this.localDeclaration.declarationSourceEnd = bodyEnd;
            this.localDeclaration.declarationEnd = bodyEnd;
        }
    }

    @Override
    public ProgramElement updatedASTNode() {
        return this.updatedStatement();
    }
}

