/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.mod.javascript;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Interpreter;
import org.mozilla.mod.javascript.Scriptable;

public class StackInspector {
    private static final List<StackInfo> EMPTY = new ArrayList<StackInfo>();

    public static List<StackInfo> getStack() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            return EMPTY;
        }
        ArrayList<StackInfo> stackInfos = new ArrayList<StackInfo>();
        if (cx.lastInterpreterFrame == null) {
            CharArrayWriter writer = new CharArrayWriter();
            RuntimeException re = new RuntimeException();
            re.printStackTrace(new PrintWriter(writer));
            String s = writer.toString();
            int open = -1;
            int close = -1;
            int colon = -1;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c == ':') {
                    colon = i;
                } else if (c == '(') {
                    open = i;
                } else if (c == ')') {
                    close = i;
                } else if (c == '\n' && open != -1 && close != -1 && colon != -1 && open < colon && colon < close) {
                    String fileStr = s.substring(open + 1, colon);
                    if (!fileStr.endsWith(".java")) {
                        String lineStr = s.substring(colon + 1, close);
                        try {
                            int lineNumber = Integer.parseInt(lineStr);
                            if (lineNumber < 0) {
                                lineNumber = 0;
                            }
                            stackInfos.add(new StackInfo(fileStr, lineNumber));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    colon = -1;
                    close = -1;
                    open = -1;
                }
                ++i;
            }
        } else {
            Object[] array;
            if (cx.previousInterpreterInvocations == null || cx.previousInterpreterInvocations.size() == 0) {
                array = new Interpreter.CallFrame[1];
            } else {
                int previousCount = cx.previousInterpreterInvocations.size();
                if (cx.previousInterpreterInvocations.peek() == cx.lastInterpreterFrame) {
                    --previousCount;
                }
                array = new Interpreter.CallFrame[previousCount + 1];
                cx.previousInterpreterInvocations.toArray(array);
            }
            array[array.length - 1] = (Interpreter.CallFrame)cx.lastInterpreterFrame;
            int i = array.length - 1;
            while (i >= 0) {
                Object frame = array[i];
                while (frame != null) {
                    Object value;
                    String functionName;
                    int lineNumber = 0;
                    if (((Interpreter.CallFrame)frame).pcSourceLineStart >= 0) {
                        lineNumber = StackInspector.getIndex(((Interpreter.CallFrame)frame).idata.itsICode, ((Interpreter.CallFrame)frame).pcSourceLineStart);
                    }
                    if ((functionName = ((Interpreter.CallFrame)frame).fnOrScript.getFunctionName()).length() == 0 && (value = ((Interpreter.CallFrame)frame).fnOrScript.get("_name", (Scriptable)((Interpreter.CallFrame)frame).fnOrScript)) instanceof String) {
                        functionName = (String)value;
                    }
                    stackInfos.add(new StackInfo(((Interpreter.CallFrame)frame).idata.itsSourceFile, lineNumber, functionName));
                    frame = ((Interpreter.CallFrame)frame).parentFrame;
                }
                --i;
            }
        }
        return stackInfos;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    public static class StackInfo {
        private final String m_sourceName;
        private final int m_lineNumber;
        private final String m_functionName;

        StackInfo(String sourceName, int lineNumber, String functionName) {
            this.m_sourceName = sourceName;
            this.m_lineNumber = lineNumber;
            this.m_functionName = functionName;
        }

        StackInfo(String sourceName, int lineNumber) {
            this(sourceName, lineNumber, null);
        }

        public String getSourceName() {
            return this.m_sourceName;
        }

        public int getLineNumber() {
            return this.m_lineNumber;
        }

        public String getFunctionName() {
            return this.m_functionName;
        }

        public String toString() {
            return "at " + (this.m_functionName == null ? "" : this.m_functionName) + " (" + this.m_sourceName + ":" + this.m_lineNumber + ")";
        }
    }
}

