/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom.dap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlType;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcErrorHandler;
import org.eclipse.vjet.dsf.dap.api.anno.ADapSvcSuccessHandler;
import org.eclipse.vjet.dsf.dap.api.util.DapDocumentHelper;
import org.eclipse.vjet.dsf.dap.api.util.DapEventHelper;
import org.eclipse.vjet.dsf.dap.api.util.DapJsHelper;
import org.eclipse.vjet.dsf.dap.api.util.DapVariantTypeHelper;
import org.eclipse.vjet.dsf.dap.api.util.VJ;
import org.eclipse.vjet.dsf.dap.event.AKeyEvent;
import org.eclipse.vjet.dsf.dap.event.AMouseEvent;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.event.listener.DapEventListenerHelper;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDapHostEventHandler;
import org.eclipse.vjet.dsf.dap.event.listener.IJsEventListenerProxy;
import org.eclipse.vjet.dsf.dap.proxy.Array;
import org.eclipse.vjet.dsf.dap.proxy.INativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsFuncProxy;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsProxy;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsTypeRef;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHandlerAdapter;
import org.eclipse.vjet.dsf.dap.rt.DapHost;
import org.eclipse.vjet.dsf.dap.rt.DapServiceEngine;
import org.eclipse.vjet.dsf.dap.rt.JsBase;
import org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.javatojs.translate.DataTypeTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.BaseCustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomMethod;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.CustomType;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.ICustomMetaProvider;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.IPrivilegedProcessor;
import org.eclipse.vjet.dsf.javatojs.translate.custom.meta.PrivilegedProcessorAdapter;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.KeyboardEvent;
import org.eclipse.vjet.dsf.jsnative.events.MouseEvent;
import org.eclipse.vjet.dsf.jsnative.events.UIEvent;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.PtyGetter;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.service.IServiceSpec;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class DapMeta
extends BaseCustomMetaProvider
implements ICustomMetaProvider {
    private static final String VJO_ELEMENT = "vjo.dsf.Element";
    private static final String VJO_SELECT = "vjo.dsf.document.Select";
    private static final String VJO_DAP_SVC_ENGINE = "vjo.dsf.DapServiceEngine";
    private static final String VJO_I_SVC_SPEC = "vjo.dsf.IServiceSpec";
    private static final String VJO_SVC_SPEC = "vjo.dsf.DefaultServiceSpec";
    private static DapMeta s_instance = new DapMeta();
    private static boolean m_initialized = false;
    private static final String PROTOTYPE = ".prototype";
    private static final String JqName = "org.jquery.jQuery";

    private DapMeta() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DapMeta getInstance() {
        if (!m_initialized) {
            DapMeta dapMeta = s_instance;
            synchronized (dapMeta) {
                if (!m_initialized) {
                    s_instance.init();
                    m_initialized = true;
                }
            }
        }
        return s_instance;
    }

    private void init() {
        this.addRtMeta();
        this.addApiMeta();
        this.addEventType();
        this.addEventMeta();
        this.addListenerMeta();
        this.addServiceMeta();
        this.addEventDispatcherXMeta();
        this.addObjectLiteralMeta();
        this.addArrayProxyMeta();
        this.addJTypeMeta();
        this.addJFunctionMeta();
        this.addJsxMeta();
        this.addFuncXMeta();
        this.addOtherMeta();
        this.addJqMeta();
    }

    private void addRtMeta() {
        Class<DapCtx> type = DapCtx.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.EXCLUDED));
        type = DapHandlerAdapter.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = DapHost.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.EXCLUDED));
        type = JsBase.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY).addCustomMethod(new CustomMethod("window")).addCustomMethod(new CustomMethod("document")));
        this.addPrivilegedTypeProcessor(type.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (cMtd == null) {
                    return null;
                }
                return new JstIdentifier(cMtd.getJavaName()).setType(identifier.getType());
            }
        });
    }

    private void addApiMeta() {
        Class<VJ> type = VJ.class;
        CustomType customType = new CustomType(type);
        this.addCustomType(type.getName(), customType.setAttr(CustomAttr.JAVA_ONLY).addCustomMethod(new CustomMethod("win", "window").setIsProperty(true).setJstReturnTypeName(Window.class.getName()).removeQualifier(true)).addCustomMethod(new CustomMethod("doc", "document").setIsProperty(true).setJstReturnTypeName(HtmlDocument.class.getName()).removeQualifier(true)).addCustomMethod(new CustomMethod("this_", "this").setIsProperty(true).setJstReturnTypeName(java.lang.Object.class.getName()).removeQualifier(true)));
        type = DapDocumentHelper.class;
        CustomType doc = new CustomType(type).setAttr(CustomAttr.JAVA_ONLY).addCustomMethod("createElement", "createElement", "document").addCustomMethod("createTextNode", "createTextNode", "document").addCustomMethod("getElement", "get", VJO_ELEMENT).addCustomMethod("clearOptions", "clear", VJO_SELECT).addCustomMethod("createOption", "createOption", VJO_SELECT);
        this.addCustomType(type.getName(), doc);
        this.addPrivilegedTypeProcessor(type.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                AHtmlType hType;
                String mtdName = identifier.getName();
                if (mtdName.equals("var_")) {
                    mtdName = "var";
                }
                if ((hType = AHtmlType.Helper.get((String)mtdName)) != null) {
                    String rtnTypeName = hType.getJsNativeClass().getName();
                    JstType rtnType = JstCache.getInstance().getType(rtnTypeName);
                    if (args.size() == 0) {
                        return new CastExpr((IExpr)new TextExpr("document.createElement('" + mtdName + "')", (IJstType)rtnType));
                    }
                    String innerHTML = args.get(0).toExprText();
                    return new TextExpr("vjo.create('" + mtdName + "', " + innerHTML + ")", (IJstType)rtnType);
                }
                if (mtdName.startsWith("get")) {
                    if (args.size() == 1) {
                        String eleName = mtdName.substring(3);
                        hType = AHtmlType.Helper.get((String)eleName);
                        if (hType != null) {
                            String rtnTypeName = hType.getJsNativeClass().getName();
                            JstType rtnType = JstCache.getInstance().getType(rtnTypeName);
                            return new CastExpr((IExpr)new TextExpr("document.getElementById(" + args.get(0).toExprText() + ")"), (IJstType)rtnType);
                        }
                    } else {
                        if (mtdName.equals("getBody")) {
                            JstType rtnType = JstCache.getInstance().getType(AHtmlType.BODY.getJsNativeClass().getName());
                            return new TextExpr("document.body", (IJstType)rtnType);
                        }
                        if (mtdName.equals("getHead")) {
                            JstType rtnType = JstCache.getInstance().getType(AHtmlType.HEAD.getJsNativeClass().getName());
                            return new TextExpr("document.getElementsByTagName('head')[0]", (IJstType)rtnType);
                        }
                        if (mtdName.equals("getTitle")) {
                            JstType rtnType = JstCache.getInstance().getType(AHtmlType.TITLE.getJsNativeClass().getName());
                            return new TextExpr("document.getElementsByTagName('title')[0]", (IJstType)rtnType);
                        }
                    }
                }
                if (cMtd == null) {
                    return null;
                }
                int jsParamsCount = 0;
                if ("getElement".equals(cMtd.getJavaName())) {
                    jsParamsCount = 1;
                }
                String ownerTypeName = cMtd.getJstOwnerTypeName();
                DataTypeTranslator dataTypeTranslator = TranslateCtx.ctx().getProvider().getDataTypeTranslator();
                if (ownerTypeName != null) {
                    IJstType toOwnerType = dataTypeTranslator.toJstType(cMtd.getJstOwnerTypeName(), jstNode.getOwnerType());
                    dataTypeTranslator.addImport(toOwnerType, jstNode.getOwnerType(), toOwnerType.getSimpleName());
                }
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(new JstIdentifier(cMtd.getJstName()), new IExpr[0]);
                mtdCall.setQualifyExpr((IExpr)new JstIdentifier(ownerTypeName));
                if (jsParamsCount == 0) {
                    jsParamsCount = args.size();
                }
                int i = 0;
                while (i < jsParamsCount) {
                    if (args.get(i) != null) {
                        mtdCall.addArg((IExpr)new JstIdentifier(args.get(i).toExprText()));
                    }
                    ++i;
                }
                if ("getElement".equals(cMtd.getJavaName())) {
                    String argName = args.get(args.size() - 1).toExprText();
                    argName = argName.substring(1, argName.length() - 1);
                    Iterable iter = AHtmlType.Type.valueIterable();
                    for (AHtmlType htmlType : iter) {
                        String tagName = htmlType.getTagName();
                        if (!tagName.equalsIgnoreCase(argName)) continue;
                        IJstType type = dataTypeTranslator.toJstType(htmlType.getJsNativeClass().getName(), jstNode.getOwnerType());
                        mtdCall.setResultType(type);
                        break;
                    }
                }
                return mtdCall;
            }
        });
        type = DapEventHelper.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = DapJsHelper.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        this.addPrivilegedTypeProcessor(type.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                String methodName = identifier.getName();
                if (methodName.equals("isDefined")) {
                    IExpr type = args.get(0);
                    String typeOf = "typeof ";
                    TextExpr left = args.size() == 1 ? new TextExpr(String.valueOf(typeOf) + type.toExprText()) : new TextExpr(String.valueOf(typeOf) + type.toExprText() + "[" + args.get(1).toExprText() + "]");
                    return new BoolExpr((IExpr)left, (IExpr)new SimpleLiteral(String.class, (IJstType)JstCache.getInstance().getType("String"), "undefined"), BoolExpr.Operator.NOT_EQUALS);
                }
                JstIdentifier newIdentifier = new JstIdentifier(methodName);
                newIdentifier.setType(identifier.getResultType());
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(newIdentifier, new IExpr[0]);
                for (IExpr arg : args) {
                    mtdCall.addArg(arg);
                }
                return mtdCall;
            }
        });
        type = DapVariantTypeHelper.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        this.addPrivilegedTypeProcessor(type.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args == null || args.size() != 1) {
                    return null;
                }
                IExpr arg = args.get(0);
                IJstType returnType = identifier.getResultType();
                return arg;
            }
        });
    }

    private void addEventType() {
        Class<EventType> type = EventType.class;
        CustomType cType = new CustomType(type).setAttr(CustomAttr.JAVA_ONLY).addCustomMethod("getName", null, false);
        Field[] fieldArray = type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            cType.addCustomField(f.getName(), "\"" + f.getName().toLowerCase() + "\"", type.getName());
            ++n2;
        }
        this.addCustomType(type.getName(), cType);
        type = Event.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = UIEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = MouseEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = KeyboardEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = DapEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = AMouseEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = AKeyEvent.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
    }

    private void addEventMeta() {
        List list = DapEventListenerHelper.getSupportedEvents();
        for (Class type : list) {
            CustomType cType = new CustomType(type).setAttr(CustomAttr.JAVA_ONLY);
            cType.addCustomMethod("getSource", "src", true);
            this.addCustomType(type.getName(), cType);
        }
    }

    private void addListenerMeta() {
        for (Class lType : DapEventListenerHelper.getAllEventListeners()) {
            this.addCustomType(lType.getName(), new CustomType(lType).setAttr(CustomAttr.JAVA_ONLY));
        }
    }

    private void addServiceMeta() {
        Class<DapServiceEngine> type = DapServiceEngine.class;
        CustomType svcEngine = new CustomType(type, VJO_DAP_SVC_ENGINE).setAttr(CustomAttr.MAPPED_TO_VJO).addCustomMethod(new CustomMethod("publish"));
        this.addCustomType(type.getName(), svcEngine);
        this.addPrivilegedTypeProcessor(type.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                mtdCall.setQualifyExpr(optionalExpr);
                int i = 0;
                while (i < args.size()) {
                    if (args.get(i) != null) {
                        if (args.get(i) instanceof ObjCreationExpr) {
                            ObjCreationExpr oExpr = (ObjCreationExpr)args.get(i);
                            StringBuilder sb = new StringBuilder("{");
                            List oArgs = oExpr.getInvocationExpr().getArgs();
                            int j = 0;
                            while (j < oArgs.size()) {
                                String argName = ((IExpr)oArgs.get(j)).toExprText();
                                sb.append("\"").append(argName).append("\":").append(argName);
                                if (j < oArgs.size() - 1) {
                                    sb.append(",");
                                }
                                ++j;
                            }
                            sb.append("}");
                            mtdCall.addArg((IExpr)new JstIdentifier(sb.toString()));
                        } else {
                            mtdCall.addArg((IExpr)new JstIdentifier(args.get(i).toExprText()));
                        }
                    }
                    ++i;
                }
                return mtdCall;
            }
        });
        type = IServiceSpec.class;
        CustomType iSvcSpec = new CustomType(type, VJO_I_SVC_SPEC);
        this.addCustomType(type.getName(), iSvcSpec);
        this.addCustomType(VJO_I_SVC_SPEC, iSvcSpec);
    }

    private void addEventDispatcherXMeta() {
        CustomType dispatcher = new CustomType("com.ebay.vjox.EventDispatcherX", "vjo.dsf.EventDispatcher").setAttr(CustomAttr.MAPPED_TO_VJO).addCustomMethod(new CustomMethod("addEventListener"));
        this.addCustomType("com.ebay.vjox.EventDispatcherX", dispatcher);
        this.addPrivilegedTypeProcessor("com.ebay.vjox.EventDispatcherX", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                mtdCall.setQualifyExpr(optionalExpr);
                boolean isEventListener = args.size() == 4;
                String onEventMethodName = null;
                int argIndex = 1;
                for (IExpr arg : args) {
                    String argValue = arg.toExprText();
                    if (argIndex == 2 && isEventListener) {
                        onEventMethodName = DapMeta.getOnEventMethodExpr(argValue);
                    }
                    if (argIndex == 3 && isEventListener) {
                        mtdCall.addArg((IExpr)new JstIdentifier(String.valueOf(argValue) + onEventMethodName));
                    }
                    if (argIndex == 4 && DapMeta.isPrototype(argValue)) {
                        argValue = DapMeta.getType(argValue);
                    }
                    mtdCall.addArg((IExpr)new JstIdentifier(argValue));
                    ++argIndex;
                }
                return mtdCall;
            }
        });
    }

    private static String getOnEventMethodExpr(String eventStr) {
        int length = eventStr.length();
        char[] chars = new char[length - 2];
        int i = 1;
        while (i < length - 1) {
            chars[i - 1] = eventStr.charAt(i);
            if (i == 1) {
                chars[i - 1] = Character.toUpperCase(chars[i - 1]);
            }
            ++i;
        }
        return ".on" + String.valueOf(chars);
    }

    private static boolean isPrototype(String argValue) {
        return argValue != null && argValue.endsWith(PROTOTYPE);
    }

    private static String getType(String argValue) {
        return argValue.substring(0, argValue.length() - PROTOTYPE.length());
    }

    private void addOtherMeta() {
        Class<IJsEventListenerProxy> type = IJsEventListenerProxy.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IDapEventListener.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IDapHostEventHandler.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IJsEventListenerProxy.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IDapEventListener.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IDapHostEventHandler.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = ADapSvcSuccessHandler.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = ADapSvcErrorHandler.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = IDapSvcCallback.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = NativeJsProxy.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = INativeJsFuncProxy.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = NativeJsFuncProxy.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
        type = NativeJsTypeRef.class;
        this.addCustomType(type.getName(), new CustomType(type).setAttr(CustomAttr.JAVA_ONLY));
    }

    private void addObjectLiteralMeta() {
        CustomType objLiteralType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.Ol", "org.eclipse.vjet.dsf.jsnative.global.ObjLiteral").setAttr(CustomAttr.JS_PROXY);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.Ol", objLiteralType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Ol", "obj", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                ObjLiteral ol = new ObjLiteral();
                int size = args.size();
                if (size % 2 != 0) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Ol should take name and value pairs.");
                }
                int i = 0;
                while (i < size) {
                    String name = args.get(i).toExprText();
                    ol.add(name, args.get(i + 1));
                    i += 2;
                }
                return ol;
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Ol", "get", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 1) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Ol.get needs one argument");
                }
                return new ArrayAccessExpr(optionalExpr, args.get(0));
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Ol", "put", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 2) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Ol.put needs two arguments");
                }
                ArrayAccessExpr left = new ArrayAccessExpr(optionalExpr, args.get(0));
                return new AssignExpr((ILHS)left, args.get(1));
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Ol", "remove", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 1) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Ol.remove needs one argument");
                }
                ArrayAccessExpr right = new ArrayAccessExpr(optionalExpr, args.get(0));
                return new TextExpr("delete " + right.toExprText());
            }
        });
    }

    private void addArrayProxyMeta() {
        CustomType arrayType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.Array", "org.eclipse.vjet.dsf.jsnative.global.Array").setAttr(CustomAttr.JS_PROXY).setRemoveTypeQualifier(true);
        HashMap<String, String> specialMethods = new HashMap<String, String>();
        specialMethods.put("get", "");
        specialMethods.put("put", "");
        specialMethods.put("getLength", "");
        specialMethods.put("make", "");
        Method[] methodArray = Array.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            CustomMethod customMethod = new CustomMethod(method.getName());
            arrayType.addCustomMethod(customMethod);
            if (specialMethods.get(method.getName()) == null) {
                customMethod.setJstReturnTypeName(method.getReturnType().getName());
                this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", method.getName(), (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

                    public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> jstArgs, boolean isSuper, BaseJstNode jstNode, CustomType clientType, CustomMethod clientMethod) {
                        identifier.setJstBinding(null);
                        return super.processMtdInvocation(astNode, identifier, optionalExpr, jstArgs, isSuper, jstNode, clientType, clientMethod);
                    }
                });
            }
            ++n2;
        }
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.Array", arrayType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", "get", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 1) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Array.get needs one argument");
                }
                return new ArrayAccessExpr(optionalExpr, args.get(0));
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", "put", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 2) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.Array.put needs two arguments");
                }
                ArrayAccessExpr left = new ArrayAccessExpr(optionalExpr, args.get(0));
                return new AssignExpr((ILHS)left, args.get(1));
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", "getLength", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                return new PtyGetter(new JstIdentifier("length"), optionalExpr);
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", "make", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                return args.get(0);
            }
        });
        this.addPrivilegedConstructorProcessor("org.eclipse.vjet.dsf.dap.proxy.Array", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processInstanceCreation(ClassInstanceCreation cic, BaseJstNode jstNode, List<IExpr> argExprList, CustomType clientType) {
                SimpleLiteral simple;
                IExpr literal;
                List args = cic.arguments();
                if (args.size() == 1 && (literal = argExprList.get(0)) instanceof SimpleLiteral && (simple = (SimpleLiteral)literal).getResultType() != null && "int".equals(simple.getResultType().getName())) {
                    return TranslateHelper.Expression.createObjCreationExpr((String)"Array", (IExpr[])new IExpr[]{argExprList.get(0)});
                }
                JstArrayInitializer array = new JstArrayInitializer();
                for (IExpr elem : argExprList) {
                    array.add(elem);
                }
                return array;
            }
        });
    }

    private void addJTypeMeta() {
        CustomType jtypeType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.JType", Object.class.getName()).addCustomMethod(new CustomMethod("def")).setAttr(CustomAttr.JS_PROXY);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.JType", jtypeType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.JType", "def", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() != 1) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.JType.def needs one argument");
                }
                FieldAccessExpr arg = (FieldAccessExpr)args.get(0);
                return arg.getExpr();
            }
        });
    }

    private void addJFunctionMeta() {
        CustomType rhinFunc = new CustomType("org.eclipse.vjet.dsf.dap.proxy.JFunction", "org.eclipse.vjet.dsf.jsnative.global.Function");
        rhinFunc.setAttr(CustomAttr.MAPPED_TO_JS);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.JFunction", rhinFunc);
        CustomType jfuncType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.JFunction", "org.eclipse.vjet.dsf.jsnative.global.Function").addCustomMethod(new CustomMethod("def")).addCustomMethod(new CustomMethod("call")).setAttr(CustomAttr.MAPPED_TO_JS);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.JFunction", jfuncType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.JFunction", "call", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr firstArg = args.get(0);
                if (!(firstArg instanceof FieldAccessExpr)) {
                    return null;
                }
                FieldAccessExpr argClazz = (FieldAccessExpr)firstArg;
                VjoConvention conv = TranslateCtx.ctx().getConfig().getVjoConvention();
                if (conv.getClassKeyword().equals(argClazz.getName().getName())) {
                    args.set(0, argClazz.getExpr());
                }
                return null;
            }
        });
        CustomType jfuncXType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.JFunctionX", "org.eclipse.vjet.dsf.jsnative.global.Function").addCustomMethod(new CustomMethod("def")).setAttr(CustomAttr.JS_PROXY);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.JFunctionX", jfuncXType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.JFunctionX", "def", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() < 2) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.proxy.JFunction.def needs at least two arguments");
                }
                IExpr arg0 = args.get(0);
                JstIdentifier qualifier = null;
                if (arg0 instanceof JstIdentifier) {
                    qualifier = (JstIdentifier)arg0;
                } else if (arg0 instanceof FieldAccessExpr) {
                    qualifier = (JstIdentifier)((FieldAccessExpr)arg0).getExpr();
                }
                IExpr argFuncName = args.get(1);
                if (argFuncName instanceof SimpleLiteral) {
                    String funcName = ((SimpleLiteral)argFuncName).getValue();
                    return new JstIdentifier(funcName, qualifier);
                }
                if (argFuncName instanceof JstIdentifier) {
                    return new ArrayAccessExpr((IExpr)qualifier, argFuncName);
                }
                return null;
            }
        });
    }

    private IExpr fieldOrProp(String target, IExpr expr) {
        String exprText = expr.toExprText();
        if (expr instanceof SimpleLiteral) {
            exprText = exprText.replaceAll("\"", "");
            return new FieldAccessExpr(new JstIdentifier(exprText), (IExpr)new TextExpr(target));
        }
        return new ArrayAccessExpr((IExpr)new TextExpr(target), expr);
    }

    private IExpr from(String target, IExpr expr) {
        if (expr instanceof SimpleLiteral) {
            MtdInvocationExpr mtdCall = new MtdInvocationExpr(target, new IExpr[0]);
            mtdCall.addArg((IExpr)new TextExpr(target));
            mtdCall.addArg(expr);
            return mtdCall;
        }
        return new ArrayAccessExpr((IExpr)new TextExpr(target), expr);
    }

    private void addJsxMeta() {
        CustomType funcXType = new CustomType("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper").addCustomMethod(new CustomMethod("isDefined")).addCustomMethod(new CustomMethod("boolExpr")).addCustomMethod(new CustomMethod("ref")).addCustomMethod(new CustomMethod("hitch")).addCustomMethod(new CustomMethod("curry")).addCustomMethod(new CustomMethod("bind")).setAttr(CustomAttr.JAVA_ONLY);
        this.addCustomType("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", funcXType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "isDefined", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr type = args.get(0);
                String typeOf = "typeof ";
                TextExpr left = args.size() == 1 ? new TextExpr(String.valueOf(typeOf) + type.toExprText()) : new TextExpr(String.valueOf(typeOf) + type.toExprText() + "[" + args.get(1).toExprText() + "]");
                return new BoolExpr((IExpr)left, (IExpr)new SimpleLiteral(String.class, (IJstType)JstCache.getInstance().getType("String"), "undefined"), BoolExpr.Operator.NOT_EQUALS);
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "boolExpr", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr type = args.get(0);
                if (args.size() == 1) {
                    return type;
                }
                return new ArrayAccessExpr(type, args.get(1));
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "ref", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                if (args.size() < 1) {
                    throw new RuntimeException("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper.ref needs at least 1 argument");
                }
                IExpr fref = args.get(0);
                if (args.size() == 1) {
                    return DapMeta.this.fieldOrProp("this.vj$.type", fref);
                }
                String target = args.get(0).toExprText();
                if (target.endsWith(".clazz")) {
                    target = target.substring(0, target.indexOf(".clazz"));
                }
                if (args.size() == 2) {
                    return DapMeta.this.fieldOrProp(target, args.get(1));
                }
                if (args.size() == 3) {
                    return DapMeta.this.fieldOrProp(target, args.get(2));
                }
                throw new DsfRuntimeException("jsx.ref(...) should not have 4 or more args");
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "hitch", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                identifier.setQualifier(new JstIdentifier("vjo"));
                identifier.setJstBinding(null);
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                IExpr ctx = args.get(0);
                IExpr func = args.get(1);
                ctx = DapMeta.processForClazzRef(ctx);
                mtdCall.addArg(ctx);
                mtdCall.addArg(func);
                return mtdCall;
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "bind", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IExpr secondExpr;
                identifier.setQualifier(new JstIdentifier("vjo"));
                identifier.setJstBinding(null);
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                IExpr firstExpr = args.get(0);
                IJstType type = firstExpr.getResultType();
                if (type != null && "String".equals(type.getName())) {
                    mtdCall.addArg((IExpr)new TextExpr("this.vj$.type"));
                    mtdCall.addArg(firstExpr);
                } else {
                    mtdCall.addArg(DapMeta.processForClazzRef(firstExpr));
                }
                if (args.size() >= 2 && !DapMeta.isClassRef(secondExpr = args.get(1))) {
                    mtdCall.addArg(secondExpr);
                }
                if (args.size() > 2) {
                    int i = 2;
                    while (i < args.size()) {
                        IExpr arg = args.get(i);
                        mtdCall.addArg(arg);
                        ++i;
                    }
                }
                return mtdCall;
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.api.util.VJJsxHelper", "curry", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                identifier.setQualifier(new JstIdentifier("vjo"));
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                identifier.setJstBinding(null);
                for (IExpr arg : args) {
                    mtdCall.addArg(arg);
                }
                return mtdCall;
            }
        });
    }

    private void addFuncXMeta() {
        CustomType funcXType = new CustomType("org.eclipse.vjet.dsf.dap.proxy.FuncX", "org.eclipse.vjet.dsf.dap.proxy.FuncX").addCustomMethod(new CustomMethod("hitch")).addCustomMethod(new CustomMethod("curry")).setAttr(CustomAttr.JAVA_ONLY);
        this.addCustomType("org.eclipse.vjet.dsf.dap.proxy.FuncX", funcXType);
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.FuncX", "hitch", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                identifier.setQualifier(new JstIdentifier("vjo"));
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                for (IExpr arg : args) {
                    mtdCall.addArg(arg);
                }
                return mtdCall;
            }
        });
        this.addPrivilegedMethodProcessor("org.eclipse.vjet.dsf.dap.proxy.FuncX", "curry", (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                identifier.setJstBinding(null);
                identifier.setQualifier(new JstIdentifier("vjo"));
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
                for (IExpr arg : args) {
                    mtdCall.addArg(arg);
                }
                return mtdCall;
            }
        });
    }

    private void addJqMeta() {
        CustomType jqType = new CustomType(JqName, JqName);
        this.addCustomType(JqName, jqType);
        this.addPrivilegedTypeProcessor(JqName, (IPrivilegedProcessor)new PrivilegedProcessorAdapter(){

            public IExpr processMtdInvocation(ASTNode astNode, JstIdentifier identifier, IExpr optionalExpr, List<IExpr> args, boolean isSuper, BaseJstNode jstNode, CustomType cType, CustomMethod cMtd) {
                IJstNode binding = identifier.getJstBinding();
                if (!(binding instanceof IJstMethod)) {
                    return null;
                }
                if (!((IJstMethod)binding).isStatic()) {
                    return null;
                }
                JstIdentifier newIdentifier = identifier;
                if ("$".equals(identifier.getName())) {
                    newIdentifier = new JstIdentifier("$");
                    newIdentifier.setType(identifier.getResultType());
                } else {
                    newIdentifier.setQualifier(new JstIdentifier("jQuery"));
                }
                MtdInvocationExpr mtdCall = new MtdInvocationExpr(newIdentifier, new IExpr[0]);
                for (IExpr arg : args) {
                    mtdCall.addArg(arg);
                }
                return mtdCall;
            }
        });
    }

    private static IExpr processForClazzRef(IExpr expr) {
        FieldAccessExpr fieldIdentifier;
        if (expr instanceof FieldAccessExpr && "clazz".equals((fieldIdentifier = (FieldAccessExpr)expr).getName().getName())) {
            expr = fieldIdentifier.getExpr();
        }
        return expr;
    }

    private static boolean isClassRef(IExpr expr) {
        if (expr instanceof FieldAccessExpr) {
            FieldAccessExpr fieldIdentifier = (FieldAccessExpr)expr;
            return "clazz".equals(fieldIdentifier.getName().getName());
        }
        return false;
    }
}

