/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.vjet.dsf.active.client.AExternal;
import org.eclipse.vjet.dsf.active.client.AFrames;
import org.eclipse.vjet.dsf.active.client.AHistory;
import org.eclipse.vjet.dsf.active.client.ALocation;
import org.eclipse.vjet.dsf.active.client.ANavigator;
import org.eclipse.vjet.dsf.active.client.AOpera;
import org.eclipse.vjet.dsf.active.client.AScreen;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlBuilder;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AImage;
import org.eclipse.vjet.dsf.active.dom.html.AJavaScriptHandlerHolder;
import org.eclipse.vjet.dsf.active.dom.html.AOption;
import org.eclipse.vjet.dsf.active.dom.html.IDocListener;
import org.eclipse.vjet.dsf.active.event.DomChangeListenerAdapter;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.active.util.IAsyncTask;
import org.eclipse.vjet.dsf.active.util.WindowAsyncTask;
import org.eclipse.vjet.dsf.active.util.WindowIntervalTask;
import org.eclipse.vjet.dsf.active.util.WindowTask;
import org.eclipse.vjet.dsf.active.util.WindowTaskManager;
import org.eclipse.vjet.dsf.active.util.WindowTimerTask;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.XMLHttpRequestImpl;
import org.eclipse.vjet.dsf.dap.rt.jsonp.JsonpProxy;
import org.eclipse.vjet.dsf.html.dom.DImg;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsdebugger.DebuggerAdapter;
import org.eclipse.vjet.dsf.jsnative.External;
import org.eclipse.vjet.dsf.jsnative.Frames;
import org.eclipse.vjet.dsf.jsnative.History;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlElementStyle;
import org.eclipse.vjet.dsf.jsnative.Image;
import org.eclipse.vjet.dsf.jsnative.Location;
import org.eclipse.vjet.dsf.jsnative.Navigator;
import org.eclipse.vjet.dsf.jsnative.Opera;
import org.eclipse.vjet.dsf.jsnative.Option;
import org.eclipse.vjet.dsf.jsnative.Screen;
import org.eclipse.vjet.dsf.jsnative.Window;
import org.eclipse.vjet.dsf.jsnative.XMLHttpRequest;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.EventException;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.eclipse.vjet.dsf.liveconnect.client.NativeEvent;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.NativeJavaClass;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Undefined;

public class AWindow
extends ActiveObject
implements Window,
EventTarget {
    private static final long serialVersionUID = 1L;
    private Context m_cx = null;
    private Scriptable m_scope = null;
    private URL m_url;
    private boolean m_isRoot;
    private DebuggerAdapter m_dbg;
    private BrowserType m_browserType = BrowserType.IE_6P;
    private boolean m_closed;
    private String m_defaultStatus;
    private AHtmlDocument m_document;
    private AHtmlBuilder m_builder;
    private Frames m_frames;
    private History m_history;
    private int m_length;
    private Location m_location;
    private String m_name = "";
    private Window m_opener;
    private Navigator m_navigator;
    private Window m_parent;
    private Screen m_screen;
    private String m_status = "";
    private Window m_top;
    private Event m_event;
    private AExternal m_external;
    private AOpera m_opera;
    private WindowTaskManager m_taskMgr;
    private IBrowserBinding m_browserBinding;
    private DomChangeListenerAdapter m_domListener;
    private boolean m_domChangeListenerEnabled = true;
    private final String WINDOW_DOT_SET_STATUS = "window.status=\"{0}\"";
    private final String WINDOW_DOT_GET_STATUS = "window.status";
    private static final ArrayList<String> VALID_EVENTS = new ArrayList();
    static HashMap<String, String> constants;
    private static final String JS_TYPE = "text/javascript";

    static {
        VALID_EVENTS.add(NativeEvent.load.toString());
        VALID_EVENTS.add(NativeEvent.unload.toString());
        VALID_EVENTS.add(NativeEvent.resize.toString());
        VALID_EVENTS.add(NativeEvent.keydown.toString());
        VALID_EVENTS.add(NativeEvent.keyup.toString());
        VALID_EVENTS.add(NativeEvent.keypress.toString());
        VALID_EVENTS.add(NativeEvent.scroll.toString());
        constants = new HashMap(13);
        constants.put("Object", "Object");
        constants.put("layers", "layers");
        constants.put("SyntaxError", "SyntaxError");
        constants.put("ConversionError", "ConversionError");
        constants.put("TypeError", "TypeError");
        constants.put("ReferenceError", "ReferenceError");
    }

    public Window getWindow() {
        return this;
    }

    public boolean getClosed() {
        return this.m_closed;
    }

    public HtmlDocument getDocument() {
        return this.m_document;
    }

    public HtmlCollection getFrames() {
        return this.getDocument().getFrames();
    }

    public History getHistory() {
        return this.m_history;
    }

    public Location getLocation() {
        return this.m_location;
    }

    public void setLocation(Location location) {
        this.m_location = location;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public Navigator getNavigator() {
        return this.m_navigator;
    }

    public Window getOpener() {
        return this.m_opener;
    }

    public Window getParent() {
        return this.m_parent;
    }

    public Window getSelf() {
        return this;
    }

    public String getStatus() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.executeJs("window.status");
        }
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs(MessageFormat.format("window.status=\"{0}\"", status));
        }
    }

    public Window getTop() {
        return this.m_top;
    }

    public int getLength() {
        return this.m_length;
    }

    public String getDefaultStatus() {
        return this.m_defaultStatus;
    }

    public void setDefaultStatus(String status) {
        this.m_defaultStatus = status;
    }

    public Screen getScreen() {
        return this.m_screen;
    }

    public int getInnerHeight() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getWindowHeight();
        }
        return 0;
    }

    public int getInnerWidth() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getWindowWidth();
        }
        return 0;
    }

    public int getOuterHeight() {
        return 0;
    }

    public int getOuterWidth() {
        return 0;
    }

    public int getPageXOffset() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getPageXOffset();
        }
        return 0;
    }

    public int getPageYOffset() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getPageYOffset();
        }
        return 0;
    }

    public int getScreenLeft() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getScreenLeft();
        }
        return 0;
    }

    public int getScreenTop() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getScreenTop();
        }
        return 0;
    }

    public int getScreenX() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getScreenLeft();
        }
        return 0;
    }

    public int getScreenY() {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.getScreenTop();
        }
        return 0;
    }

    public void alert(Object message) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.alert(NativeJsHelper.toString(message));
        }
    }

    public void blur() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.blur();
        }
    }

    public void clearInterval(int id) {
        this.cancelTimer(id);
    }

    public void clearTimeout(int id) {
        this.cancelTimer(id);
    }

    public void clearAll() {
        this.m_taskMgr.cancelAll();
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("if(TM) TM.clearAll();");
        }
    }

    private void cancelTimer(int id) {
        this.m_taskMgr.cancel(id);
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("if(TM) TM.clear('" + id + "');");
        }
    }

    public void close() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.close();
        }
    }

    public boolean confirm(String message) {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.confirm(message);
        }
        return false;
    }

    public void focus() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.focus();
        }
    }

    public void moveBy(int x, int y) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.moveBy(x, y);
        }
    }

    public void moveTo(int x, int y) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.moveTo(x, y);
        }
    }

    public Window __open(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (arg1 instanceof Undefined) {
            return this.open();
        }
        if (arg2 instanceof Undefined) {
            return this.open((String)arg1);
        }
        if (arg3 instanceof Undefined) {
            return this.open((String)arg1, (String)arg2);
        }
        if (arg4 instanceof Undefined) {
            return this.open((String)arg1, (String)arg2, (String)arg3);
        }
        return this.open((String)arg1, (String)arg2, (String)arg3, (Boolean)arg4);
    }

    public Window open() {
        return this.open(null);
    }

    public Window open(String url) {
        return this.open(url, null);
    }

    public Window open(String url, String windowName) {
        return this.open(url, windowName, null);
    }

    public Window open(String url, String windowName, String features) {
        return this.open(url, windowName, features, false);
    }

    public Window open(String url, String windowName, String features, boolean replace) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.open(url, windowName, features, replace);
        }
        return null;
    }

    public void print() {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.print();
        }
    }

    public String __prompt(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (arg1 instanceof Undefined) {
            return this.prompt();
        }
        if (arg2 instanceof Undefined) {
            return this.prompt((String)arg1);
        }
        return this.prompt((String)arg1, (String)arg2);
    }

    public String prompt() {
        return this.prompt(null);
    }

    public String prompt(String message) {
        return this.prompt(message, null);
    }

    public String prompt(String message, String defaultReply) {
        if (this.m_browserBinding != null) {
            return this.m_browserBinding.prompt(message, defaultReply);
        }
        return null;
    }

    public void resizeBy(int width, int height) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.resizeBy(width, height);
        }
    }

    public void resizeTo(int width, int height) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.resizeTo(width, height);
        }
    }

    public void scrollBy(int x, int y) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.scrollBy(x, y);
        }
    }

    public void scrollTo(int x, int y) {
        if (this.m_browserBinding != null) {
            this.m_browserBinding.scrollTo(x, y);
        }
    }

    public int setInterval(Object code, int msecs) {
        WindowIntervalTask task = new WindowIntervalTask(code, msecs, this.m_scope, this.m_cx, this.m_taskMgr);
        int id = task.getId();
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("if(TM) TM.setInterval('" + id + "', " + msecs + ");");
        }
        return id;
    }

    public int setTimeout(Object code, int msecs) {
        WindowTimerTask task = new WindowTimerTask(code, msecs, this.m_scope, this.m_cx, this.m_taskMgr);
        int id = task.getId();
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("if(TM) TM.setTimeOut('" + id + "', " + msecs + ");");
        }
        return id;
    }

    public void addTask(Object code) {
        WindowTask task = new WindowTask(code, this.m_scope, this.m_cx, this.m_taskMgr);
        int id = task.getId();
        this.m_browserBinding.executeJs("if(TM) TM.setTimeOut('" + id + ");");
    }

    public void addTask(IAsyncTask asyncTask) {
        WindowAsyncTask task = new WindowAsyncTask(asyncTask, this.m_scope, this.m_cx, this.m_taskMgr);
        int id = task.getId();
        if (this.m_browserBinding != null) {
            this.m_browserBinding.executeJs("if(TM) TM.setTimeOut('" + id + "');");
        }
    }

    public Context getContext() {
        return this.m_cx;
    }

    public Scriptable getScope() {
        return this.m_scope;
    }

    public Object getJsExcutionLock() {
        return this.m_taskMgr;
    }

    public void addChildWindow(AWindow window) {
        this.m_frames.addChildWindow((Window)window);
    }

    public void setHtmlDocument(AHtmlDocument doc) {
        this.m_document = doc;
    }

    public AHtmlDocument getHtmlDocument() {
        return this.m_document;
    }

    public void setBrowserBinding(IBrowserBinding binding) {
        this.m_browserBinding = binding;
        if (this.m_document != null) {
            this.m_document.setBrowserBinding(this.m_browserBinding);
        }
        if (this.m_navigator != null) {
            ((ANavigator)this.m_navigator).setBrowserBinding(this.m_browserBinding);
        }
        if (this.m_screen != null) {
            ((AScreen)this.m_screen).setBrowserBinding(this.m_browserBinding);
        }
        if (this.m_history != null) {
            ((AHistory)this.m_history).setBrowserBinding(this.m_browserBinding);
        }
    }

    public IBrowserBinding getBrowserBinding() {
        return this.m_browserBinding;
    }

    public void destroy() {
        Context.exit();
    }

    public void setParent(Window parent) {
        this.m_parent = parent;
        this.m_top = this.m_parent.getTop();
    }

    public void waitForAllJsExecutionDone(long timeoutInMs) {
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj == NOT_FOUND) {
            obj = this.getParentScope().get(name, start);
            if (obj != NOT_FOUND) {
                return obj;
            }
            if (constants.get(name) != null) {
                return NOT_FOUND;
            }
            Class c = JsNativeMeta.getClass((String)name);
            if (c != null) {
                return new NativeJavaClass(this.m_scope, c);
            }
            int size = this.m_frames.size();
            int i = 0;
            while (i < size) {
                AWindow child = (AWindow)this.m_frames.at(i);
                if (child.getName().equals(name)) {
                    return child;
                }
                obj = child.get(name, start);
                if (obj != NOT_FOUND) {
                    return obj;
                }
                ++i;
            }
        }
        return obj;
    }

    void init(AWindow parent, Context cx, Scriptable scope, BrowserType browserType, WindowTaskManager taskMgr) {
        this.m_browserType = browserType;
        this.m_isRoot = true;
        if (parent == null) {
            this.m_parent = this;
            this.m_top = this;
            this.m_opener = this;
        } else {
            this.m_parent = parent;
            this.m_top = this.m_parent.getTop();
        }
        this.m_cx = cx;
        this.m_scope = scope;
        this.populateScriptable(AWindow.class, this.m_browserType);
        this.m_location = new ALocation(this);
        this.m_document = new AHtmlDocument((ALocation)this.m_location, this.m_browserType);
        this.m_document.setBrowserBinding(this.m_browserBinding);
        this.m_document.setScriptContext(this.m_cx);
        this.m_document.setScriptScope(this.m_scope);
        this.m_document.setWindow(this);
        this.m_builder = new AHtmlBuilder(this.m_document);
        this.m_builder.setFixDuplicateIds(true);
        this.m_history = new AHistory(browserType);
        ((AHistory)this.m_history).setBrowserBinding(this.m_browserBinding);
        this.m_navigator = new ANavigator(this.m_browserType);
        ((ANavigator)this.m_navigator).setBrowserBinding(this.m_browserBinding);
        this.m_screen = new AScreen(browserType);
        ((AScreen)this.m_screen).setBrowserBinding(this.m_browserBinding);
        this.m_frames = new AFrames();
        this.m_taskMgr = taskMgr;
        String s = " function Image(arg0,arg1) { var img = document.createElement('img'); img.border=0; img.name=\"\"; img.src=\"\"; img.lowsrc=\"\"; img.width=arg0||0; img.height=arg1||0; img.hspace=0; img.vspace=0; img.complete=true; return img; };";
        s = String.valueOf(s) + " function Option(stext,svalue,bdefaultSelected,bselected) { var option = document.createElement('option'); option.text=stext; option.value=svalue; var defSel = false||bdefaultSelected; var sel = false||bselected; option.defaultSelected=defSel; option.selected=sel; return option; }";
        ScriptExecutor.executeScript(s, this);
        try {
            ScriptableObject.defineClass((Scriptable)this, XMLHttpRequestImpl.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to define class XMLHttpRequestImpl", e);
        }
        s = this.m_browserType.isIE() ? "function ActiveXObject() {return new XMLHttpRequestImpl(window);}" : "function XMLHttpRequest() {return new XMLHttpRequestImpl(window);}";
        this.m_cx.evaluateString((Scriptable)this, s, "XMLHttpRequest", 0, null);
    }

    AHtmlBuilder getHtmlBuilder() {
        return this.m_builder;
    }

    URL getURL() {
        String urlString;
        if (this.m_url == null && (urlString = this.getValue("URL", null)) != null) {
            try {
                this.m_url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return this.m_url;
    }

    public void setURL(URL url) {
        this.m_url = url;
    }

    IDocListener getDocListener() {
        return this.m_document.getDocListener();
    }

    void setDocListener(IDocListener listener) {
        this.m_document.setDocListener(listener);
    }

    public void addDomListener(IDomChangeListener domListener, boolean enabled) {
        if (this.m_domListener == null) {
            this.m_domListener = new DomChangeListenerAdapter();
        }
        this.m_domListener.add(domListener);
        this.m_domChangeListenerEnabled = enabled;
    }

    public IDomChangeListener getDomListener() {
        AWindow window = DapCtx.ctx().getWindow();
        if (window == null) {
            window = this;
        }
        if (!window.m_domChangeListenerEnabled) {
            return null;
        }
        return window.m_domListener;
    }

    public boolean isDomChangeListenerEnabled() {
        return this.m_domChangeListenerEnabled;
    }

    public void enableDomChangeListener(boolean set) {
        this.m_domChangeListenerEnabled = set;
    }

    String getGeneratedContentFromScript() {
        return this.m_document.getGeneratedContent();
    }

    boolean isRoot() {
        return this.m_isRoot;
    }

    void setRoot(boolean value) {
        this.m_isRoot = value;
    }

    public void setDebugger(DebuggerAdapter dbg) {
        this.m_dbg = dbg;
    }

    public DebuggerAdapter getDebugger() {
        return this.m_dbg;
    }

    public BrowserType getBrowserType() {
        return this.m_browserType;
    }

    public void finialize() {
        Context.exit();
        if (this.m_dbg != null) {
            this.m_dbg.dispose();
            this.m_dbg = null;
        }
    }

    private String getValue(String name, String fallback) {
        String value;
        if (this.m_browserBinding != null && (value = this.m_browserBinding.getDocumentProperty(name)) != null) {
            return value;
        }
        return fallback;
    }

    public HtmlElementStyle getComputedStyle(HtmlElement elem, String pseudoElem) {
        return elem.getCurrentStyle();
    }

    public External getExternal() {
        if (this.m_external == null) {
            this.m_external = new AExternal(this.m_browserType, this.m_browserBinding);
        }
        return this.m_external;
    }

    public Frames getChildWindows() {
        return this.m_frames;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public void setEvent(Object event) {
        if (event instanceof Event) {
            this.m_event = (Event)event;
        }
    }

    public Object getOnLoad() {
        return this.getListener(EventType.LOAD.getName());
    }

    public Object getOnload() {
        return this.getOnLoad();
    }

    public Object getOnBlur() {
        return this.getListener(EventType.BLUR.getName());
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnFocus() {
        return this.getListener(EventType.FOCUS.getName());
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public Object getOnResize() {
        return this.getListener(EventType.RESIZE.getName());
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public Object getOnUnload() {
        return this.getListener(EventType.UNLOAD.getName());
    }

    public Object getOnunload() {
        return this.getOnLoad();
    }

    public void setOnLoad(Object functionRef) {
        this.registerAndBind(EventType.LOAD.getName(), functionRef);
    }

    public void setOnload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    public void setOnBlur(Object functionRef) {
        this.registerAndBind(EventType.BLUR.getName(), functionRef);
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnFocus(Object functionRef) {
        this.registerAndBind(EventType.FOCUS.getName(), functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public void setOnResize(Object functionRef) {
        this.registerAndBind(EventType.RESIZE.getName(), functionRef);
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public void setOnUnload(Object functionRef) {
        this.registerAndBind(EventType.UNLOAD.getName(), functionRef);
    }

    public void setOnunload(Object functionRef) {
        this.setOnLoad(functionRef);
    }

    public void addEventListener(String type, Object listener, boolean useCapture) {
        if (this.isValidEvent(type)) {
            this.getHtmlDocument().addListener(type, listener, useCapture, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
        }
    }

    public void add(String type, Object listener, boolean useCapture) {
        this.addEventListener(type, listener, useCapture);
    }

    public void attachEvent(String type, Object listener) {
        if (this.isValidEvent(type)) {
            this.getHtmlDocument().addListener(type, listener, false, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
        }
    }

    public boolean dispatchEvent(Event evt) throws EventException {
        return this.getHtmlDocument().dispatchEvent(evt);
    }

    public boolean fireEvent(String evtType) {
        evtType = AHtmlHelper.getCorrectType(evtType);
        return this.getHtmlDocument().fireEvent(evtType);
    }

    public void removeEventListener(String type, Object listener, boolean useCapture) {
        type = AHtmlHelper.getCorrectType(type);
        this.getHtmlDocument().removeEventListener(type, listener, useCapture);
    }

    private Object getListener(String type) {
        return this.getHtmlDocument().getListener(type);
    }

    protected void registerAndBind(String type, Object handler) {
        this.getHtmlDocument().registerAndBind(type, handler);
    }

    private boolean isValidEvent(String type) {
        type = AHtmlHelper.getCorrectType(type);
        return VALID_EVENTS.contains(type);
    }

    public void detachEvent(String type, Object listener) {
        type = AHtmlHelper.getCorrectType(type);
        this.getHtmlDocument().removeEventListener(type, listener, false);
    }

    public XMLHttpRequest newXmlHttpReq() {
        return new XMLHttpRequestImpl(this);
    }

    public Option newOption() {
        AOption option = new AOption((AHtmlDocument)this.getDocument(), new DOption());
        return option;
    }

    public Option newOption(String text) {
        AOption option = new AOption((AHtmlDocument)this.getDocument(), new DOption());
        option.setText(text);
        return option;
    }

    public Option newOption(String text, String value) {
        AOption option = new AOption((AHtmlDocument)this.getDocument(), new DOption());
        option.setText(text);
        option.setValue(value);
        return option;
    }

    public Option newOption(String text, String value, boolean defaultSelected) {
        AOption option = new AOption((AHtmlDocument)this.getDocument(), new DOption());
        option.setText(text);
        option.setValue(value);
        option.setDefaultSelected(defaultSelected);
        return option;
    }

    public Option newOption(String text, String value, boolean defaultSelected, boolean selected) {
        AOption option = new AOption((AHtmlDocument)this.getDocument(), new DOption());
        option.setText(text);
        option.setValue(value);
        option.setDefaultSelected(defaultSelected);
        option.setSelected(selected);
        return option;
    }

    public Image newImage() {
        AImage image = new AImage((AHtmlDocument)this.getDocument(), new DImg());
        return image;
    }

    public Image newImage(int width) {
        AImage image = new AImage((AHtmlDocument)this.getDocument(), new DImg());
        image.setWidth(width);
        return image;
    }

    public Image newImage(int width, int height) {
        AImage image = new AImage((AHtmlDocument)this.getDocument(), new DImg());
        image.setWidth(width);
        image.setHeight(height);
        return image;
    }

    public void handleDynamicScript(DScript script) {
        String scriptType = script.getHtmlType();
        if (!JS_TYPE.equalsIgnoreCase(scriptType)) {
            return;
        }
        String src = script.getHtmlSrc();
        if (src != null) {
            JsonpProxy.evaluate(src, this);
            script.removeAttribute((Enum)EHtmlAttr.src);
        }
    }

    public String getTitle() {
        return this.getDocument().getTitle();
    }

    public void setTitle(String title) {
        this.getDocument().setTitle(title);
    }

    public Opera getOpera() {
        if (this.m_opera == null) {
            this.m_opera = new AOpera(this.m_browserType, this.m_browserBinding);
        }
        return this.m_opera;
    }
}

