/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.client;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.active.client.BrowserSupport;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.anno.Function;
import org.eclipse.vjet.dsf.jsnative.anno.Property;
import org.eclipse.vjet.dsf.jsnative.anno.ProxyFunc;
import org.mozilla.mod.javascript.FunctionObject;
import org.mozilla.mod.javascript.IWillBeScriptable;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Wrapper;

public abstract class ActiveObject
extends ScriptableObject
implements Wrapper {
    private static final long serialVersionUID = 1L;
    private List<String> m_ptys = new ArrayList<String>(10);
    private List<String> m_funcs = new ArrayList<String>(10);
    static final Map<TypeKey, TypeInfo> typeCache = new ConcurrentHashMap<TypeKey, TypeInfo>();

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Object unwrap() {
        return this;
    }

    public List<String> getProperties() {
        return Collections.unmodifiableList(this.m_ptys);
    }

    public List<String> getFunctions() {
        return Collections.unmodifiableList(this.m_funcs);
    }

    protected void populateScriptable(Class klass, BrowserType browserType) {
        HashSet<String> propList = new HashSet<String>(1000);
        HashSet<String> methodList = new HashSet<String>(1000);
        LinkedHashMap<String, String> proxyMethods = new LinkedHashMap<String, String>(1000);
        this.extract(this.getScriptableInterfaces(klass), browserType, propList, methodList, proxyMethods);
        String[] propNames = propList.toArray(new String[propList.size()]);
        this.defineProperties(propNames, klass);
        String[] methodNames = methodList.toArray(new String[methodList.size()]);
        this.defineFunctionProperties(methodNames, klass);
        this.defineFunctionProperties(proxyMethods, klass);
    }

    private Class[] getScriptableInterfaces(Class klass) {
        ArrayList intfs = new ArrayList();
        if (klass == null) {
            throw new DsfRuntimeException("null class passed");
        }
        Class<?>[] interfaces = klass.getInterfaces();
        if (interfaces != null) {
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i = classArray[n2];
                if (IWillBeScriptable.class.isAssignableFrom(i)) {
                    intfs.add(i);
                }
                ++n2;
            }
        }
        if (intfs.size() == 0) {
            throw new DsfRuntimeException(String.valueOf(klass.getName()) + " doesn't implement Scriptable interface");
        }
        Class[] out = new Class[intfs.size()];
        intfs.toArray(out);
        return out;
    }

    private void defineFunctionProperties(Map<String, String> proxyMethods, Class klass) {
        for (Map.Entry<String, String> entry : proxyMethods.entrySet()) {
            Method proxyMethod = null;
            try {
                proxyMethod = klass.getMethod(entry.getKey(), Object.class, Object.class, Object.class, Object.class, Object.class);
            }
            catch (Exception e) {
                throw new DsfRuntimeException((Throwable)e);
            }
            FunctionObject f = new FunctionObject(entry.getValue(), (Member)proxyMethod, (Scriptable)this);
            ActiveObject.defineProperty((Scriptable)this, (String)entry.getValue(), (Object)f, (int)2);
        }
    }

    private void defineFunctionProperties(String[] methodNames, Class klass) {
        if (methodNames == null || methodNames.length == 0) {
            return;
        }
        this.defineFunctionProperties(methodNames, klass, 4);
        int i = 0;
        while (i < methodNames.length) {
            this.m_funcs.add(methodNames[i]);
            ++i;
        }
    }

    private void defineProperties(String[] propertyNames, Class klass) {
        if (propertyNames == null || propertyNames.length == 0) {
            return;
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.defineProperty(propertyNames[i], klass, 4);
            this.m_ptys.add(propertyNames[i]);
            ++i;
        }
    }

    protected void defineProperties(Set<String> propertyNames, Class klass) {
        if (propertyNames == null || propertyNames.size() == 0) {
            return;
        }
        for (String prop : propertyNames) {
            this.defineProperty(prop, klass, 4);
            this.m_ptys.add(prop);
        }
    }

    private void extract(Class[] typeList, BrowserType browserType, Set<String> propList, Set<String> methodList, Map<String, String> proxyMethodList) {
        Class[] classArray = typeList;
        int n = typeList.length;
        int n2 = 0;
        while (n2 < n) {
            Class t = classArray[n2];
            TypeKey key = new TypeKey(t, browserType);
            TypeInfo info = typeCache.get(key);
            if (info == null) {
                Method[] mtds;
                info = new TypeInfo();
                Method[] methodArray = mtds = t.getDeclaredMethods();
                int n3 = mtds.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (!m.getDeclaringClass().equals(IWillBeScriptable.class) && Modifier.isPublic(m.getModifiers()) && (browserType == null || BrowserSupport.support(m, browserType) || BrowserSupport.support(m, BrowserType.RHINO_1P))) {
                        String mtdName = m.getName();
                        String probName = null;
                        Property p = m.getAnnotation(Property.class);
                        if (p != null) {
                            if (!mtdName.startsWith("get") && !mtdName.startsWith("set")) {
                                throw new DsfRuntimeException(String.valueOf(t.getName()) + ":" + mtdName + " is not a proper getter/setter.");
                            }
                            probName = p.name();
                            if (probName == null || probName.length() == 0) {
                                probName = AHtmlHelper.getOriginalPropertyName(mtdName.substring(3));
                            }
                            info.props.add(probName);
                            if (!propList.contains(mtdName)) {
                                propList.add(probName);
                            }
                        } else if (m.getAnnotation(Function.class) != null) {
                            info.methods.add(mtdName);
                            if (!methodList.contains(mtdName)) {
                                methodList.add(mtdName);
                            }
                        } else {
                            ProxyFunc func = m.getAnnotation(ProxyFunc.class);
                            if (func != null) {
                                if (!info.proxyMethods.containsKey(mtdName)) {
                                    info.proxyMethods.put(mtdName, func.value());
                                }
                                if (!proxyMethodList.containsKey(mtdName)) {
                                    proxyMethodList.put(mtdName, func.value());
                                }
                            }
                        }
                    }
                    ++n4;
                }
                typeCache.put(key, info);
            } else {
                propList.addAll(info.props);
                methodList.addAll(info.methods);
                ActiveObject.mergeMap(proxyMethodList, info.proxyMethods);
            }
            ++n2;
        }
    }

    private static void mergeMap(Map<String, String> origin, Map<String, String> delta) {
        for (Map.Entry<String, String> entry : delta.entrySet()) {
            if (origin.containsKey(entry.getKey())) continue;
            origin.put(entry.getKey(), entry.getValue());
        }
    }

    private static class TypeInfo {
        Set<String> props = new HashSet<String>(150);
        Set<String> methods = new HashSet<String>(150);
        Map<String, String> proxyMethods = new HashMap<String, String>(150);

        private TypeInfo() {
        }
    }

    private static class TypeKey {
        Class<?> clz;
        BrowserType browser;

        public TypeKey(Class<?> clz, BrowserType browser) {
            this.clz = clz;
            this.browser = browser;
        }

        public boolean equals(Object o) {
            if (o instanceof TypeKey) {
                TypeKey key = (TypeKey)o;
                return this.compareObj(this.clz, key.clz) && this.compareObj(this.browser, key.browser);
            }
            return false;
        }

        private boolean compareObj(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 != null && obj2 != null) {
                return obj1.equals(obj2);
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            if (this.clz != null) {
                hash += this.clz.hashCode() * 31;
            }
            if (this.browser != null) {
                hash += this.browser.hashCode();
            }
            return hash;
        }
    }
}

