/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DA;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlAnchor;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlAnchor
extends AHtmlElement
implements HtmlAnchor {
    private static final long serialVersionUID = 1L;
    private static final String FOCUS_JS_METHOD = "focus()";

    protected AHtmlAnchor(AHtmlDocument doc, DA node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlAnchor.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    @Override
    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDa(), FOCUS_JS_METHOD);
        }
    }

    public String getAccessKey() {
        return this.getDa().getHtmlAccessKey();
    }

    public String getCharset() {
        return this.getDa().getHtmlCharset();
    }

    public String getCoords() {
        return this.getDa().getHtmlCoords();
    }

    public String getHref() {
        return this.getDa().getHtmlHref();
    }

    public String getHreflang() {
        return this.getDa().getHtmlHreflang();
    }

    public String getName() {
        return this.getDa().getHtmlName();
    }

    public String getRel() {
        return this.getDa().getHtmlRel();
    }

    public String getRev() {
        return this.getDa().getHtmlRev();
    }

    public String getShape() {
        return this.getDa().getHtmlShape();
    }

    public int getTabIndex() {
        return this.getDa().getHtmlTabIndex();
    }

    public String getTarget() {
        return this.getDa().getHtmlTarget();
    }

    public String getType() {
        return this.getDa().getHtmlType();
    }

    public void setAccessKey(String accessKey) {
        this.getDa().setHtmlAccessKey(accessKey);
        this.onAttrChange(EHtmlAttr.accesskey, accessKey);
    }

    public void setCharset(String charset) {
        this.getDa().setHtmlCharset(charset);
        this.onAttrChange(EHtmlAttr.charset, charset);
    }

    public void setCoords(String coords) {
        this.getDa().setHtmlCoords(coords);
        this.onAttrChange(EHtmlAttr.coords, coords);
    }

    public void setHref(String href) {
        this.getDa().setHtmlHref(href);
        this.onAttrChange(EHtmlAttr.href, href);
    }

    public void setHreflang(String hreflang) {
        this.getDa().setHtmlHreflang(hreflang);
        this.onAttrChange(EHtmlAttr.hreflang, hreflang);
    }

    public void setName(String name) {
        this.getDa().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setRel(String rel) {
        this.getDa().setHtmlRel(rel);
        this.onAttrChange(EHtmlAttr.rel, rel);
    }

    public void setRev(String rev) {
        this.getDa().setHtmlRev(rev);
        this.onAttrChange(EHtmlAttr.rev, rev);
    }

    public void setShape(String shape) {
        this.getDa().setHtmlShape(shape);
        this.onAttrChange(EHtmlAttr.shape, shape);
    }

    public void setTabIndex(int tabIndex) {
        this.getDa().setHtmlTabIndex(tabIndex);
        this.onAttrChange(EHtmlAttr.tabindex, String.valueOf(tabIndex));
    }

    public void setTarget(String target) {
        this.getDa().setHtmlTarget(target);
        this.onAttrChange(EHtmlAttr.target, target);
    }

    public void setType(String type) {
        this.getDa().setHtmlType(type);
        this.onAttrChange(EHtmlAttr.type, type);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DA getDa() {
        return (DA)this.getDNode();
    }
}

