/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ccil.cowan.tagsoup.Schema;
import org.eclipse.vjet.dsf.active.client.ATextRectangle;
import org.eclipse.vjet.dsf.active.client.ScriptExecutor;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.ADocumentFragment;
import org.eclipse.vjet.dsf.active.dom.html.AElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElementCurrentStyle;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElementRuntimeStyle;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElementStyle;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFactory;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlForm;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlScript;
import org.eclipse.vjet.dsf.active.dom.html.AJavaScriptHandlerHolder;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.active.event.IDomEventBindingListener;
import org.eclipse.vjet.dsf.active.event.IDomEventPublisher;
import org.eclipse.vjet.dsf.active.event.IEventListenersCollector;
import org.eclipse.vjet.dsf.active.util.ANodeHelper;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleDeclaration;
import org.eclipse.vjet.dsf.dap.rt.DapDomEventBindingListener;
import org.eclipse.vjet.dsf.dap.util.DapDomHelper;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.HtmlBuilderHelper;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.sax.AHtmlSchema;
import org.eclipse.vjet.dsf.jsnative.ElementView;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlElementStyle;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.TextRectangle;
import org.eclipse.vjet.dsf.jsnative.TextRectangleList;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jsnative.events.Event;
import org.eclipse.vjet.dsf.jsnative.events.EventException;
import org.eclipse.vjet.dsf.jsnative.events.EventTarget;
import org.mozilla.mod.javascript.Context;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

public class AHtmlElement
extends AElement
implements HtmlElement,
ElementView,
EventTarget,
IEventListenersCollector {
    static final String FOCUS_JS_METHOD = "focus()";
    private static final long serialVersionUID = 1L;
    private HtmlElementStyle m_style = null;
    private HtmlElementStyle m_currentStyle = null;
    private HtmlElementStyle m_runtimeStyle = null;
    private TextRectangle m_textRectangle;
    private Map<String, List<AJavaScriptHandlerHolder>> m_listeners = null;
    private static final String COMPARE_DOCUMENT_POSITION = "{0}.compareDocumentPosition({1})";
    private static final String JS_TYPE = "text/javascript";

    protected AHtmlElement(AHtmlDocument doc, BaseHtmlElement node) {
        super(doc, (DElement)node);
        this.populateScriptable(AHtmlElement.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    protected AHtmlElement(AHtmlDocument doc, DElement node) {
        super(doc, node);
        this.populateScriptable(AHtmlElement.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public void addEventListener(String type, Object listener, boolean useCapture) {
        this.addListener(type, listener, useCapture, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
    }

    public void add(String type, Object listener, boolean useCapture) {
        this.addEventListener(type, listener, useCapture);
    }

    public Node addBr() {
        HtmlElement newChild = this.getOwnerDocument().createElement("br");
        this.appendChild((Node)newChild);
        return newChild;
    }

    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod(this.getElement(), FOCUS_JS_METHOD);
        }
    }

    public void removeEventListener(String type, Object listener, boolean useCapture) {
        this.removeListener(type, listener, useCapture);
    }

    public boolean dispatchEvent(Event evt) throws EventException {
        return this.dispatchEvent(evt.getType(), this);
    }

    @Override
    public AHtmlDocument getOwnerDocument() {
        return (AHtmlDocument)super.getOwnerDocument();
    }

    private boolean isDynamicScript(AHtmlScript script) {
        String src = script.getSrc();
        return src != null && src.trim().length() != 0;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        Node[] arr = this.getDocumentFragmentNodes(newChild);
        if (arr != null) {
            Node[] nodeArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                this.appendChild(node);
                ++n2;
            }
            return newChild;
        }
        super.appendChild(newChild);
        if (newChild instanceof AHtmlElement) {
            ((AHtmlElement)newChild).associateIdElementsToDoc();
        }
        this.onAppendChild((ANode)newChild);
        this.evalJs(newChild);
        return newChild;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Node[] arr = this.getDocumentFragmentNodes(newChild);
        if (arr != null) {
            Node[] nodeArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                this.insertBefore(node, refChild);
                ++n2;
            }
            return newChild;
        }
        if (refChild == null) {
            this.appendChild(newChild);
            return newChild;
        }
        Node oldParent = newChild.getParentNode();
        if (oldParent != null) {
            oldParent.removeChild(newChild);
        }
        this.onInsert((ANode)newChild, (ANode)refChild, true);
        Node rtnVal = super.insertBefore(newChild, refChild);
        if (newChild instanceof AHtmlElement) {
            ((AHtmlElement)newChild).associateIdElementsToDoc();
        }
        this.evalJs(newChild);
        return rtnVal;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        this.onRemove((ANode)oldChild);
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        super.replaceChild(newChild, oldChild);
        this.onElementChange();
        return oldChild;
    }

    @Override
    public String getClassName() {
        return this.getHtmlAttribute(EHtmlAttr._class);
    }

    public String getDir() {
        return this.getHtmlAttribute(EHtmlAttr.dir);
    }

    public String getId() {
        return this.getHtmlAttribute(EHtmlAttr.id);
    }

    public String getLang() {
        return this.getHtmlAttribute(EHtmlAttr.lang);
    }

    public String getTitle() {
        return this.getHtmlAttribute(EHtmlAttr.title);
    }

    public HtmlElementStyle getStyle() {
        if (this.m_style == null) {
            this.m_style = new AHtmlElementStyle(this);
        }
        return this.m_style;
    }

    public String getInnerHTML() {
        if (this.m_childNodes == null || this.m_childNodes.getLength() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.m_childNodes.getLength()) {
            sb.append(ANodeHelper.getHtmlText((ANode)this.m_childNodes.item(i)));
            ++i;
        }
        return sb.toString();
    }

    public String getStyleAsString() {
        return this.getHtmlStyleAsString();
    }

    public void setClassName(String className) {
        this.setHtmlAttribute(EHtmlAttr._class, className);
    }

    public void setDir(String dir) {
        this.setHtmlAttribute(EHtmlAttr.dir, dir);
    }

    public void setId(String id) {
        this.setHtmlAttribute(EHtmlAttr.id, id);
    }

    public void setLang(String lang) {
        this.setHtmlAttribute(EHtmlAttr.lang, lang);
    }

    public void setTitle(String title) {
        this.setHtmlAttribute(EHtmlAttr.title, title);
    }

    public void setStyle(HtmlElementStyle style) {
        this.m_style = style;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        super.setAttribute(name, value);
        if ("id".equalsIgnoreCase(name)) {
            this.setIdAttribute("id", true);
        }
        try {
            if (!"style".equalsIgnoreCase(name)) {
                if ("class".equalsIgnoreCase(name)) {
                    this.onAttrChange(EHtmlAttr.className, value);
                } else {
                    this.onAttrChange(EHtmlAttr.enumFor((String)name), value);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        super.setIdAttribute(name, isId);
        String id = this.getAttribute(name);
        if (id == null) {
            throw new ADOMException(new DOMException(8, "no attribute found with name " + name));
        }
        AHtmlDocument doc = this.getOwnerDocument();
        if (isId) {
            if (AHtmlElement.isInDom(this, doc.getHtml())) {
                doc.putIdentifier(id, this);
            }
        } else {
            doc.removeIdentifier(id);
        }
    }

    public void setInnerHTML(String html) {
        if (this.m_childNodes != null) {
            int i = this.m_childNodes.getLength() - 1;
            while (i >= 0) {
                ANode child = (ANode)this.m_childNodes.item(i);
                this.removeChild(child);
                child.setOwnerDocument(null);
                child.getDNode().dsfDetachFromOwnerDocument();
                --i;
            }
        }
        String source = html == null ? "<body></body>" : (html.startsWith("<body>") ? html : "<body>" + html + "</body>");
        DHtmlDocument doc = HtmlBuilderHelper.parseHtmlFragment((String)source, (boolean)true, (Schema)AHtmlSchemaForParser.getInstance());
        DBody body = doc.getBody();
        DNode child = (DNode)body.getFirstChild();
        while (child != null) {
            body.removeChild((org.w3c.dom.Node)child);
            child.dsfDetachFromOwnerDocument();
            AHtmlFactory.appendChild(this, child);
            child = (DNode)body.getFirstChild();
        }
    }

    protected AHtmlForm getFormInternal() {
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof AHtmlForm) {
                return (AHtmlForm)parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    @Override
    public String getTagName() {
        return super.getTagName().toUpperCase();
    }

    protected void onElementChange() {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onElementChange((BaseHtmlElement)this.getDNode());
        }
    }

    protected void onAppendChild(ANode newChild) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null && this.isInDoc(newChild)) {
            listener.onAppendChild((org.w3c.dom.Node)newChild.getDNode());
            this.enableDeferedElementsEventBinding(newChild);
        }
    }

    private boolean isInDoc(ANode node) {
        return DapDomHelper.isInDoc((org.w3c.dom.Node)node.getDNode());
    }

    private void collectDeferedElementEvents(ANode node, String eventType) {
        Map<ANode, List<String>> elmEvtMap = this.getOwnerDocument().getDeferedANodeEventMap();
        List<String> events = elmEvtMap.get(node);
        if (events == null) {
            events = new ArrayList<String>(2);
            elmEvtMap.put(node, events);
        }
        events.add(eventType);
    }

    private void enableDeferedElementsEventBinding(ANode newChild) {
        AHtmlDocument doc = this.getOwnerDocument();
        DapDomEventBindingListener binding = (DapDomEventBindingListener)doc.getDomEventBindingListener();
        if (binding == null) {
            return;
        }
        Map<ANode, List<String>> elmEvtMap = doc.getDeferedANodeEventMap();
        if (elmEvtMap.size() == 0) {
            return;
        }
        Set<ANode> keys = elmEvtMap.keySet();
        ArrayList<ANode> toBeRemoved = new ArrayList<ANode>();
        for (ANode node : keys) {
            List<String> evts = elmEvtMap.get(node);
            int size = evts.size();
            if (size <= 0 || !AHtmlElement.isInDom(node, newChild)) continue;
            int i = 0;
            while (i < size) {
                binding.eventBound((org.w3c.dom.Node)node.getDNode(), evts.get(i));
                ++i;
            }
            toBeRemoved.add(node);
        }
        for (ANode node : toBeRemoved) {
            elmEvtMap.remove(node);
        }
    }

    protected void onInsert(ANode newNode, ANode refNode, boolean insertBefore) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onInsert((org.w3c.dom.Node)newNode.getDNode(), (org.w3c.dom.Node)refNode.getDNode(), insertBefore);
        }
    }

    protected void onRemove(ANode newNode) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onRemove((org.w3c.dom.Node)newNode.getDNode());
        }
    }

    protected void onValueChange(String value) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onValueChange((BaseHtmlElement)this.getDNode(), value);
        }
    }

    protected void onAttrChange(EHtmlAttr attr, boolean value) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onAttrChange((BaseHtmlElement)this.getDNode(), attr, value);
        }
    }

    protected void onAttrChange(EHtmlAttr attr, int value) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onAttrChange((BaseHtmlElement)this.getDNode(), attr, value);
        }
    }

    protected void onAttrChange(EHtmlAttr attr, double value) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onAttrChange((BaseHtmlElement)this.getDNode(), attr, value);
        }
    }

    protected void onAttrChange(EHtmlAttr attr, String value) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onAttrChange((BaseHtmlElement)this.getDNode(), attr, value);
        }
    }

    public void onWidthChange(int width) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onWidthChange((BaseHtmlElement)this.getDNode(), width);
        }
    }

    public void onHeightChange(int height) {
        IDomChangeListener listener = this.getChangeListener();
        if (listener != null) {
            listener.onHeightChange((BaseHtmlElement)this.getDNode(), height);
        }
    }

    private IDomChangeListener getChangeListener() {
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        return doc.getDomListener();
    }

    private IBrowserBinding getBrowserBinding() {
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc == null) {
            return null;
        }
        return doc.getBrowserBinding();
    }

    protected boolean dispatchEvent(String evtType, EventTarget src) {
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc == null) {
            return false;
        }
        IDomEventPublisher dispatcher = doc.getEventDispatcher();
        if (dispatcher == null) {
            return false;
        }
        return dispatcher.publish(evtType, src);
    }

    CSSStyleDeclaration getHtmlStyle() {
        String styleString = this.getHtmlAttribute(EHtmlAttr.style);
        if (styleString == null || "".equals(styleString)) {
            return null;
        }
        DCssStyleDeclaration style = new DCssStyleDeclaration(null);
        style.setCssText("{" + styleString + "}");
        return style;
    }

    String getHtmlStyleAsString() {
        String styleString = this.getHtmlAttribute(EHtmlAttr.style);
        if (styleString == null || "".equals(styleString)) {
            return null;
        }
        return styleString;
    }

    @Override
    String getHtmlAttribute(EHtmlAttr attr) {
        return this.getAttribute(attr.getAttributeName());
    }

    @Override
    void setHtmlAttribute(EHtmlAttr attr, boolean value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    @Override
    void setHtmlAttribute(EHtmlAttr attr, int value) {
        this.setHtmlAttribute(attr, String.valueOf(value));
    }

    @Override
    void setHtmlAttribute(EHtmlAttr attr, String value) {
        this.setAttribute(attr.getAttributeName(), value);
    }

    void setHtmlStyle(CSSStyleDeclaration style) {
        if (style == null) {
            if (this.hasAttributes()) {
                this.getElement().removeAttribute((Enum)EHtmlAttr.style);
            }
            return;
        }
        String styleString = style.getCssText();
        String realText = styleString.substring(1, styleString.length() - 1);
        this.setHtmlAttribute(EHtmlAttr.style, realText);
    }

    private BaseHtmlElement getElement() {
        return (BaseHtmlElement)this.getDNode();
    }

    @Override
    protected int getIntBindingValue(EHtmlAttr attr) {
        String value = this.getBindingValue(attr);
        if (value == null || value.length() == 0) {
            return 0;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    protected String getBindingValue(EHtmlAttr attr) {
        BaseHtmlElement elem = this.getElement();
        String value = null;
        IBrowserBinding browserBinding = this.getBrowserBinding();
        if (browserBinding != null) {
            value = browserBinding.getDomAttributeValue(elem, attr);
        }
        if (value != null) {
            return value;
        }
        return this.getHtmlAttribute(attr);
    }

    protected void onStyleChange(String name, String value) {
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc == null) {
            return;
        }
        IDomChangeListener listener = doc.getDomListener();
        if (listener != null) {
            listener.onStyleChange((BaseHtmlElement)this.getDNode(), name, value);
        }
    }

    @Override
    void setOwnerDocument(ADocument doc) {
        String idValue;
        super.setOwnerDocument(doc);
        if (doc != null && (idValue = this.getAttribute("id")) != null && idValue.length() > 0) {
            this.setIdAttribute("id", true);
        }
    }

    public HtmlElementStyle getCurrentStyle() {
        if (this.m_currentStyle == null) {
            this.m_currentStyle = new AHtmlElementCurrentStyle(this);
        }
        return this.m_currentStyle;
    }

    public HtmlElementStyle getRuntimeStyle() {
        if (this.m_runtimeStyle == null) {
            this.m_runtimeStyle = new AHtmlElementRuntimeStyle(this);
        }
        return this.m_runtimeStyle;
    }

    public void attachEvent(String type, Object listener) {
        type = AHtmlHelper.getCorrectType(type);
        this.addListener(type, listener, false, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.EXTERNAL);
    }

    public boolean fireEvent(String evtType) {
        evtType = AHtmlHelper.getCorrectType(evtType);
        return this.dispatchEvent(evtType, this);
    }

    public void detachEvent(String type, Object listener) {
        type = AHtmlHelper.getCorrectType(type);
        this.removeEventListener(type, listener, false);
    }

    @Override
    public void addListener(String type, Object listener, boolean useCapture, boolean bind, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE handlerType) {
        type = AHtmlHelper.getCorrectType(type);
        AHtmlHelper.addEventHandlerListeners(this.getListeners(), type, listener, handlerType);
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc == null) {
            return;
        }
        if (this.isInDoc(this)) {
            IDomEventBindingListener evtBindingListener = doc.getDomEventBindingListener();
            if (evtBindingListener != null && evtBindingListener.isEventBinding((org.w3c.dom.Node)this.getElement(), type) && bind) {
                evtBindingListener.eventBound((org.w3c.dom.Node)this.getElement(), type);
            }
        } else {
            this.collectDeferedElementEvents(this, type);
        }
    }

    @Override
    public void removeListener(String type, Object listener, boolean useCapture) {
        List<AJavaScriptHandlerHolder> lst;
        type = AHtmlHelper.getCorrectType(type);
        if (this.m_listeners != null && this.m_listeners.get(type) == null && (lst = this.m_listeners.get(type)) != null) {
            int i = 0;
            while (i < lst.size()) {
                if (lst.get(i).equals(listener)) {
                    lst.remove(i);
                }
                ++i;
            }
        }
    }

    @Override
    public Map<String, List<AJavaScriptHandlerHolder>> getListeners() {
        if (this.m_listeners == null) {
            this.m_listeners = new HashMap<String, List<AJavaScriptHandlerHolder>>();
        }
        return this.m_listeners;
    }

    @Override
    public short compareDocumentPosition(Node other) {
        IBrowserBinding browserBinding = this.getBrowserBinding();
        if (browserBinding != null) {
            String currentNodePath = AHtmlHelper.getElementPath(this);
            String otherNodePath = AHtmlHelper.getElementPath((AHtmlElement)other);
            String code = MessageFormat.format(COMPARE_DOCUMENT_POSITION, currentNodePath, otherNodePath);
            String retValue = browserBinding.executeJs(code);
            try {
                return Short.parseShort(retValue);
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    private void evalJs(Node node) {
        if (!(node instanceof AHtmlElement)) {
            return;
        }
        AHtmlDocument document = this.getOwnerDocument();
        if (document == null) {
            return;
        }
        if (!AHtmlElement.isInDom(node, document.getHtml())) {
            return;
        }
        if (node instanceof AHtmlScript) {
            this.eval((AHtmlScript)node);
            return;
        }
        NodeList scripts = ((AHtmlElement)node).getElementsByTagName("script");
        int size = scripts.getLength();
        int i = 0;
        while (i < size) {
            AHtmlScript script = (AHtmlScript)scripts.item(i);
            this.eval(script);
            ++i;
        }
    }

    private void eval(AHtmlScript script) {
        String scriptType = script.getType();
        if (!JS_TYPE.equalsIgnoreCase(scriptType)) {
            return;
        }
        AHtmlDocument document = this.getOwnerDocument();
        if (this.isDynamicScript(script)) {
            document.getWindow().handleDynamicScript((DScript)script.getDNode());
        } else {
            Context context = document.getScriptContext();
            if (context == null) {
                return;
            }
            String jsText = script.getText();
            if (jsText != null && jsText.length() != 0) {
                ScriptExecutor.executeScript(jsText, document.getWindow());
            }
        }
    }

    private static boolean isInDom(Node node, Node root) {
        if (node == null) {
            return false;
        }
        if (node == root) {
            return true;
        }
        return AHtmlElement.isInDom(node.getParentNode(), root);
    }

    private void associateIdElementsToDoc() {
        AHtmlDocument document = this.getOwnerDocument();
        if (document != null && AHtmlElement.isInDom(this, document.getHtml())) {
            this.associateIdElementsToDoc(document);
        }
    }

    private void associateIdElementsToDoc(AHtmlDocument document) {
        String idValue = this.getAttribute("id");
        if (idValue != null && idValue.length() > 0) {
            document.putIdentifier(idValue, this);
        }
        if (!this.hasChildNodes()) {
            return;
        }
        NodeList children = this.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof AHtmlElement) {
                ((AHtmlElement)child).associateIdElementsToDoc(document);
            }
            ++i;
        }
    }

    private Node[] getDocumentFragmentNodes(Node newChild) {
        ADocumentFragment frag;
        NodeList nodes;
        int size;
        if (newChild instanceof ADocumentFragment && (size = (nodes = (frag = (ADocumentFragment)newChild).getChildNodes()).getLength()) > 0) {
            Node[] arr = new Node[size];
            int i = 0;
            while (i < size) {
                arr[i] = nodes.item(i);
                ++i;
            }
            return arr;
        }
        return null;
    }

    public HtmlElement getOffsetParent() {
        IBrowserBinding browserBinding = this.getOwnerDocument().getBrowserBinding();
        String path = DapDomHelper.getPath((org.w3c.dom.Node)this.getDNode());
        if (browserBinding != null && !path.equals("document.getElementById('body')")) {
            String elm = browserBinding.executeJs(MessageFormat.format("DLC_getPath({0}.offsetParent)", path));
            ANode aelm = AHtmlHelper.getElementByPath(this.getOwnerDocument(), elm);
            if (aelm instanceof HtmlElement) {
                return (HtmlElement)aelm;
            }
        }
        return null;
    }

    public Object getOnAbort() {
        return this.getListener(EventType.ABORT.getName());
    }

    public Object getOnBlur() {
        return this.getListener(EventType.BLUR.getName());
    }

    public Object getOnChange() {
        return this.getListener(EventType.CHANGE.getName());
    }

    public Object getOnClick() {
        return this.getListener(EventType.CLICK.getName());
    }

    public Object getOnDblClick() {
        return this.getListener(EventType.DBLCLICK.getName());
    }

    public Object getOnFocus() {
        return this.getListener(EventType.FOCUS.getName());
    }

    public Object getOnKeyDown() {
        return this.getListener(EventType.KEYDOWN.getName());
    }

    public Object getOnKeyPress() {
        return this.getListener(EventType.KEYPRESS.getName());
    }

    public Object getOnKeyUp() {
        return this.getListener(EventType.KEYUP.getName());
    }

    public Object getOnLoad() {
        return this.getListener(EventType.LOAD.getName());
    }

    public Object getOnMouseDown() {
        return this.getListener(EventType.MOUSEDOWN.getName());
    }

    public Object getOnMouseMove() {
        return this.getListener(EventType.MOUSEMOVE.getName());
    }

    public Object getOnMouseOut() {
        return this.getListener(EventType.MOUSEOUT.getName());
    }

    public Object getOnMouseOver() {
        return this.getListener(EventType.MOUSEOVER.getName());
    }

    public Object getOnMouseUp() {
        return this.getListener(EventType.MOUSEUP.getName());
    }

    public Object getOnReadyStateChange() {
        return this.getListener(EventType.READYSTATECHANGE.getName());
    }

    public Object getOnreadystatechange() {
        return this.getOnReadyStateChange();
    }

    public Object getOnResize() {
        return this.getListener(EventType.RESIZE.getName());
    }

    public Object getOnReset() {
        return this.getListener(EventType.RESET.getName());
    }

    public Object getOnScroll() {
        return this.getListener(EventType.SCROLL.getName());
    }

    public Object getOnSelect() {
        return this.getListener(EventType.SELECT.getName());
    }

    public Object getOnSubmit() {
        return this.getListener(EventType.SUBMIT.getName());
    }

    public Object getOnUnload() {
        return this.getListener(EventType.UNLOAD.getName());
    }

    public void setOnAbort(Object functionRef) {
        this.registerAndBind(EventType.ABORT.getName(), functionRef);
    }

    public void setOnBlur(Object functionRef) {
        this.registerAndBind(EventType.BLUR.getName(), functionRef);
    }

    public void setOnChange(Object functionRef) {
        this.registerAndBind(EventType.CHANGE.getName(), functionRef);
    }

    public void setOnClick(Object functionRef) {
        this.registerAndBind(EventType.CLICK.getName(), functionRef);
    }

    public void setOnDblClick(Object functionRef) {
        this.registerAndBind(EventType.DBLCLICK.getName(), functionRef);
    }

    public void setOnFocus(Object functionRef) {
        this.registerAndBind(EventType.FOCUS.getName(), functionRef);
    }

    public void setOnKeyDown(Object functionRef) {
        this.registerAndBind(EventType.KEYDOWN.getName(), functionRef);
    }

    public void setOnKeyPress(Object functionRef) {
        this.registerAndBind(EventType.KEYPRESS.getName(), functionRef);
    }

    public void setOnKeyUp(Object functionRef) {
        this.registerAndBind(EventType.KEYUP.getName(), functionRef);
    }

    public void setOnLoad(Object functionRef) {
        this.registerAndBind(EventType.LOAD.getName(), functionRef);
    }

    public void setOnMouseDown(Object functionRef) {
        this.registerAndBind(EventType.MOUSEDOWN.getName(), functionRef);
    }

    public void setOnMouseMove(Object functionRef) {
        this.registerAndBind(EventType.MOUSEMOVE.getName(), functionRef);
    }

    public void setOnMouseOut(Object functionRef) {
        this.registerAndBind(EventType.MOUSEOUT.getName(), functionRef);
    }

    public void setOnMouseOver(Object functionRef) {
        this.registerAndBind(EventType.MOUSEOVER.getName(), functionRef);
    }

    public void setOnMouseUp(Object functionRef) {
        this.registerAndBind(EventType.MOUSEUP.getName(), functionRef);
    }

    public void setOnReadyStateChange(Object functionRef) {
        this.registerAndBind(EventType.READYSTATECHANGE.getName(), functionRef);
    }

    public void setOnreadystatechange(Object functionRef) {
        this.setOnReadyStateChange(functionRef);
    }

    public void setOnResize(Object functionRef) {
        this.registerAndBind(EventType.RESIZE.getName(), functionRef);
    }

    public void setOnReset(Object functionRef) {
        this.registerAndBind(EventType.RESET.getName(), functionRef);
    }

    public void setOnScroll(Object functionRef) {
        this.registerAndBind(EventType.SCROLL.getName(), functionRef);
    }

    public void setOnSelect(Object functionRef) {
        this.registerAndBind(EventType.SELECT.getName(), functionRef);
    }

    public void setOnSubmit(Object functionRef) {
        this.registerAndBind(EventType.SUBMIT.getName(), functionRef);
    }

    public void setOnUnload(Object functionRef) {
        this.registerAndBind(EventType.UNLOAD.getName(), functionRef);
    }

    protected void registerAndBind(String type, Object handler) {
        this.addListener(type, handler, false, true, AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE);
    }

    protected Object getListener(String type) {
        Map<String, List<AJavaScriptHandlerHolder>> listeners = this.getListeners();
        List<AJavaScriptHandlerHolder> lst = listeners.get(type);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        AJavaScriptHandlerHolder h = lst.get(0);
        if (h == null || h.getHandlerType() != AJavaScriptHandlerHolder.JAVASCRIPT_HANDLER_TYPE.INLINE) {
            return null;
        }
        return h.getHandler();
    }

    public TextRectangle getBoundingClientRect() {
        if (this.m_textRectangle == null) {
            this.m_textRectangle = new ATextRectangle(this.getOwnerDocument(), this, this.getBrowserBinding());
        }
        return this.m_textRectangle;
    }

    public TextRectangleList getClientRects() {
        return null;
    }

    public int getClientHeight() {
        return this.getIntBindingValue(EHtmlAttr.clientHeight);
    }

    public int getClientWidth() {
        return this.getIntBindingValue(EHtmlAttr.clientWidth);
    }

    public int getOffsetHeight() {
        return this.getIntBindingValue(EHtmlAttr.offsetHeight);
    }

    public int getOffsetLeft() {
        return this.getIntBindingValue(EHtmlAttr.offsetLeft);
    }

    public int getOffsetTop() {
        return this.getIntBindingValue(EHtmlAttr.offsetTop);
    }

    public int getOffsetWidth() {
        return this.getIntBindingValue(EHtmlAttr.offsetWidth);
    }

    public void setOffsetHeight(int hight) {
        this.setHtmlAttribute(EHtmlAttr.offsetHeight, String.valueOf(hight));
    }

    public void setOffsetLeft(int left) {
        this.setHtmlAttribute(EHtmlAttr.offsetLeft, String.valueOf(left));
    }

    public void setOffsetTop(int top) {
        this.setHtmlAttribute(EHtmlAttr.offsetTop, String.valueOf(top));
    }

    public void setOffsetWidth(int width) {
        this.setHtmlAttribute(EHtmlAttr.offsetWidth, String.valueOf(width));
    }

    public int getScrollHeight() {
        return this.getIntBindingValue(EHtmlAttr.scrollHeight);
    }

    public int getScrollLeft() {
        return this.getIntBindingValue(EHtmlAttr.scrollLeft);
    }

    public int getScrollTop() {
        return this.getIntBindingValue(EHtmlAttr.scrollTop);
    }

    public int getScrollWidth() {
        return this.getIntBindingValue(EHtmlAttr.scrollWidth);
    }

    public void setScrollHeight(int hight) {
        this.setHtmlAttribute(EHtmlAttr.scrollHeight, String.valueOf(hight));
    }

    public void setScrollLeft(int left) {
        this.setHtmlAttribute(EHtmlAttr.scrollLeft, String.valueOf(left));
    }

    public void setScrollTop(int top) {
        this.setHtmlAttribute(EHtmlAttr.scrollTop, String.valueOf(top));
    }

    public void setScrollWidth(int width) {
        this.setHtmlAttribute(EHtmlAttr.scrollWidth, String.valueOf(width));
    }

    public int getClientLeft() {
        return this.getIntBindingValue(EHtmlAttr.clientLeft);
    }

    public int getClientTop() {
        return this.getIntBindingValue(EHtmlAttr.clientTop);
    }

    protected double getDouble(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    protected int getInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String componentFromPoint(int iCoordX, int iCoordY) {
        return null;
    }

    public void doScroll(String sScrollAction) {
    }

    public void doScroll() {
    }

    public String getAdjacentText(String sWhere) {
        return null;
    }

    public static class AHtmlSchemaForParser
    extends AHtmlSchema {
        private static final AHtmlSchemaForParser s_instance = new AHtmlSchemaForParser();

        public static AHtmlSchemaForParser getInstance() {
            return s_instance;
        }

        protected void setupElementTypes() {
            super.setupElementTypes();
            this.elementType("body", 0x40411004, 2064, 0);
        }
    }
}

