/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlOptionsCollection;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlForm;
import org.eclipse.vjet.dsf.jsnative.HtmlOptGroup;
import org.eclipse.vjet.dsf.jsnative.HtmlOption;
import org.eclipse.vjet.dsf.jsnative.HtmlOptionsCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlSelect;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.Option;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.mozilla.mod.javascript.Scriptable;
import org.w3c.dom.DOMException;

public class AHtmlSelect
extends AHtmlElement
implements HtmlSelect,
IDFormControl {
    private static final long serialVersionUID = 1L;
    private static final String FOCUS_JS_METHOD = "focus()";
    private static final String SELECT_ONE = "select-one";
    private static final String SELECT_MULTIPLE = "select-multiple";
    private AHtmlOptionsCollection m_options;

    protected AHtmlSelect(AHtmlDocument doc, DSelect node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlSelect.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public ANode cloneNode(boolean deep) {
        AHtmlSelect clonedNode = (AHtmlSelect)super.cloneNode(deep);
        clonedNode.m_options = null;
        return clonedNode;
    }

    @Override
    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    @Override
    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod((BaseHtmlElement)this.getDSelect(), FOCUS_JS_METHOD);
        }
    }

    public boolean getDisabled() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.disabled, this.getHtmlAttribute(EHtmlAttr.disabled));
    }

    public HtmlForm getForm() {
        return super.getFormInternal();
    }

    public int getLength() {
        return this.getDSelect().getHtmlLength();
    }

    public boolean getMultiple() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.multiple, this.getHtmlAttribute(EHtmlAttr.multiple));
    }

    public String getName() {
        return this.getDSelect().getHtmlName();
    }

    public HtmlOptionsCollection getOptions() {
        if (this.m_options == null) {
            this.m_options = new AHtmlOptionsCollection(this, 6);
        }
        return this.m_options;
    }

    public int getSelectedIndex() {
        if (!this.getDSelect().getHtmlMultiple()) {
            int idx = this.getDSelect().getHtmlSelectedIndex();
            if (idx == -1 && this.getSize() != -1) {
                idx = 0;
                Node opt = this.getOptions().item(idx);
                if (opt != null) {
                    if (opt instanceof HtmlOption) {
                        ((HtmlOption)opt).setSelected(true);
                    } else if (opt instanceof Option) {
                        ((Option)opt).setSelected(true);
                    }
                }
            }
            return idx;
        }
        return 0;
    }

    public int getSize() {
        return this.getDSelect().getHtmlSize();
    }

    public int getTabIndex() {
        return this.getDSelect().getHtmlTabIndex();
    }

    public String getType() {
        String type = this.getDSelect().getHtmlType();
        if (type == "" || type == null) {
            type = this.getMultiple() ? SELECT_MULTIPLE : SELECT_ONE;
        }
        return type;
    }

    public String getValue() {
        if (!this.getDSelect().getHtmlMultiple()) {
            return this.getDSelect().getHtmlValue();
        }
        return "";
    }

    public void remove(Object option) {
        if (option instanceof HtmlOption) {
            this.removeOption((HtmlOption)option);
        } else if (option instanceof Option) {
            this.removeOption((Option)option);
        } else if (option instanceof Double) {
            int index = ((Double)option).intValue();
            this.removeByIndex(index);
        } else if (option instanceof Integer) {
            int index = (Integer)option;
            this.removeByIndex(index);
        }
    }

    public void removeByIndex(int index) {
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION.getName());
        Node removed = options.item(index);
        if (removed != null) {
            this.removeChild(removed);
        }
    }

    public void removeOption(HtmlOption option) {
        this.removeChild((Node)option);
    }

    public void removeOption(Option option) {
        this.removeChild((Node)option);
    }

    public void setDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        this.onAttrChange(EHtmlAttr.disabled, disabled);
    }

    public void setMultiple(boolean multiple) {
        this.setHtmlAttribute(EHtmlAttr.multiple, multiple);
        this.onAttrChange(EHtmlAttr.multiple, multiple);
    }

    public void setName(String name) {
        this.getDSelect().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    public void setSelectedIndex(int selectedIndex) {
        if (!this.getDSelect().getHtmlMultiple()) {
            this.getDSelect().setHtmlSelectedIndex(selectedIndex);
        }
    }

    public void setSize(int size) {
        this.getDSelect().setHtmlSize(size);
        this.onAttrChange(EHtmlAttr.size, String.valueOf(size));
    }

    public void setTabIndex(int tabIndex) {
        this.getDSelect().setHtmlTabIndex(tabIndex);
        this.onAttrChange(EHtmlAttr.tabindex, String.valueOf(tabIndex));
    }

    public void setValue(String value) {
        if (!this.getDSelect().getHtmlMultiple()) {
            this.getDSelect().setHtmlValue(value);
            this.onValueChange(value);
        }
    }

    public void add(HtmlElement element, HtmlElement before) {
        if (element instanceof HtmlOption || element instanceof Option || element instanceof HtmlOptGroup) {
            if (before == null) {
                this.appendChild((Node)element);
            } else {
                if (this != before.getParentNode()) {
                    throw new ADOMException(new DOMException(8, "before is not a descendant of the SELECT element"));
                }
                this.insertBefore((Node)element, (Node)before);
            }
        }
    }

    public Object get(int index, Scriptable start) {
        Object obj = null;
        obj = this.findOptionObject(index);
        if (obj != null) {
            return obj;
        }
        obj = super.get(index, start);
        return obj;
    }

    private Object findOptionObject(int index) {
        return this.getOptions().item(index);
    }

    public Object get(String name, Scriptable start) {
        Object obj = null;
        obj = this.findOptionObject(name);
        if (obj != null) {
            return obj;
        }
        obj = super.get(name, start);
        return obj;
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private Object findOptionObject(String name) {
        HtmlOptionsCollection options = this.getOptions();
        int i = 0;
        while (i < options.getLength()) {
            Node area = options.item(i);
            if (area.getNodeName().equalsIgnoreCase(name)) {
                return area;
            }
            ++i;
        }
        return null;
    }

    private DSelect getDSelect() {
        return (DSelect)this.getDNode();
    }
}

