/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlCollection;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlTableRow;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.jsnative.HtmlCollection;
import org.eclipse.vjet.dsf.jsnative.HtmlElement;
import org.eclipse.vjet.dsf.jsnative.HtmlTableSection;
import org.eclipse.vjet.dsf.jsnative.Node;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.w3c.dom.html.HTMLTableRowElement;

public class AHtmlTableSection
extends AHtmlElement
implements HtmlTableSection {
    private static final long serialVersionUID = 1L;
    private AHtmlCollection m_rows;

    protected AHtmlTableSection(AHtmlDocument doc, BaseTableSection node) {
        super(doc, (BaseHtmlElement)node);
        this.populateScriptable(AHtmlTableSection.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public ANode cloneNode(boolean deep) {
        AHtmlTableSection clonedNode = (AHtmlTableSection)super.cloneNode(deep);
        clonedNode.m_rows = null;
        return clonedNode;
    }

    public void deleteRow(int index) {
        if (index == -1) {
            Node child = this.getLastChild();
            if (child != null && child instanceof HTMLTableRowElement) {
                this.removeChild(child);
            }
        } else {
            this.deleteRowX(index);
        }
    }

    public String getAlign() {
        return this.getDTBody().getHtmlAlign();
    }

    public String getCh() {
        return this.getDTBody().getHtmlCh();
    }

    public String getChOff() {
        return this.getDTBody().getHtmlChOff();
    }

    public HtmlCollection getRows() {
        if (this.m_rows == null) {
            this.m_rows = new AHtmlCollection(this, 7);
        }
        return this.m_rows;
    }

    public String getVAlign() {
        return this.getDTBody().getHtmlValign();
    }

    public HtmlElement insertRow(int index) {
        AHtmlTableRow newRow = new AHtmlTableRow(this.getOwnerDocument(), this.getDTBody().htmlInsertRow(index));
        if (index == -1) {
            this.appendChild(newRow, false);
        } else if (this.insertRowX(index, newRow) >= 0) {
            this.appendChild(newRow, false);
        }
        this.onAppendChild(newRow);
        return newRow;
    }

    public void setAlign(String align) {
        this.getDTBody().setHtmlAlign(align);
        this.onAttrChange(EHtmlAttr.align, align);
    }

    public void setCh(String _char) {
        this.getDTBody().setHtmlCh(_char);
        this.onAttrChange(EHtmlAttr._char, _char);
    }

    public void setChOff(String charoff) {
        this.getDTBody().setHtmlChOff(charoff);
        this.onAttrChange(EHtmlAttr.charoff, charoff);
    }

    public void setVAlign(String valign) {
        this.getDTBody().setHtmlValign(valign);
        this.onAttrChange(EHtmlAttr.valign, valign);
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    int deleteRowX(int index) {
        ANode child = (ANode)this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableRowElement) {
                if (index == 0) {
                    this.removeChild(child);
                    return -1;
                }
                --index;
            }
            child = (ANode)child.getNextSibling();
        }
        return index;
    }

    int insertRowX(int index, AHtmlTableRow newRow) {
        ANode child = (ANode)this.getFirstChild();
        while (child != null) {
            if (child instanceof HTMLTableRowElement) {
                if (index == 0) {
                    this.insertBefore(newRow, child, false);
                    return -1;
                }
                --index;
            }
            child = (ANode)child.getNextSibling();
        }
        return index;
    }

    private BaseTableSection getDTBody() {
        return (BaseTableSection)this.getDNode();
    }
}

