/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlHelper;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.jsnative.HtmlForm;
import org.eclipse.vjet.dsf.jsnative.HtmlTextArea;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;

public class AHtmlTextArea
extends AHtmlElement
implements HtmlTextArea,
IDFormControl {
    private static final long serialVersionUID = 1L;
    private static final String SELECT_JS_METHOD = "select()";
    private static final String FOCUS_JS_METHOD = "focus()";

    protected AHtmlTextArea(AHtmlDocument doc, DTextArea ta) {
        super(doc, (BaseHtmlElement)ta);
        this.populateScriptable(AHtmlTextArea.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    @Override
    public void blur() {
        this.dispatchEvent(EventType.BLUR.getName(), this);
    }

    @Override
    public void focus() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod(this.getElement(), FOCUS_JS_METHOD);
        }
    }

    public String getAccessKey() {
        return this.getDTextArea().getHtmlAccessKey();
    }

    public int getCols() {
        return this.getDTextArea().getHtmlCols();
    }

    public String getDefaultValue() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            return browserBinding.getDomAttributeValue((BaseHtmlElement)this.getDTextArea(), EHtmlAttr.defaultValue);
        }
        return null;
    }

    public boolean getDisabled() {
        return AHtmlHelper.booleanValueOf(EHtmlAttr.disabled, this.getHtmlAttribute(EHtmlAttr.disabled));
    }

    public HtmlForm getForm() {
        return super.getFormInternal();
    }

    public String getName() {
        return this.getDTextArea().getHtmlName();
    }

    public boolean getReadOnly() {
        Boolean out = AHtmlHelper.booleanValueOf(EHtmlAttr.readOnly, this.getHtmlAttribute(EHtmlAttr.readOnly));
        if (!out.booleanValue()) {
            out = AHtmlHelper.booleanValueOf(EHtmlAttr.readonly, this.getHtmlAttribute(EHtmlAttr.readonly));
        }
        return out;
    }

    public int getRows() {
        return this.getDTextArea().getHtmlRows();
    }

    public int getTabIndex() {
        return this.getDTextArea().getHtmlTabIndex();
    }

    public String getType() {
        return this.getDTextArea().getHtmlType();
    }

    public String getValue() {
        return this.getDTextArea().getHtmlExtValue();
    }

    public void select() {
        IBrowserBinding browserBinding;
        AHtmlDocument doc = this.getOwnerDocument();
        if (doc != null && (browserBinding = doc.getBrowserBinding()) != null) {
            browserBinding.executeDomMethod(this.getElement(), SELECT_JS_METHOD);
        }
    }

    public void setAccessKey(String accessKey) {
        this.getDTextArea().setHtmlAccessKey(accessKey);
        this.onAttrChange(EHtmlAttr.accesskey, accessKey);
    }

    public void setCols(int cols) {
        this.getDTextArea().setHtmlCols(cols);
        this.onAttrChange(EHtmlAttr.cols, String.valueOf(cols));
    }

    public void setDefaultValue(String value) {
        this.getDTextArea().setAttribute((Enum)EHtmlAttr.defaultvalue, value);
    }

    public void setDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        this.onAttrChange(EHtmlAttr.disabled, disabled);
    }

    public void setName(String name) {
        this.getDTextArea().setHtmlName(name);
        this.onAttrChange(EHtmlAttr.name, name);
    }

    @Override
    public void setInnerHTML(String html) {
        this.setValue(html == null ? "" : html);
    }

    @Override
    public String getInnerHTML() {
        return this.getValue();
    }

    public void setReadOnly(boolean readOnly) {
        this.setHtmlAttribute(EHtmlAttr.readOnly, readOnly);
        this.onAttrChange(EHtmlAttr.readOnly, readOnly);
    }

    public void setRows(int rows) {
        this.getDTextArea().setHtmlRows(rows);
        this.onAttrChange(EHtmlAttr.rows, String.valueOf(rows));
    }

    public void setTabIndex(int tabIndex) {
        this.getDTextArea().setHtmlTabIndex(tabIndex);
        this.onAttrChange(EHtmlAttr.tabindex, String.valueOf(tabIndex));
    }

    public void setValue(String value) {
        this.getDTextArea().setHtmlExtValue(value);
        this.onElementChange();
    }

    public Object getOnblur() {
        return this.getOnBlur();
    }

    public Object getOnfocus() {
        return this.getOnFocus();
    }

    public void setOnblur(Object functionRef) {
        this.setOnBlur(functionRef);
    }

    public void setOnfocus(Object functionRef) {
        this.setOnFocus(functionRef);
    }

    public Object getOnkeydown() {
        return this.getOnKeyDown();
    }

    public void setOnkeydown(Object functionRef) {
        this.setOnKeyDown(functionRef);
    }

    public Object getOnkeypress() {
        return this.getOnKeyPress();
    }

    public void setOnkeypress(Object functionRef) {
        this.setOnKeyPress(functionRef);
    }

    public Object getOnkeyup() {
        return this.getOnKeyUp();
    }

    public void setOnkeyup(Object functionRef) {
        this.setOnKeyUp(functionRef);
    }

    public Object getOnresize() {
        return this.getOnResize();
    }

    public void setOnresize(Object functionRef) {
        this.setOnResize(functionRef);
    }

    public Object getOnchange() {
        return this.getOnChange();
    }

    public void setOnchange(Object functionRef) {
        this.setOnChange(functionRef);
    }

    public Object getOnselect() {
        return this.getOnSelect();
    }

    public void setOnselect(Object functionRef) {
        this.setOnSelect(functionRef);
    }

    public Object getOnclick() {
        return this.getOnClick();
    }

    public void setOnclick(Object functionRef) {
        this.setOnClick(functionRef);
    }

    public Object getOndblclick() {
        return this.getOnDblClick();
    }

    public void setOndblclick(Object functionRef) {
        this.setOnDblClick(functionRef);
    }

    public Object getOnmousedown() {
        return this.getOnMouseDown();
    }

    public void setOnmousedown(Object functionRef) {
        this.setOnMouseDown(functionRef);
    }

    public Object getOnmousemove() {
        return this.getOnMouseMove();
    }

    public void setOnmousemove(Object functionRef) {
        this.setOnMouseMove(functionRef);
    }

    public Object getOnmouseout() {
        return this.getOnMouseOut();
    }

    public void setOnmouseout(Object functionRef) {
        this.setOnMouseOut(functionRef);
    }

    public Object getOnmouseover() {
        return this.getOnMouseOver();
    }

    public void setOnmouseover(Object functionRef) {
        this.setOnMouseOver(functionRef);
    }

    public Object getOnmouseup() {
        return this.getOnMouseUp();
    }

    public void setOnmouseup(Object functionRef) {
        this.setOnMouseUp(functionRef);
    }

    private DTextArea getDTextArea() {
        return (DTextArea)this.getDNode();
    }

    private BaseHtmlElement getElement() {
        return (BaseHtmlElement)this.getDNode();
    }
}

