/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.dom.html;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.active.client.ActiveObject;
import org.eclipse.vjet.dsf.active.dom.html.AAttr;
import org.eclipse.vjet.dsf.active.dom.html.ADOMException;
import org.eclipse.vjet.dsf.active.dom.html.ADocument;
import org.eclipse.vjet.dsf.active.dom.html.ADocumentFragment;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlElement;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlFactory;
import org.eclipse.vjet.dsf.active.dom.html.ANodeList;
import org.eclipse.vjet.dsf.active.dom.html.AText;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DDocumentFragment;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.jsnative.Document;
import org.eclipse.vjet.dsf.jsnative.HtmlDocument;
import org.eclipse.vjet.dsf.jsnative.NamedNodeMap;
import org.eclipse.vjet.dsf.jsnative.NodeList;
import org.eclipse.vjet.dsf.jsnative.UserDataHandler;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.mozilla.mod.javascript.Scriptable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class ANode
extends ActiveObject
implements org.eclipse.vjet.dsf.jsnative.Node,
Cloneable {
    private static final long serialVersionUID = 1L;
    private DNode m_dNode;
    private ADocument m_ownerDocument;
    private ANode m_parentNode;
    protected ANodeList m_childNodes;
    protected transient Map<String, Object> m_userData;

    ANode(AHtmlDocument doc, DNode node) {
        this.m_dNode = node;
        this.m_ownerDocument = doc;
        this.populateScriptable(ANode.class, doc == null ? BrowserType.IE_6P : doc.getBrowserType());
    }

    public ANode(ADocument doc, DNode node) {
        this.m_dNode = node;
        this.m_ownerDocument = doc;
        this.populateScriptable(ANode.class, BrowserType.NONE);
    }

    public org.eclipse.vjet.dsf.jsnative.Node getParentNode() {
        return this.m_parentNode;
    }

    public org.eclipse.vjet.dsf.jsnative.Node appendChild(org.eclipse.vjet.dsf.jsnative.Node newChild) throws DOMException {
        try {
            this.appendChild((ANode)newChild, true);
            return newChild;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public org.eclipse.vjet.dsf.jsnative.Node add(org.eclipse.vjet.dsf.jsnative.Node newChild) throws DOMException {
        return this.appendChild(newChild);
    }

    public org.eclipse.vjet.dsf.jsnative.Node addt(String text) throws DOMException {
        DText dsfText = new DText(text);
        AText newChild = new AText(null, dsfText);
        this.appendChild(newChild);
        return newChild;
    }

    public NodeList getChildNodes() {
        if (this.m_childNodes == null) {
            this.m_childNodes = this.createChildNodes();
        }
        return this.m_childNodes;
    }

    public String getNodeName() {
        if (this.m_dNode.getNodeName() != null && this.m_dNode.getNodeType() == 1) {
            return this.m_dNode.getNodeName().toUpperCase();
        }
        if (this.m_dNode.getNodeType() == 9) {
            return "#document";
        }
        if (this.m_dNode.getNodeType() == 3) {
            return "#text";
        }
        if (this.m_dNode.getNodeType() == 8) {
            return "#comment";
        }
        if (this.m_dNode.getNodeType() == 11) {
            return "#document-fragment";
        }
        if (this.m_dNode.getNodeType() == 2) {
            return ((AAttr)this).getName();
        }
        return this.m_dNode.getNodeName();
    }

    public short getNodeType() {
        return this.m_dNode.getNodeType();
    }

    public String getNodeValue() throws DOMException {
        try {
            return this.m_dNode.getNodeValue();
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Object getUserData(String key) {
        if (this.m_userData == null) {
            return null;
        }
        return this.m_userData.get(key);
    }

    public boolean hasChildNodes() {
        return this.m_childNodes == null ? false : this.m_childNodes.size() > 0;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        try {
            this.m_dNode.setNodeValue(nodeValue);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.m_userData == null) {
            this.m_userData = new LinkedHashMap<String, Object>(3);
        }
        return this.m_userData.put(key, data);
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String toString() {
        return this.getNodeName();
    }

    public org.eclipse.vjet.dsf.jsnative.Node cloneNode() {
        return this.internalClone(false);
    }

    public org.eclipse.vjet.dsf.jsnative.Node cloneNode(boolean deep) {
        return this.internalClone(deep);
    }

    public org.eclipse.vjet.dsf.jsnative.Node getFirstChild() {
        if (this.m_childNodes == null) {
            return null;
        }
        if (this.m_childNodes.isEmpty()) {
            return null;
        }
        return this.m_childNodes.get(0);
    }

    public org.eclipse.vjet.dsf.jsnative.Node getLastChild() {
        if (this.m_childNodes == null) {
            return null;
        }
        if (this.m_childNodes.isEmpty()) {
            return null;
        }
        return this.m_childNodes.get(this.m_childNodes.getLength() - 1);
    }

    public org.eclipse.vjet.dsf.jsnative.Node getNextSibling() {
        if (this.m_parentNode == null) {
            return null;
        }
        if (this.m_parentNode.m_childNodes == null) {
            return null;
        }
        int index = this.m_parentNode.m_childNodes.indexOf(this);
        if (index < 0 || index + 1 >= this.m_parentNode.m_childNodes.size()) {
            return null;
        }
        ANode node = this.m_parentNode.m_childNodes.get(index + 1);
        return node;
    }

    public org.eclipse.vjet.dsf.jsnative.Node getPreviousSibling() {
        if (this.m_parentNode == null) {
            return null;
        }
        if (this.m_parentNode.m_childNodes == null) {
            return null;
        }
        int index = this.m_parentNode.m_childNodes.indexOf(this);
        if (index <= 0) {
            return null;
        }
        ANode node = this.m_parentNode.m_childNodes.get(index - 1);
        return node;
    }

    public org.eclipse.vjet.dsf.jsnative.Node insertBefore(org.eclipse.vjet.dsf.jsnative.Node newChild, org.eclipse.vjet.dsf.jsnative.Node refChild) throws DOMException {
        try {
            this.insertBefore((ANode)newChild, (ANode)refChild, true);
            return newChild;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public org.eclipse.vjet.dsf.jsnative.Node removeChild(org.eclipse.vjet.dsf.jsnative.Node oldChild) throws DOMException {
        try {
            this.removeChild((ANode)oldChild, true);
            return oldChild;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public org.eclipse.vjet.dsf.jsnative.Node replaceChild(org.eclipse.vjet.dsf.jsnative.Node newChild, org.eclipse.vjet.dsf.jsnative.Node oldChild) throws DOMException {
        try {
            this.replaceChildInternal((ANode)newChild, (ANode)oldChild);
            return oldChild;
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    public Document getOwnerDocument() {
        return this.m_ownerDocument;
    }

    public boolean hasAttributes() {
        return this.m_dNode.hasAttributes();
    }

    public Object valueOf(String type) {
        if (type.equals("boolean")) {
            return Boolean.TRUE;
        }
        if (type.equals("string")) {
            return this.getClass().getName();
        }
        return null;
    }

    public String getLocalName() {
        return this.m_dNode.getLocalName();
    }

    public String getNamespaceURI() {
        return this.m_dNode.getNamespaceURI();
    }

    public String getPrefix() {
        return this.m_dNode.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.m_dNode.setPrefix(prefix);
    }

    public Object getFeature(String feature, String version) {
        return this.m_dNode.getFeature(feature, version);
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return this.m_dNode.isDefaultNamespace(namespaceURI);
    }

    public boolean isEqualNode(org.eclipse.vjet.dsf.jsnative.Node node) {
        return this.m_dNode.isEqualNode((Node)((ANode)node).getDNode());
    }

    public boolean isSameNode(org.eclipse.vjet.dsf.jsnative.Node other) {
        return this.m_dNode.isSameNode((Node)((ANode)other).getDNode());
    }

    public String lookupNamespaceURI(String prefix) {
        return this.m_dNode.lookupNamespaceURI(prefix);
    }

    public String lookupPrefix(String namespaceURI) {
        return this.m_dNode.lookupPrefix(namespaceURI);
    }

    public short compareDocumentPosition(org.eclipse.vjet.dsf.jsnative.Node other) {
        return this.m_dNode.compareDocumentPosition((Node)((ANode)other).getDNode());
    }

    public String getBaseURI() {
        return this.m_dNode.getBaseURI();
    }

    public void setTextContent(String textContent) {
        if (textContent == null) {
            return;
        }
        if (this.m_childNodes != null) {
            this.m_childNodes.clear();
        }
        if (textContent.length() == 0) {
            return;
        }
        DText text = new DText(textContent);
        this.m_dNode.add((DNode)text);
        this.appendChild(new AText((AHtmlDocument)this.m_ownerDocument, text));
    }

    public boolean isSupported(String feature, String version) {
        return this.m_dNode.isSupported(feature, version);
    }

    public void normalize() {
        this.m_dNode.normalize();
    }

    public String getInnerText() {
        return this.getTextContent();
    }

    public void setInnerText(String innerText) {
        this.setTextContent(innerText);
    }

    public Object getDefaultValue(Class typeHint) {
        if (typeHint == null) {
            return "Node";
        }
        return ActiveObject.getDefaultValue((Scriptable)this, (Class)typeHint);
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.internalClone(true);
    }

    ANode internalClone(boolean deep) {
        ANode copy = null;
        DNode copyDnode = (DNode)this.m_dNode.cloneNode(false);
        if (this instanceof AHtmlElement) {
            copy = (ANode)AHtmlFactory.createElement(this.getNodeName().toLowerCase(), (HtmlDocument)this.m_ownerDocument, copyDnode);
        } else if (this instanceof AHtmlDocument) {
            copy = new AHtmlDocument((DHtmlDocument)copyDnode, ((AHtmlDocument)this).getBrowserType());
        } else if (this instanceof AAttr) {
            copy = new AAttr((AHtmlDocument)this.m_ownerDocument, (DAttr)copyDnode);
        } else if (this instanceof AText) {
            copy = new AText((AHtmlDocument)this.m_ownerDocument, (DText)copyDnode);
        } else if (this instanceof ADocumentFragment) {
            copy = new ADocumentFragment((AHtmlDocument)this.m_ownerDocument, (DDocumentFragment)copyDnode);
        } else {
            return null;
        }
        copy.m_ownerDocument = this.m_ownerDocument;
        copy.m_parentNode = null;
        if (deep) {
            if (this.m_childNodes != null) {
                copy.m_childNodes = this.createChildNodes();
                for (ANode kid : this.m_childNodes) {
                    ANode kidCopy = (ANode)kid.cloneNode(deep);
                    copy.appendChild(kidCopy);
                }
            }
        } else {
            copy.m_childNodes = null;
        }
        return copy;
    }

    void removeChild(ANode oldChild, boolean deep) throws DOMException {
        if (oldChild == null) {
            throw new ADOMException(new DOMException(8, "null node is not a child of this node"));
        }
        if (oldChild.m_parentNode != this) {
            throw new ADOMException(new DOMException(8, "node is not a child of this node"));
        }
        if (deep) {
            this.m_dNode.removeChild((Node)oldChild.getDNode());
        }
        this.getChildNodes();
        this.m_childNodes.remove(oldChild);
        oldChild.m_parentNode = null;
        if (this.m_ownerDocument != null) {
            this.m_ownerDocument.removeIdentifiedElement(oldChild);
        }
    }

    DNode getDNode() {
        return this.m_dNode;
    }

    void setOwnerDocument(ADocument doc) {
        if (this.m_ownerDocument == doc) {
            return;
        }
        if (this.m_ownerDocument != null) {
            this.m_ownerDocument.removeIdentifiedElement(this);
        }
        this.m_ownerDocument = doc;
        if (this.m_childNodes != null) {
            int i = 0;
            while (i < this.m_childNodes.getLength()) {
                ((ANode)this.m_childNodes.item(i)).setOwnerDocument(doc);
                ++i;
            }
        }
    }

    void removeAllChildren() {
        if (this.m_childNodes == null) {
            return;
        }
        int i = this.m_childNodes.getLength() - 1;
        while (i >= 0) {
            this.removeChild(this.m_childNodes.item(i));
            --i;
        }
    }

    void postChildAdd(ANode child) {
        child.m_parentNode = this;
        if (child.m_ownerDocument == null) {
            child.m_ownerDocument = this.m_ownerDocument;
        } else if (child.m_ownerDocument != this && child.m_ownerDocument != this.m_ownerDocument) {
            throw new ADOMException(new DOMException(4, "node belongs to a different document"));
        }
    }

    void appendChild(ANode newChild, boolean deep) throws DOMException {
        if (newChild == null) {
            throw new ADOMException(new DOMException(16, "Child is null"));
        }
        try {
            this.eraseParent(newChild, (ANode)newChild.getParentNode());
            if (deep) {
                this.m_dNode.appendChild((Node)newChild.getDNode());
            }
            ((ANodeList)this.getChildNodes()).add(newChild);
            this.postChildAdd(newChild);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    void insertBefore(ANode newChild, ANode refChild, boolean deep) throws DOMException {
        if (newChild == null) {
            throw new ADOMException(new DOMException(16, "Child is null"));
        }
        try {
            if (deep) {
                this.m_dNode.insertBefore((Node)newChild.getDNode(), (Node)(refChild == null ? null : refChild.getDNode()));
            }
            this.insertBeforeInternal(newChild, refChild);
        }
        catch (DOMException e) {
            throw new ADOMException(e);
        }
    }

    private void eraseParent(ANode child, ANode parent) {
        if (parent == null) {
            return;
        }
        parent.removeChild(child);
    }

    private ANodeList createChildNodes() {
        return new ANodeList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertBeforeInternal(ANode newChild, ANode refChild) throws DOMException {
        if (refChild == null) {
            this.appendChild(newChild);
        }
        if (newChild == refChild) {
            return;
        }
        if (newChild.getParentNode() == this) {
            int alreadyInIndex;
            int n = alreadyInIndex = this.m_childNodes == null ? -1 : this.m_childNodes.indexOf(newChild);
            if (alreadyInIndex < 0) throw new ADOMException(new DOMException(16, "child has this parent, but cannot find it as a child"));
            this.m_childNodes.remove(alreadyInIndex);
        } else if (newChild.getParentNode() != null) {
            newChild.getParentNode().removeChild((org.eclipse.vjet.dsf.jsnative.Node)newChild);
        }
        this.getChildNodes();
        if (refChild == null) {
            this.m_childNodes.add(newChild);
        } else {
            int index = this.m_childNodes.indexOf(refChild);
            if (index < 0) {
                throw new ADOMException(new DOMException(8, "rerence node not found"));
            }
            this.m_childNodes.add(index, newChild);
        }
        this.postChildAdd(newChild);
    }

    private void replaceChildInternal(ANode newChild, ANode oldChild) throws DOMException {
        int index;
        if (newChild == null) {
            throw new ADOMException(new DOMException(16, "new child cannot be null"));
        }
        int n = index = this.m_childNodes == null ? -1 : this.m_childNodes.indexOf(oldChild);
        if (index < 0) {
            throw new ADOMException(new DOMException(8, "reference node not found"));
        }
        this.removeChild(oldChild);
        this.getChildNodes();
        if (index >= this.m_childNodes.size()) {
            this.appendChild(newChild);
        } else {
            this.insertBefore(newChild, this.m_childNodes.get(index));
        }
    }
}

