/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.active.util;

import java.io.PrintStream;
import org.eclipse.vjet.dsf.dap.rt.BaseScriptable;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.NativeJavaObject;
import org.mozilla.mod.javascript.NativeObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.StackInspector;
import org.mozilla.mod.javascript.Undefined;

public class DapDebugConsole
extends BaseScriptable {
    private static final long serialVersionUID = 1L;
    private static final String[] MTD_NAMES = new String[]{"print", "println", "printStackTrace"};
    private static final String DEBUG_INSTANCE = "dap";
    private static final String DEBUG_SYSOUT_PROP = "sysout";
    private static final String DEBUG_SYSERR_PROP = "syserr";
    private final PrintStream m_ps;

    public static void enable(Context cx, Scriptable scope) {
        DapDebugConsole out = new DapDebugConsole(false);
        Object scriptOut = Context.javaToJS((Object)((Object)out), (Scriptable)scope);
        Object debug = ScriptableObject.getProperty((Scriptable)scope, (String)DEBUG_INSTANCE);
        if (debug == Scriptable.NOT_FOUND) {
            NativeObject dbg = new NativeObject();
            debug = Context.javaToJS((Object)dbg, (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)DEBUG_INSTANCE, (Object)debug);
        }
        ScriptableObject.putProperty((Scriptable)((Scriptable)debug), (String)DEBUG_SYSOUT_PROP, (Object)scriptOut);
        DapDebugConsole err = new DapDebugConsole(true);
        Object scriptErr = Context.javaToJS((Object)((Object)err), (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)((Scriptable)debug), (String)DEBUG_SYSERR_PROP, (Object)scriptErr);
    }

    public DapDebugConsole(boolean err) {
        this.m_ps = err ? System.err : System.out;
        this.defineFunctionProperties(MTD_NAMES);
    }

    public void print(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        this.internalPrint(o0, o1, o2, o3, o4, o5, o6, o7, o8, o9);
    }

    public void println(Object o0, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        this.internalPrint(o0, o1, o2, o3, o4, o5, o6, o7, o8, o9);
        this.m_ps.println();
    }

    public void printStackTrace() {
        for (StackInspector.StackInfo stack : StackInspector.getStack()) {
            this.m_ps.println(stack.toString());
        }
    }

    private void internalPrint(Object ... args) {
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != null && !(o instanceof Undefined)) {
                this.m_ps.print(this.toStringValue(o));
            }
            ++n2;
        }
    }

    private String toStringValue(Object o) {
        if (o instanceof NativeJavaObject) {
            o = ((NativeJavaObject)o).unwrap();
        } else if (o instanceof ScriptableObject) {
            o = ((ScriptableObject)o).getDefaultValue(null);
        }
        return o.toString();
    }
}

