/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureData;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureXmlSerializer;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;

public class DapConsoleCaptureDumpHandler
implements IDapConsoleHandler {
    public static final String DUMP_CAPTURE = "DUMP_CAPTURE";
    private static final String[] INPUTS = new String[]{"DUMP_CAPTURE"};
    private static DapConsoleCaptureDumpHandler s_instance = new DapConsoleCaptureDumpHandler();

    private DapConsoleCaptureDumpHandler() {
    }

    public static DapConsoleCaptureDumpHandler getInstance() {
        return s_instance;
    }

    @Override
    public String[] getSupportedInputs() {
        return INPUTS;
    }

    @Override
    public void handle(String input) {
        if (DUMP_CAPTURE.equalsIgnoreCase(input)) {
            this.dumpEventCapture();
        }
    }

    public void dumpEventCapture() {
        DapCaptureData capturedData = DapCtx.ctx().getSession().getCaptureReplay().getCapturedData();
        if (capturedData == null) {
            System.err.println("capture is not enabled");
            return;
        }
        new DapCaptureXmlSerializer((IIndenter)new IIndenter.Pretty()).serialize(capturedData, System.out);
    }
}

