/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import org.eclipse.vjet.dsf.dap.cnr.ReplaySpeed;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapSession;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;

public class DapConsoleReplayHandler
implements IDapConsoleHandler {
    public static final String REPLAY = "REPLAY";
    public static final String FAST_REPLAY = "FAST_REPLAY";
    public static final String SLOW_REPLAY = "SLOW_REPLAY";
    private static final String[] INPUTS = new String[]{"REPLAY", "FAST_REPLAY", "SLOW_REPLAY"};
    private static DapConsoleReplayHandler s_instance = new DapConsoleReplayHandler();

    private DapConsoleReplayHandler() {
    }

    public static DapConsoleReplayHandler getInstance() {
        return s_instance;
    }

    @Override
    public String[] getSupportedInputs() {
        return INPUTS;
    }

    @Override
    public void handle(String input) {
        String cmd = input.toUpperCase();
        if (cmd.startsWith(REPLAY)) {
            this.replay(ReplaySpeed.NORMAL);
        } else if (cmd.startsWith(FAST_REPLAY)) {
            this.replay(ReplaySpeed.FAST);
        } else if (cmd.startsWith(SLOW_REPLAY)) {
            this.replay(ReplaySpeed.SLOW);
        }
    }

    private void replay(ReplaySpeed speed) {
        DapSession session = DapCtx.ctx().getSession();
        if (session != null) {
            session.startReplay();
            session.getCaptureReplay().replayCapture(speed);
        } else {
            System.out.println("There is no active session");
        }
    }
}

