/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.dap.cnr.DapCaptureXmlSerializer;
import org.eclipse.vjet.dsf.dap.cnr.DapConsoleCaptureDumpHandler;
import org.eclipse.vjet.dsf.dap.cnr.DapConsoleReplayHandler;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureListener;
import org.eclipse.vjet.dsf.dap.cnr.IDapCaptureSerializer;
import org.eclipse.vjet.dsf.dap.rt.DLCMsgHandlerRegistry;
import org.eclipse.vjet.dsf.dap.rt.DapConsoleCaptureHandler;
import org.eclipse.vjet.dsf.dap.rt.DapHttpClient;
import org.eclipse.vjet.dsf.dap.rt.DapInfoCollector;
import org.eclipse.vjet.dsf.dap.rt.DapTaskMsgHandler;
import org.eclipse.vjet.dsf.dap.rt.IDLCMsgHandler;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleHandler;
import org.eclipse.vjet.dsf.dap.rt.IDapConsoleProxy;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;
import org.eclipse.vjet.dsf.liveconnect.client.DLCJsAggregator;
import org.eclipse.vjet.dsf.liveconnect.client.DLCResourceHolder;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCClient;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCJsProvider;
import org.eclipse.vjet.dsf.liveconnect.client.IDLCResourceProvider;
import org.eclipse.vjet.dsf.liveconnect.client.simple.SimpleDLCClient;

public class DapConfig {
    private boolean m_enableCaptureReplay = false;
    private boolean m_enableConsoleLog = false;
    private int m_port = 8181;
    private IDLCClient m_dlcClient;
    private IDapHttpClient m_httpClient;
    private DLCJsAggregator m_jsAggr = new DLCJsAggregator();
    private DLCResourceHolder m_resourceHolder = new DLCResourceHolder();
    private DLCMsgHandlerRegistry m_handlerRegistry = new DLCMsgHandlerRegistry();
    private DapInfoCollector m_infoCollector;
    private IDapCaptureSerializer m_dapCaptureSerializer;
    private List<IDapConsoleHandler> m_consoleHandles = new ArrayList<IDapConsoleHandler>();
    private List<IDapCaptureListener> m_listeners;
    private Map<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubSerializer>> m_serRegistry = new HashMap<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubSerializer>>();
    private Map<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubHandler>> m_deserRegistry = new HashMap<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubHandler>>();
    private Map<String, IDapConsoleProxy> m_dapConsoleProxies = new ConcurrentHashMap<String, IDapConsoleProxy>();

    public DapConfig() {
        this.addDlcMsgHandler(new DapTaskMsgHandler());
        this.enableCaptureReplay(true);
        this.enableConsoleLog(true);
    }

    @Deprecated
    public int getPort() {
        return this.m_port;
    }

    @Deprecated
    public void setPort(int port) {
        this.m_port = port;
    }

    public boolean isCaptureReplayEnabled() {
        return this.m_enableCaptureReplay;
    }

    public void enableCaptureReplay(boolean enableCaptureReplay) {
        this.m_enableCaptureReplay = enableCaptureReplay;
        if (enableCaptureReplay) {
            this.addConsoleHandler(DapConsoleReplayHandler.getInstance());
            this.addConsoleHandler(DapConsoleCaptureDumpHandler.getInstance());
            this.addConsoleHandler(DapConsoleCaptureHandler.getInstance());
        } else {
            this.removeConsoleHandler(DapConsoleReplayHandler.getInstance());
            this.removeConsoleHandler(DapConsoleCaptureDumpHandler.getInstance());
        }
    }

    public boolean isConsoleLogEnable() {
        return this.m_enableConsoleLog;
    }

    public void enableConsoleLog(boolean enableConsoleLog) {
        this.m_enableConsoleLog = enableConsoleLog;
    }

    public IDLCClient getDlcClient() {
        if (this.m_dlcClient == null) {
            this.m_dlcClient = SimpleDLCClient.getInstance();
        }
        return this.m_dlcClient;
    }

    public void setDlcClient(IDLCClient dlcClient) {
        this.m_dlcClient = dlcClient;
    }

    public IDapHttpClient getHttpClient() {
        if (this.m_httpClient == null) {
            this.m_httpClient = new DapHttpClient();
        }
        return this.m_httpClient;
    }

    public void setHttpClient(IDapHttpClient httpClient) {
        this.m_httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DapConfig addConsoleHandler(IDapConsoleHandler handler) {
        if (handler == null) {
            return this;
        }
        DapConfig dapConfig = this;
        synchronized (dapConfig) {
            if (!this.m_consoleHandles.contains(handler)) {
                this.m_consoleHandles.add(handler);
            }
        }
        return this;
    }

    public synchronized void removeConsoleHandler(IDapConsoleHandler handler) {
        this.m_consoleHandles.remove(handler);
    }

    public List<? extends IDapConsoleHandler> getConsoleHandlers() {
        return this.m_consoleHandles;
    }

    public void setInfoCollector(DapInfoCollector infoCollector) {
        this.m_infoCollector = infoCollector;
    }

    public DapInfoCollector getInfoCollector() {
        if (!this.m_enableConsoleLog) {
            return null;
        }
        if (this.m_infoCollector == null) {
            this.m_infoCollector = new DapInfoCollector(null);
        }
        return this.m_infoCollector;
    }

    public final IDapCaptureSerializer getDapCaptureSerializer() {
        if (this.m_dapCaptureSerializer == null) {
            this.m_dapCaptureSerializer = new DapCaptureXmlSerializer();
        }
        return this.m_dapCaptureSerializer;
    }

    public void setDapCaptureSerializer(IDapCaptureSerializer dapCaptureSerializer) {
        this.m_dapCaptureSerializer = dapCaptureSerializer;
    }

    public final List<IDapCaptureListener> getCaptureListeners() {
        if (this.m_listeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_listeners);
    }

    public DapConfig addCaptureListener(IDapCaptureListener listener) {
        if (listener == null) {
            return this;
        }
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<IDapCaptureListener>();
        }
        this.m_listeners.add(listener);
        return this;
    }

    public void addDlcMsgHandler(IDLCMsgHandler handler) {
        this.m_handlerRegistry.add(handler);
    }

    public DLCMsgHandlerRegistry getDlcMsgHandlerRegistry() {
        return this.m_handlerRegistry;
    }

    public void addJsProvider(IDLCJsProvider provider) {
        this.m_jsAggr.addProvider(provider);
    }

    public DLCJsAggregator getJsAggregator() {
        return this.m_jsAggr;
    }

    public void addResourceProvider(IDLCResourceProvider provider) {
        this.m_resourceHolder.addProvider(provider);
    }

    public DLCResourceHolder getResourceHolder() {
        return this.m_resourceHolder;
    }

    public Map<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubSerializer>> getDapCaptureDataSerializerRegistry() {
        return this.m_serRegistry;
    }

    public Map<String, Class<? extends DapCaptureXmlSerializer.DapCaptureDataSubHandler>> getDapCaptureDataDeserializerRegistry() {
        return this.m_deserRegistry;
    }

    public void addDapConsoleProxy(String id, IDapConsoleProxy proxy) {
        if (proxy != null) {
            this.m_dapConsoleProxies.put(id, proxy);
        }
    }

    public void addDapConsoleProxy(IDapConsoleProxy proxy) {
        if (proxy != null) {
            this.addDapConsoleProxy(proxy.getClass().getSimpleName(), proxy);
        }
    }

    public Collection<IDapConsoleProxy> getDapConsoleProxies() {
        return this.m_dapConsoleProxies.values();
    }

    public IDapConsoleProxy findDapConsoleProxy(String id) {
        return this.m_dapConsoleProxies.get(id);
    }
}

