/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.util.List;
import org.eclipse.vjet.dsf.active.client.AHtmlParser;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.client.BrowserSupport;
import org.eclipse.vjet.dsf.active.client.WindowFactory;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlDocument;
import org.eclipse.vjet.dsf.active.dom.html.AHtmlInternal;
import org.eclipse.vjet.dsf.active.dom.html.ANode;
import org.eclipse.vjet.dsf.active.event.IBrowserBinding;
import org.eclipse.vjet.dsf.active.event.IDomChangeListener;
import org.eclipse.vjet.dsf.active.event.IDomEventBindingListener;
import org.eclipse.vjet.dsf.active.event.IDomEventPublisher;
import org.eclipse.vjet.dsf.active.util.WindowTask;
import org.eclipse.vjet.dsf.active.util.WindowTaskManager;
import org.eclipse.vjet.dsf.dap.api.util.DapEventHelper;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHost;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DInput;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;
import org.mozilla.mod.javascript.Scriptable;

public final class DapWindowManager {
    private AWindow m_window;
    private WindowTaskManager m_taskMgr;

    DapWindowManager(String html, List<IDomChangeListener> domChangelisteners, IDomEventPublisher domEventPublisher, IDomEventBindingListener domEventBindingListener, IBrowserBinding browserBinding) {
        ActiveJsExecutionControlCtx.ctx().setExecuteJavaScript(true);
        ActiveJsExecutionControlCtx.ctx().setParseGeneratedContent(true);
        BrowserType browserType = BrowserType.IE_6P;
        if (browserBinding != null) {
            String userAgent = browserBinding.getNavigatorProperty("userAgent");
            browserType = BrowserSupport.getType(userAgent);
            DapCtx.ctx().getDapConfig().getInfoCollector().log("******* " + userAgent);
        }
        this.m_taskMgr = new WindowTaskManager();
        this.m_window = (AWindow)WindowFactory.createWindow(browserType, this.m_taskMgr);
        this.m_window.setBrowserBinding(browserBinding);
        DapHost dapHost = new DapHost((Scriptable)this.m_window);
        dapHost.initialize();
        DapCtx.ctx().setDapHost(dapHost);
        AHtmlDocument doc = (AHtmlDocument)this.m_window.getDocument();
        doc.setEventDispatcher(domEventPublisher);
        doc.setDomEventBindingListener(domEventBindingListener);
        if (domChangelisteners != null) {
            for (IDomChangeListener domChangelistener : domChangelisteners) {
                this.m_window.addDomListener(domChangelistener, false);
            }
        }
        AHtmlParser.parse(html, null, this.m_window);
        this.m_window.enableDomChangeListener(true);
    }

    void updateWindow(String msg) {
        int index1 = msg.indexOf("(");
        int index2 = msg.indexOf(",", index1);
        int index3 = msg.indexOf(")", index2);
        String width = msg.substring(index1 + 1, index2);
        String height = msg.substring(index2 + 1, index3);
        this.m_window.getScreen().setWidth(Integer.parseInt(width));
        this.m_window.getScreen().setHeight(Integer.parseInt(height));
    }

    void updateDDom(DapEvent event, DLCEvent dlcEvent) {
        if (event == null || dlcEvent.getValue() == null) {
            return;
        }
        String value = dlcEvent.getValue();
        ANode aSrc = (ANode)DapEventHelper.getInstance().getSrcNode(event);
        DNode src = ADomHelper.getDNode(aSrc);
        if (src == null) {
            return;
        }
        String eventId = event.getType();
        if (EventType.CHANGE.getName().equals(eventId)) {
            if (src instanceof DInput) {
                this.updateElement((DInput)src, value);
            } else if (src instanceof DTextArea) {
                this.updateElement((DTextArea)src, value);
            } else if (src instanceof DSelect) {
                this.updateElement((DSelect)src, value);
            }
        } else if (EventType.CLICK.getName().equals(eventId)) {
            if (src instanceof DInput) {
                this.updateElement((DInput)src, value);
            }
        } else if (EventType.KEYUP.getName().equals(eventId)) {
            if (src instanceof DInput) {
                this.updateElement((DInput)src, value);
            } else if (src instanceof DTextArea) {
                this.updateElement((DTextArea)src, value);
            }
        }
    }

    AWindow getWindow() {
        return this.m_window;
    }

    DHtmlDocument getDHtmlDocument() {
        return ADomHelper.getDHtmlDocument(this.getDocument());
    }

    AHtmlDocument getDocument() {
        return (AHtmlDocument)(this.m_window == null ? null : this.m_window.getDocument());
    }

    void close() {
        this.m_window.finialize();
    }

    private void updateElement(DInput input, String value) {
        if (input.getHtmlType().equalsIgnoreCase("radio") || input.getHtmlType().equalsIgnoreCase("checkbox")) {
            input.setHtmlChecked(Boolean.valueOf(value).booleanValue());
        }
        input.setHtmlValue(value);
    }

    private void updateElement(DTextArea textArea, String value) {
        textArea.setHtmlExtValue(value);
    }

    private void updateElement(DSelect select, String value) {
        if (!select.getHtmlMultiple()) {
            select.setHtmlSelectedIndex(value);
        } else {
            DHtmlCollection options = select.getHtmlOptions();
            String[] idxs = value.split(",");
            int i = 0;
            while (i < options.getLength()) {
                ((DOption)options.item(i)).setHtmlSelected(false);
                ++i;
            }
            int j = 0;
            while (j < idxs.length) {
                int idx = Integer.parseInt(idxs[j]);
                ((DOption)options.item(idx)).setHtmlSelected(true);
                ++j;
            }
        }
    }

    public void executeTask(int id) {
        WindowTask task = this.m_taskMgr.getTask(id);
        if (task != null) {
            task.execute();
        }
    }

    private static class ADomHelper
    extends AHtmlInternal {
        private ADomHelper() {
        }

        private static DHtmlDocument getDHtmlDocument(AHtmlDocument adoc) {
            return AHtmlInternal.getInternalDocument(adoc);
        }

        private static DNode getDNode(ANode aNode) {
            return ADomHelper.getInternalNode(aNode);
        }
    }
}

