/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.Vector;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.js.JSForm;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.w3c.dom.NodeList;

public class JSFormsArray
extends ScriptableObject {
    private JSWindow window = null;
    private Context cx = null;
    private Scriptable scope = null;
    private Vector forms = new Vector();
    private JSForm defaultForm = null;

    private JSFormsArray() {
    }

    public JSFormsArray(JSWindow window) {
        this.window = window;
        this.cx = window.getContext();
        this.scope = window.getScope();
    }

    public String getClassName() {
        return "JSFormsArray";
    }

    public boolean has(String name, Scriptable start) {
        if (name.equals("length")) {
            return true;
        }
        DHtmlCollection forms = this.window.getHTMLDocument().getForms();
        if (forms == null) {
            return false;
        }
        DForm form = null;
        int i = 0;
        while (i < forms.getLength()) {
            form = (DForm)forms.item(i);
            if (name.equals(form.getHtmlName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean has(int index, Scriptable start) {
        DHtmlCollection forms = this.window.getHTMLDocument().getForms();
        if (forms == null) {
            return false;
        }
        return index >= 0 && index < forms.getLength();
    }

    public Object get(String name, Scriptable start) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            DHtmlCollection forms = this.window.getHTMLDocument().getForms();
            if (name.equals("length")) {
                if (forms != null) {
                    return new Integer(forms.getLength());
                }
                return new Integer(0);
            }
            if (forms == null) {
                return Scriptable.NOT_FOUND;
            }
            DForm form = null;
            int i = 0;
            while (i < forms.getLength()) {
                form = (DForm)forms.item(i);
                if (name.equals(form.getHtmlName())) {
                    return new JSForm(this.window, form);
                }
                ++i;
            }
        } else {
            int numForms = this.forms.size();
            int i = 0;
            while (i < numForms) {
                JSForm form = (JSForm)((Object)this.forms.get(i));
                if (form.name.equals(name)) {
                    return Context.toObject((Object)((Object)form), (Scriptable)this.scope);
                }
                ++i;
            }
        }
        return Scriptable.NOT_FOUND;
    }

    public Object get(int index, Scriptable start) {
        if (this.window.windowState == JSWindow.IN_LOADING) {
            DHtmlCollection forms = this.window.getHTMLDocument().getForms();
            if (forms == null || index < 0 || index >= forms.getLength()) {
                return Scriptable.NOT_FOUND;
            }
            return new JSForm(this.window, (DForm)forms.item(index));
        }
        if (this.forms == null || index < 0 || index >= this.forms.size()) {
            return Scriptable.NOT_FOUND;
        }
        return Context.toObject(this.forms.get(index), (Scriptable)this.scope);
    }

    public void updateForms() {
        DHtmlCollection domForms = this.window.getHTMLDocument().getForms();
        int numForms = 0;
        if (domForms == null || (numForms = domForms.getLength()) == 0) {
            return;
        }
        this.forms.removeAllElements();
        int i = 0;
        while (i < numForms) {
            this.forms.add(new JSForm(this.window, (DForm)domForms.item(i)));
            ++i;
        }
    }

    public void addJSForm(DElement formElem) {
        this.forms.add(new JSForm(this.window, (DForm)formElem));
    }

    public void addDefaultJSForm(String formId) {
        this.defaultForm = new JSForm(this.window, formId);
    }

    public void addJSFormChildElem(DElement formChildElem) {
        String formId = formChildElem.getAttribute("form-id");
        JSForm form = this.getFormById(formId);
        if (form != null) {
            form.addJSFormChildElem(formChildElem);
        }
    }

    public JSForm getFormById(String formId) {
        int numForms = this.forms.size();
        int i = 0;
        while (i < numForms) {
            JSForm form = (JSForm)((Object)this.forms.get(i));
            if (form.formId != null && form.formId.equals(formId)) {
                return form;
            }
            ++i;
        }
        if (this.defaultForm != null && this.defaultForm.formId.equals(formId)) {
            return this.defaultForm;
        }
        return null;
    }

    public int numForms() {
        return this.forms.size();
    }

    public JSForm getForm(int index) {
        return (JSForm)((Object)this.forms.get(index));
    }

    public Object getForm(String name) {
        int numForms = this.forms.size();
        int i = 0;
        while (i < numForms) {
            JSForm form = (JSForm)((Object)this.forms.get(i));
            if (form.name.equals(name)) {
                return form;
            }
            ++i;
        }
        if (this.window.windowState == JSWindow.IN_LOADING) {
            NodeList domForms = this.window.getHTMLDocument().getElementsByTagName(HtmlTypeEnum.FORM);
            numForms = domForms.getLength();
            int i2 = 0;
            while (i2 < numForms) {
                DForm domForm = (DForm)domForms.item(i2);
                if (domForm.getHtmlName().equals(name)) {
                    return new JSForm(this.window, domForm);
                }
                ++i2;
            }
        }
        return null;
    }
}

