/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.js;

import java.util.ArrayList;
import org.eclipse.vjet.dsf.html.js.JSWindow;
import org.eclipse.vjet.dsf.html.js.URLUtil;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class JSFrames
extends ScriptableObject {
    private JSWindow self = null;
    private Context cx = null;
    private Scriptable scope = null;
    private ArrayList frames = new ArrayList();
    private ArrayList hiddenWindows = null;

    private JSFrames() {
    }

    public JSFrames(JSWindow window) {
        this.self = window;
        this.cx = window.getContext();
        this.scope = window.getScope();
        this.defineProperty("self", JSFrames.class, 2);
        this.defineProperty("top", JSFrames.class, 2);
    }

    public String getClassName() {
        return "JSFrames";
    }

    public boolean has(String name, Scriptable start) {
        if (name.equals("length")) {
            return true;
        }
        int size = this.frames.size();
        int i = 0;
        while (i < size) {
            JSWindow window = (JSWindow)((Object)this.frames.get(i));
            if (window.getName().equals("name")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.frames.size();
    }

    public Object get(String name, Scriptable start) {
        Object obj = super.get(name, start);
        if (obj != NOT_FOUND) {
            return obj;
        }
        if (name.equals("length")) {
            return new Integer(this.frames.size());
        }
        int size = this.frames.size();
        int i = 0;
        while (i < size) {
            JSWindow window = (JSWindow)((Object)this.frames.get(i));
            if (window.getName().equals(name)) {
                return window;
            }
            ++i;
        }
        return this.getHiddenWindow(name, true);
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || index >= this.frames.size()) {
            return Scriptable.NOT_FOUND;
        }
        return (JSWindow)((Object)this.frames.get(index));
    }

    public Object getSelf() {
        return this.self;
    }

    public void setSelf(Object self) {
        if (self instanceof JSWindow) {
            this.self = (JSWindow)((Object)self);
        }
    }

    public Object getTop() {
        return this.self;
    }

    public void setTop(Object top) {
        if (this.self instanceof JSWindow) {
            this.self = (JSWindow)((Object)top);
        }
    }

    public void addChildWindow(JSWindow window) {
        this.frames.add(window);
    }

    public void removeChildWindow(JSWindow window) {
        this.frames.remove((Object)window);
    }

    public int size() {
        return this.frames.size();
    }

    public JSWindow at(int index) {
        return (JSWindow)((Object)this.frames.get(index));
    }

    public JSWindow getHiddenWindow(String name, boolean create) {
        if (this.hiddenWindows == null) {
            if (create) {
                this.hiddenWindows = new ArrayList();
            } else {
                return null;
            }
        }
        int i = 0;
        while (i < this.hiddenWindows.size()) {
            JSWindow hiddenWindow = (JSWindow)((Object)this.hiddenWindows.get(i));
            if (name.equals(hiddenWindow.getName().toString())) {
                return hiddenWindow;
            }
            ++i;
        }
        if (create) {
            JSWindow hiddenWindow = new JSWindow();
            try {
                hiddenWindow.init(this.self, this.cx, this.scope);
            }
            catch (Exception exception) {}
            hiddenWindow.setName(name);
            this.hiddenWindows.add(hiddenWindow);
            return hiddenWindow;
        }
        return null;
    }

    public JSWindow getHiddenWindow() {
        if (this.hiddenWindows == null || this.hiddenWindows.size() != 1) {
            return null;
        }
        return (JSWindow)((Object)this.hiddenWindows.get(0));
    }

    public int numHiddenWindow() {
        return this.hiddenWindows == null ? 0 : this.hiddenWindows.size();
    }

    public void fixHiddenWindowHref(String urlBase, int startIndex) {
        if (this.hiddenWindows == null) {
            return;
        }
        int i = startIndex;
        while (i < this.hiddenWindows.size()) {
            JSWindow hiddenWindow = (JSWindow)((Object)this.hiddenWindows.get(i));
            String href = hiddenWindow.getJSLocation().getReplacement();
            if (href != null && href.length() > 0) {
                href = URLUtil.getAbsoluteURL(href, urlBase);
                hiddenWindow.getJSLocation().replace(href);
            }
            ++i;
        }
    }
}

