/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.coverage;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.vjet.dsf.common.FileUtils;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.service.serializer.JsonSerializer;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.coverage.JsCoverageType;

public class JsCoverageBean {
    public static HashMap<String, JsCoverageType> types = new HashMap();

    public HashMap<String, JsCoverageType> getTypes() {
        return types;
    }

    public Collection<JsCoverageType> getTypesValues() {
        return types.values();
    }

    public JsCoverageType getType(String name) {
        return types.get(name);
    }

    public boolean addType(String name) {
        JsCoverageType type = new JsCoverageType(name);
        if (types.containsKey(name)) {
            return false;
        }
        types.put(name, type);
        return true;
    }

    public boolean addType(JsCoverageType type) {
        if (types.containsKey(type.getTypeName())) {
            return false;
        }
        types.put(type.getTypeName(), type);
        return true;
    }

    public Set getTypeNames() {
        return types.keySet();
    }

    public void setTypes(HashMap<String, JsCoverageType> coverage) {
        types = coverage;
    }

    public int getTypesCount() {
        return types.size();
    }

    public int getCoveredTypesCount() {
        int count = 0;
        for (JsCoverageType type : types.values()) {
            if (!type.hasCoverage()) continue;
            ++count;
        }
        return count;
    }

    public void jsCoverageReport() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        String str = "";
        boolean altTblBackgrd = true;
        String rowGrayBackgrd = "<TR CLASS=\"o\">";
        String rowBackgrd = "<TR>";
        int totalLineCount = 0;
        int coveredLineCount = 0;
        String htmlReportTemplate = FileUtils.readFile((String)JavaSourceLocator.getInstance().getSourceUrl(JsCoverageType.class).getPath().replace("JsCoverageType.java", "JsReportHtmlTemplate.html"), (String)"cp1252");
        for (JsCoverageType i : types.values()) {
            if (altTblBackgrd) {
                altTblBackgrd = false;
                str = String.valueOf(str) + rowGrayBackgrd;
            } else {
                altTblBackgrd = true;
                str = String.valueOf(str) + rowBackgrd;
            }
            String lineCoverage = this.formatNumber(i.getTypeCoverageLineCount() / i.getTypeLineCount() * 100);
            coveredLineCount += i.getTypeCoverageLineCount();
            totalLineCount += i.getTypeLineCount();
            str = String.valueOf(str) + "<TD><a onclick=\"vjo._jsDetailReport('" + i + "')\">" + i + "</a></TD><TD>WIP</TD><TD class=\"h\">" + this.formatNumber(i.getNumberOfCoveredFunctions() / i.getNumberOfTotalFunctions() * 100) + "% (" + i.getNumberOfCoveredFunctions() + "/" + i.getNumberOfTotalFunctions() + ")</TD><TD>WIP</TD><TD class=\"h\">" + lineCoverage + "%  (" + i.getTypeCoverageLineCount() + "/" + i.getTypeLineCount() + ")</TD></TR>";
        }
        String html = htmlReportTemplate.replace("ENTER_TYPE_DATA", str);
        String totalCoverage = this.formatNumber(coveredLineCount / totalLineCount * 100);
        int totalFunctionCount = 0;
        int coveredFunctionCount = 0;
        String overallCoverage = "<TR><TD>all classes</TD><TD>" + this.formatNumber(types.size() / types.size() * 100) + "% (" + types.size() + "/" + types.size() + ")</TD><TD class=\"h\">" + this.formatNumber(coveredFunctionCount / totalFunctionCount * 100) + "% (" + coveredFunctionCount + "/" + totalFunctionCount + ")</TD><TD>WIP</TD><TD class=\"h\">" + totalCoverage + "%  (" + coveredLineCount + "/" + totalLineCount + ")</TD></TR>";
        html = html.replace("TOTAL_COVERAGE", overallCoverage);
    }

    public String formatNumber(double val) {
        String num = String.valueOf(val);
        if (num.indexOf("\\.") > -1) {
            num = num.substring(0, num.indexOf("\\.") + 2);
        }
        return num;
    }

    public static void main(String[] args) throws UnsupportedEncodingException, SerializationException {
        JsCoverageBean m_coverageBean = new JsCoverageBean();
        JsCoverageType type = new JsCoverageType("alap");
        type.addFunction("funciton1");
        type.addFunction("funciton2");
        type.addFunction("funciton3");
        JsCoverageType type2 = new JsCoverageType("alap2");
        type.addFunction("BLAH1");
        type.addFunction("BLAH2");
        type.addFunction("BLAH3");
        JsCoverageType[] jsCoverageTypeArray = new JsCoverageType[]{type, type2};
        String json = JsonSerializer.getInstance().serialize(m_coverageBean.getTypes());
        System.out.println(json);
    }
}

