/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.converter.ConversionResult;
import org.eclipse.vjet.dsf.common.converter.ConversionRuntimeException;
import org.eclipse.vjet.dsf.common.converter.ConvertErrorObj;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public abstract class BaseConverter<T>
implements IConverter<T> {
    protected IConversionResult<T> m_previousResult = null;
    protected IConversionResult<T> m_lastResult = null;
    private boolean m_treatEmptyValueAsNull;

    @Override
    public IConversionResult<T> getPreviousResult() {
        return this.m_previousResult;
    }

    @Override
    public IConversionResult<T> getLastResult() {
        return this.m_lastResult;
    }

    @Override
    public boolean canConvertFromType(Class fromValueType) {
        for (Class valueType : this.getValidConversionTypes()) {
            if (!valueType.isAssignableFrom(fromValueType)) continue;
            return true;
        }
        return false;
    }

    protected Object convertObject(Object o, Object defaultAnswer) {
        try {
            return this.convert(o);
        }
        catch (ConversionRuntimeException conversionRuntimeException) {
            return defaultAnswer;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append("target: (" + this.getTargetType() + ") from: {");
        List<Class> conversionTypes = this.getValidConversionTypes();
        int len = conversionTypes.size();
        int i = 0;
        while (i < len) {
            sb.append(conversionTypes.get(i));
            if (i < len - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    protected String getUnableToConvertTypeMessage(Object value) {
        String passedInType = value == null ? "null" : value.getClass().getName();
        return "Unable to convert from type " + passedInType + " to type " + this.getTargetType().getName();
    }

    protected Double getValueAsDouble(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0 && this.isEmptyStringTreatedAsNull()) {
            return null;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException ne) {
            throw this.createConversionException(ne);
        }
    }

    protected Integer getValueAsInteger(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0 && this.isEmptyStringTreatedAsNull()) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ne) {
            throw this.createConversionException(ne);
        }
    }

    protected Long getValueAsLong(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0 && this.isEmptyStringTreatedAsNull()) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException ne) {
            throw this.createConversionException(ne);
        }
    }

    protected Integer[] getValueAsIntegerArray(String[] values) {
        Integer[] intValues = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            intValues[i] = this.getValueAsInteger(values[i]);
            ++i;
        }
        return intValues;
    }

    protected Long[] getValueAsLongArray(String[] values) {
        Long[] longValues = new Long[values.length];
        int i = 0;
        while (i < values.length) {
            longValues[i] = this.getValueAsLong(values[i]);
            ++i;
        }
        return longValues;
    }

    protected void validateWholeNumber(Number number, String value) {
        if (number instanceof Double || number instanceof Float) {
            throw this.createConversionException(new Exception(String.valueOf(value) + " is not a whole number"));
        }
    }

    protected ConversionRuntimeException createConversionException(Exception ne) {
        return new ConversionRuntimeException("Conversion Error", ne, String.class, this.getTargetType());
    }

    protected static List<Class> immutableTypeList(Class[] types) {
        return Collections.unmodifiableList(Arrays.asList(types));
    }

    protected IConversionResult<T> setResult(Object preValue, T value) {
        this.m_previousResult = this.m_lastResult;
        this.m_lastResult = new Result(preValue, value);
        return this.m_lastResult;
    }

    protected IConversionResult<T> setResult(Object preValue, ConvertErrorObj errorId) {
        this.m_previousResult = this.m_lastResult;
        this.m_lastResult = new Result(preValue, errorId);
        return this.m_lastResult;
    }

    public boolean isEmptyStringTreatedAsNull() {
        return this.m_treatEmptyValueAsNull;
    }

    public void setTreatEmptyStringAsNull(boolean treatEmptyValueAsNull) {
        this.m_treatEmptyValueAsNull = treatEmptyValueAsNull;
    }

    private static class Result<T>
    extends ConversionResult<T> {
        private static final long serialVersionUID = 1L;

        private Result(Object preValue, T value) {
            this.setPreConversionValue(preValue);
            this.setConverted(true);
            this.setValue(value);
        }

        private Result(Object preValue, ConvertErrorObj errorId) {
            this.setPreConversionValue(preValue);
            this.setError(errorId);
        }
    }
}

