/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.converter;

import java.util.List;
import org.eclipse.vjet.dsf.common.converter.BaseConverter;
import org.eclipse.vjet.dsf.common.converter.IConversionResult;
import org.eclipse.vjet.dsf.common.converter.IConverter;

public class StringArrayConverter
extends BaseConverter<String[]> {
    private static final List<Class> VALID_CONVERSION_TYPES;

    static {
        Class[] types = new Class[]{String[].class};
        VALID_CONVERSION_TYPES = StringArrayConverter.immutableTypeList(types);
    }

    @Override
    public Class<String[]> getTargetType() {
        return String[].class;
    }

    @Override
    public List<Class> getValidConversionTypes() {
        return VALID_CONVERSION_TYPES;
    }

    @Override
    public IConversionResult<String[]> convert(Object preValue) {
        if (preValue == null) {
            return this.setResult(preValue, null);
        }
        String[] values = null;
        Class<?> clz = preValue.getClass();
        try {
            if (clz == String[].class) {
                values = (String[])preValue;
                return this.setResult(preValue, values);
            }
            return this.setResult(preValue, IConverter.IncompatibleTypeConversionError);
        }
        catch (Exception exception) {
            return this.setResult(preValue, IConverter.UnconvertableValueConversionError);
        }
    }
}

