/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.jsruntime.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfException;
import org.eclipse.vjet.vsf.jsruntime.optimizer.IJsOptimizer;

public abstract class JsCodeGenOptimizer<T> {
    private Map<Object, IJsOptimizer> m_map = new HashMap<Object, IJsOptimizer>();
    private List<Object> m_instances = new ArrayList<Object>();

    public abstract Object getKey(T var1);

    public abstract IJsOptimizer<T> createOptimizer(T var1) throws DsfException;

    public abstract String getFunctionPre();

    public void add(T ref) {
        if (ref == null) {
            return;
        }
        Object key = this.getKey(ref);
        IJsOptimizer<T> optimizer = this.m_map.get(key);
        try {
            if (optimizer == null) {
                optimizer = this.createOptimizer(ref);
                this.m_map.put(key, optimizer);
                this.m_instances.add(ref);
            } else {
                optimizer.compare(ref);
                this.m_instances.add(ref);
            }
        }
        catch (DsfException dsfException) {}
    }

    public String createDefs() {
        int i = 0;
        StringBuilder buf = new StringBuilder();
        for (IJsOptimizer method : this.m_map.values()) {
            buf.append(method.createDef(String.valueOf(this.getFunctionPre()) + i));
            ++i;
        }
        return buf.toString();
    }

    public String createCall(T ref) {
        if (ref == null) {
            return null;
        }
        IJsOptimizer method = this.m_map.get(this.getKey(ref));
        if (method != null) {
            return method.createCall(ref);
        }
        return null;
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.m_instances.contains(obj);
    }
}

