/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.slot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.resource.slot.IJsResourceReplacement;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlot;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.slot.ResourceSlotter;
import org.eclipse.vjet.dsf.resource.slot.ScriptType;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;

public abstract class JsResourceSlotter
extends ResourceSlotter<JsResourceSlot> {
    private Set<JsResourceSlotAssignment> m_slotAssignments = null;
    private IJsResourceReplacement m_replacement = null;
    private String m_runtimeVersion = null;

    @Override
    protected JsResourceSlot createSlot(String name) {
        return new JsResourceSlot(name);
    }

    public abstract String getDefaultSlotName();

    public abstract JsResourceSlotter cloneAnEmptySlotter();

    public void addToSlot(IJsResourceRef resource) {
        if (this.isInAnySlot(resource.getUrn()) != null) {
            return;
        }
        JsType type = resource.getType();
        if (type.hasExecution() || !type.hasDef()) {
            this.addToSlot(resource, ScriptType.ExecutingScript);
        } else {
            this.addToSlot(resource, ScriptType.ClassDefinition);
        }
    }

    public void addToSlot(IJsResourceRef resource, String slotName) {
        if (this.isInAnySlot(resource.getUrn()) != null) {
            return;
        }
        JsType type = resource.getType();
        ScriptType stype = ScriptType.ClassDefinition;
        if (type.hasExecution() || !type.hasDef()) {
            stype = ScriptType.ExecutingScript;
        }
        ((JsResourceSlot)this.getSlot(JsResourceSlotter.getSlotName(slotName, stype))).add(resource);
    }

    @Deprecated
    public void addToSlot(IJsResourceRef resource, ScriptType type) {
        if (this.isInAnySlot(resource.getUrn()) != null) {
            return;
        }
        String urnForAssignment = null;
        if (this.m_replacement != null && this.m_replacement.contains(resource)) {
            urnForAssignment = resource.getUrn();
            if (!ResourceUsageCtx.ctx().isFragmentExtractionMode()) {
                resource = this.m_replacement.getReplacement(resource);
            }
        }
        String name = this.getPreAssignedSlot(resource, urnForAssignment, this.getDefaultSlotName());
        ((JsResourceSlot)this.getSlot(JsResourceSlotter.getSlotName(name, type))).add(resource);
    }

    public void addSlotAssignment(JsResourceSlotAssignment slotAssignment) {
        if (slotAssignment == null) {
            return;
        }
        if (this.m_slotAssignments == null) {
            this.m_slotAssignments = new LinkedHashSet<JsResourceSlotAssignment>(3);
        }
        this.m_slotAssignments.add(slotAssignment);
    }

    public Set<JsResourceSlotAssignment> getSlotAssignmentList() {
        return this.m_slotAssignments;
    }

    public void setResourceReplacement(IJsResourceReplacement replacement) {
        this.m_replacement = replacement;
    }

    public IJsResourceReplacement getResourceReplacement() {
        return this.m_replacement;
    }

    public void setRuntimeVersion(String version) {
        if ("".equals(version)) {
            DsfExceptionHelper.chuck((String)"invalid runtime version");
        }
        this.m_runtimeVersion = version;
    }

    public String getRuntimeVersion() {
        return this.m_runtimeVersion;
    }

    public static String getSlotName(String baseName, ScriptType type) {
        return String.valueOf(baseName) + "_" + type.name();
    }

    public static String getSlotName(String baseName, JsType type) {
        if (type.hasExecution() || !type.hasDef()) {
            return JsResourceSlotter.getSlotName(baseName, ScriptType.ExecutingScript);
        }
        return JsResourceSlotter.getSlotName(baseName, ScriptType.ClassDefinition);
    }

    public String getPreAssignedSlot(IJsResourceRef resource, String urnForAssignment, String defaultSlotName) {
        String slotName = null;
        if (this.m_slotAssignments != null) {
            for (JsResourceSlotAssignment assignment : this.m_slotAssignments) {
                slotName = JsResourceSlotter.findAssignedSlotName(assignment, resource, urnForAssignment);
                if (slotName == null) continue;
                return slotName;
            }
        }
        return defaultSlotName;
    }

    private static String findAssignedSlotName(JsResourceSlotAssignment assignment, IJsResourceRef resource, String urnForAssignment) {
        String slotName;
        if (assignment == null) {
            return null;
        }
        if (urnForAssignment != null && (slotName = assignment.getSlotName(urnForAssignment)) != null) {
            return slotName;
        }
        if (resource == null) {
            return null;
        }
        return assignment.getSlotName(resource);
    }
}

