/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.resource.permutation;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.context.BaseSubCtx;
import org.eclipse.vjet.dsf.common.context.ContextHelper;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.ISubCtx;
import org.eclipse.vjet.dsf.resource.content.runtime.BaseVariationResolver;
import org.eclipse.vjet.dsf.resource.permutation.DefaultPermutationSpec;
import org.eclipse.vjet.dsf.resource.permutation.PermutationSpec;
import org.eclipse.vjet.dsf.resource.permutation.VariationCtx;

public class Permutation
extends BaseSubCtx
implements Serializable {
    private static final long serialVersionUID = -3734003316566272166L;
    private static PermutationSpec s_permutationSpec = new DefaultPermutationSpec();
    private final Locale m_language;
    private final String m_target;
    private final String m_external;
    private final String m_innerStr;
    private final List<String> m_compatibleExternals;
    private final Permutation m_parent;
    private String m_country;

    public static PermutationSpec getPermutationSpec() {
        return s_permutationSpec;
    }

    public static void setPermutationSpec(PermutationSpec permutationSpec) {
        s_permutationSpec = permutationSpec;
    }

    public static Permutation getFromCtx() {
        return Permutation.getFromCtx(DsfCtx.ctx());
    }

    public static Permutation getFromCtx(DsfCtx ctx) {
        Permutation context = CtxAssociator.getCtx(ctx);
        if (context == null) {
            context = Permutation.getDefault();
            Permutation.setToCtx(context);
        }
        return context;
    }

    public static void resetCtx() {
        Permutation.setToCtx(Permutation.getDefault());
    }

    public static void setToCtx(Permutation permutation) {
        CtxAssociator.setCtx(permutation);
    }

    public static void updateCtx(Locale locale, String target) {
        Permutation.setToCtx(Permutation.create(locale, target));
    }

    public static void updateCtx(Locale locale) {
        Permutation.updateCtx(locale, null);
    }

    public static boolean isDefaultTarget(String target) {
        return Permutation.getPermutationSpec().isDefaultTarget(target);
    }

    public static boolean isDefault(Permutation permutation) {
        return Permutation.getPermutationSpec().isDefaultPermutation(permutation);
    }

    public static Permutation getDefault() {
        return Permutation.getPermutationSpec().getDefaultPermutation();
    }

    public static Permutation create(Locale locale) {
        return Permutation.create(locale, null);
    }

    public static Permutation create(Locale locale, String target) {
        return new Permutation(locale, target);
    }

    public static Permutation createLanguagePermutation(Permutation parent, Locale language) {
        return new Permutation(parent, language, parent.getTarget());
    }

    public static Permutation createLanguagePermutation(Permutation parent, Locale language, String target) {
        return new Permutation(parent, language, target);
    }

    public static Permutation createCountryPermutation(Permutation parent, String country) {
        return new Permutation(parent, country, parent.getTarget());
    }

    public static Permutation createCountryPermutation(Permutation parent, String country, String target) {
        return new Permutation(parent, country, target);
    }

    public static Permutation fromExternal(String external) {
        return Permutation.fromExternal(external, false);
    }

    public static Permutation fromExternal(String external, boolean useDefaultTarget) {
        return Permutation.getPermutationSpec().fromExternalWithDefault(external, useDefaultTarget);
    }

    public static Locale fromExternalLocale(String external) {
        return Permutation.getPermutationSpec().fromExternalLocale(external);
    }

    public static Map<String, BaseVariationResolver> getVariationResolvers() {
        return Permutation.getVariationCtx().getVariationResolvers();
    }

    public static void setVariationResolvers(List<BaseVariationResolver> resolvers) {
        Permutation.getVariationCtx().addVariationResolvers(resolvers);
    }

    public static void registerVariationResolver(BaseVariationResolver resolver) {
        Permutation.getVariationCtx().registerVariationResolver(resolver);
    }

    private static VariationCtx getVariationCtx() {
        VariationCtx variationCtx = CtxAssociator.getVariationCtx(DsfCtx.ctx());
        if (variationCtx == null) {
            variationCtx = new VariationCtx();
            CtxAssociator.setVariationCtx(variationCtx);
        }
        return variationCtx;
    }

    protected Permutation(Permutation parent, Locale extLanguage, String target) {
        this(parent, null, extLanguage, target);
    }

    protected Permutation(Locale locale, String target) {
        this(null, null, locale, target);
    }

    protected Permutation(Permutation parent, String country, String target) {
        this(parent, country, null, target);
    }

    protected Permutation(Permutation parent, String country, Locale language, String target) {
        this.m_parent = parent;
        this.m_country = country;
        this.m_language = language == null ? (this.m_parent != null ? parent.getLanguage() : Permutation.getPermutationSpec().getDefaultPermutation().getLocale()) : language;
        this.m_target = target;
        this.m_innerStr = this.asString();
        this.m_external = Permutation.getPermutationSpec().toExternal(this);
        this.m_compatibleExternals = Permutation.getPermutationSpec().getExternalsWithResolutionOrder(this);
    }

    public void setToCtx() {
        Permutation.setToCtx(this);
    }

    public boolean isDefault() {
        return Permutation.getPermutationSpec().isDefaultPermutation(this);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)o;
        return this.m_innerStr.equals(permutation.m_innerStr);
    }

    public int hashCode() {
        return this.m_innerStr.hashCode();
    }

    private String asString() {
        StringBuffer buf = new StringBuffer();
        if (this.isLanguageSpecific()) {
            buf.append(this.m_language);
            buf.append("___");
            buf.append(this.m_parent.asString());
        }
        if (this.isCountrySpecific()) {
            buf.append(this.m_country);
            buf.append("___");
            buf.append(this.m_parent.asString());
        } else {
            if (this.m_language != null) {
                buf.append(this.m_language);
            }
            if (this.m_language != null && this.m_target != null) {
                buf.append("__");
            }
            if (this.m_target != null) {
                buf.append(this.m_target);
            }
        }
        return buf.toString();
    }

    public String toExternal() {
        return this.m_external;
    }

    public List<String> getExternalsWithResolutionOrder() {
        return this.m_compatibleExternals;
    }

    public Locale getLocale() {
        return this.m_language;
    }

    public Locale getLanguage() {
        return this.m_language;
    }

    public String getCountry() {
        if (this.isLanguageSpecific()) {
            return this.m_parent.getCountry();
        }
        if (this.isCountrySpecific()) {
            return this.m_country;
        }
        return this.m_language.getCountry();
    }

    public String getTarget() {
        return this.m_target;
    }

    public Permutation getParent() {
        return this.m_parent;
    }

    public boolean isExtended() {
        return this.m_parent != null;
    }

    public boolean isLanguageSpecific() {
        return this.isExtended() && this.m_country == null;
    }

    public boolean isCountrySpecific() {
        return this.isExtended() && this.m_country != null;
    }

    public static boolean isLanguageSpecific(String external) {
        return PermutationSpec.isLanguagePermutation(external);
    }

    public String toString() {
        Z z = new Z();
        if (this.isLanguageSpecific()) {
            z.format("language", (Object)this.m_language);
            z.format("locale", (Object)this.getParent().getLocale());
        } else {
            z.format("locale", (Object)this.m_language);
        }
        z.format("target", (Object)this.m_target);
        if (this.isCountrySpecific()) {
            z.format("country", (Object)this.m_country);
        }
        z.format("external", (Object)this.m_external);
        z.format("compatibleExternals", this.m_compatibleExternals);
        z.format("spec", (Object)Permutation.getPermutationSpec());
        return z.toString();
    }

    public static void main(String[] args) {
        System.out.println(Permutation.fromExternal("en_US"));
        System.out.println(Permutation.fromExternal("en"));
        System.out.println(Permutation.fromExternal("en_US_autos"));
        System.out.println(Permutation.fromExternal("en_US__T"));
        System.out.println(Permutation.fromExternal("en__T"));
        System.out.println(Permutation.fromExternal("en_US_autos__T"));
        System.out.println(Permutation.fromExternal("en_CN"));
        System.out.println(Permutation.fromExternal("en_CN__T"));
        System.out.println(Permutation.fromExternal("en_CN_autos__T"));
        System.out.println(Permutation.fromExternal("dd_CN"));
        System.out.println(Permutation.fromExternal("dd_CN__T"));
        System.out.println(Permutation.fromExternal("dd_CN_autos__T"));
        System.out.println(Permutation.fromExternal("en_DD"));
        System.out.println(Permutation.fromExternal("en_DD__T"));
        System.out.println(Permutation.fromExternal("en_DD_autos__T"));
    }

    private static class CtxAssociator
    extends ContextHelper {
        private static final String CTX_NAME = Permutation.class.getSimpleName();
        private static final String VARIATION_CTX_NAME = VariationCtx.class.getSimpleName();

        private CtxAssociator() {
        }

        protected static Permutation getCtx(DsfCtx ctx) {
            return (Permutation)CtxAssociator.getSubCtx((DsfCtx)ctx, (String)CTX_NAME);
        }

        protected static void setCtx(Permutation ctx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)CTX_NAME, (ISubCtx)ctx);
        }

        protected static VariationCtx getVariationCtx(DsfCtx ctx) {
            return (VariationCtx)((Object)CtxAssociator.getSubCtx((DsfCtx)ctx, (String)VARIATION_CTX_NAME));
        }

        protected static void setVariationCtx(VariationCtx variationCtx) {
            CtxAssociator.setSubCtx((DsfCtx)DsfCtx.ctx(), (String)VARIATION_CTX_NAME, (ISubCtx)variationCtx);
        }
    }
}

