/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.spec.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.vjet.dsf.common.CallerIntrospector;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.spec.component.IComponentSpec;
import org.eclipse.vjet.dsf.spec.component.IComponentSpecs;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceDispenser;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceRef;
import org.eclipse.vjet.vsf.resource.pattern.js.JsRefCollection;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResourceRefMgr;
import org.eclipse.vjet.vsf.resource.pattern.js.JsType;

public abstract class BaseJsComponentSpec
implements IComponentSpec,
IJsResourceDispenser {
    private static Iterator<IComponentSpec> EMPTY_COMP_SPEC_ITERATOR = Collections.unmodifiableList(new ArrayList(0)).iterator();
    private static Map<String, Boolean> s_specs = new ConcurrentHashMap<String, Boolean>(100);
    private List<IComponentSpec> m_dependentComponents;
    private Map<Locale, List<IComponentSpec>> m_localeComponentsInclusionSpec = new LinkedHashMap<Locale, List<IComponentSpec>>(6);
    private Map<Locale, List<IComponentSpec>> m_localeComponentsExclusionSpec = new LinkedHashMap<Locale, List<IComponentSpec>>(6);
    private Set<String> m_locales = new LinkedHashSet<String>(2);
    private List<IJsResourceRef> m_definitionScripts;
    private List<IJsResourceRef> m_executionScripts;
    private final IComponentSpecs m_dependentSpecs = new IComponentSpecs(){

        @Override
        public Iterator<IComponentSpec> iterator() {
            if (BaseJsComponentSpec.this.m_dependentComponents == null) {
                return EMPTY_COMP_SPEC_ITERATOR;
            }
            return BaseJsComponentSpec.this.m_dependentComponents.iterator();
        }

        @Override
        public int size() {
            if (BaseJsComponentSpec.this.m_dependentComponents == null) {
                return 0;
            }
            return BaseJsComponentSpec.this.m_dependentComponents.size();
        }
    };

    public BaseJsComponentSpec() {
        if (!s_specs.containsKey(this.getClass().getName())) {
            this.init("JsRefs");
            s_specs.put(this.getClass().getName(), Boolean.TRUE);
        }
    }

    @Override
    public IComponentSpecs getDependentSpecs() {
        return this.m_dependentSpecs;
    }

    @Override
    public Iterable<IJsResourceRef> getClassDefinitions() {
        if (this.m_definitionScripts != null) {
            return this.m_definitionScripts;
        }
        return IJsResourceRef.EMPTY_ITERABLE;
    }

    @Override
    public Iterable<IJsResourceRef> getExecutingScript() {
        if (this.m_executionScripts != null) {
            return this.m_executionScripts;
        }
        return IJsResourceRef.EMPTY_ITERABLE;
    }

    public BaseJsComponentSpec addDependentComponent(IComponentSpec compSpec) {
        this.assertNotNull(compSpec, "compSpec is null");
        if (this.m_dependentComponents == null) {
            this.m_dependentComponents = new ArrayList<IComponentSpec>(2);
        }
        this.m_dependentComponents.add(compSpec);
        return this;
    }

    public BaseJsComponentSpec addDependentComponent(IComponentSpec compSpec, Locale ... locales) {
        this.assertNotNull(compSpec, "compSpec is null");
        this.assertNotNull(locales, "locale is null");
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            this.m_locales.add(locale.toString());
            List<IComponentSpec> list = this.m_localeComponentsInclusionSpec.get(locale);
            if (list == null) {
                list = new ArrayList<IComponentSpec>(2);
            }
            list.add(compSpec);
            this.m_localeComponentsInclusionSpec.put(locale, list);
            ++n2;
        }
        return this;
    }

    public BaseJsComponentSpec removeDependentComponent(IComponentSpec compSpec, Locale ... locales) {
        this.assertNotNull(compSpec, "compSpec is null");
        this.assertNotNull(locales, "locale is null");
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            this.m_locales.add(locale.toString());
            List<IComponentSpec> list = this.m_localeComponentsExclusionSpec.get(locale);
            if (list == null) {
                list = new ArrayList<IComponentSpec>(2);
            }
            list.add(compSpec);
            this.m_localeComponentsExclusionSpec.put(locale, list);
            ++n2;
        }
        return this;
    }

    public IComponentSpecs getExclusionDependentSpec(Locale locale) {
        final List<IComponentSpec> list = this.m_localeComponentsExclusionSpec.get(locale);
        IComponentSpecs spec = new IComponentSpecs(){

            @Override
            public Iterator<IComponentSpec> iterator() {
                if (list == null) {
                    return EMPTY_COMP_SPEC_ITERATOR;
                }
                return list.iterator();
            }

            @Override
            public int size() {
                if (list == null) {
                    return 0;
                }
                return list.size();
            }
        };
        return spec;
    }

    public IComponentSpecs getInclusionDependentSpec(Locale locale) {
        final List<IComponentSpec> list = this.m_localeComponentsInclusionSpec.get(locale);
        IComponentSpecs spec = new IComponentSpecs(){

            @Override
            public Iterator<IComponentSpec> iterator() {
                if (list == null) {
                    return EMPTY_COMP_SPEC_ITERATOR;
                }
                return list.iterator();
            }

            @Override
            public int size() {
                if (list == null) {
                    return 0;
                }
                return list.size();
            }
        };
        return spec;
    }

    public BaseJsComponentSpec addClassDefinitionJsRef(JsResource resource) {
        this.addClassDefinitionJsRef(JsRefMgrAdapter.createJsRef(resource, this.getClass(), JsType.DefOnly));
        return this;
    }

    public BaseJsComponentSpec addClassDefinitionJsRef(IJsResourceRef jsRef) {
        this.assertNotNull(jsRef, "jsRef is null");
        if (this.m_definitionScripts == null) {
            this.m_definitionScripts = new ArrayList<IJsResourceRef>(2);
        }
        this.m_definitionScripts.add(jsRef);
        return this;
    }

    public BaseJsComponentSpec addExecutionJsRef(JsResource resource) {
        this.addExecutionJsRef(JsRefMgrAdapter.createJsRef(resource, this.getClass(), JsType.All));
        return this;
    }

    public BaseJsComponentSpec addExecutionJsRef(IJsResourceRef jsRef) {
        this.assertNotNull(jsRef, "jsRef is null");
        if (this.m_executionScripts == null) {
            this.m_executionScripts = new ArrayList<IJsResourceRef>(2);
        }
        this.m_executionScripts.add(jsRef);
        return this;
    }

    public BaseJsComponentSpec addJsRef(IJsResourceRef jsRef) {
        this.assertNotNull(jsRef, "jsRef is null");
        JsType type = jsRef.getType();
        if (type.hasExecution() || !type.hasDef()) {
            this.addExecutionJsRef(jsRef);
        } else {
            this.addClassDefinitionJsRef(jsRef);
        }
        return this;
    }

    public JsRefCollection getJsRefs() {
        return JsRefMgrAdapter.getRefs(this.getClass());
    }

    public static IJsResourceRef jsRef(JsResource resource, JsType type) {
        Class ownerClz = CallerIntrospector.getCallingClass();
        IJsResourceRef ref = JsRefMgrAdapter.createJsRef(resource, ownerClz, type);
        JsRefMgrAdapter.addRef(ownerClz, ref);
        return ref;
    }

    public IJsResourceRef onFlyJsRef(JsResource resource, JsType type) {
        IJsResourceRef ref = JsRefMgrAdapter.createJsRef(resource, this.getClass(), type);
        return ref;
    }

    @Override
    public Set<String> getLocales() {
        return this.m_locales;
    }

    protected void init(String scopeClzName) {
        String clzName = String.valueOf(this.getClass().getName()) + "$" + scopeClzName;
        try {
            Class.forName(clzName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            DsfExceptionHelper.chuck((String)msg);
        }
    }

    private static class JsRefMgrAdapter
    extends JsResourceRefMgr {
        private JsRefMgrAdapter() {
        }

        protected static synchronized void addRef(Class<? extends IJsResourceDispenser> dispenser, IJsResourceRef ref) {
            JsResourceRefMgr.addRef(dispenser, (IJsResourceRef)ref);
        }

        protected static JsRefCollection getRefs(Class<? extends IJsResourceDispenser> dispenser) {
            return JsResourceRefMgr.getRefs(dispenser);
        }

        protected static IJsResourceRef createJsRef(JsResource resource, Class<? extends IJsResourceDispenser> dispenser, JsType type) {
            return JsResourceRefMgr.createJsRef((JsResource)resource, dispenser, (JsType)type);
        }
    }
}

