/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import java.util.Stack;
import org.apache.batik.css.parser.Parser;
import org.eclipse.vjet.dsf.css.dom.impl.DCssCharsetRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssFontFaceRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssImportRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssMediaList;
import org.eclipse.vjet.dsf.css.dom.impl.DCssMediaRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssPageRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssProperty;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssRuleList;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleDeclaration;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssStyleSheet;
import org.eclipse.vjet.dsf.css.dom.impl.DCssUnknownRule;
import org.eclipse.vjet.dsf.css.dom.impl.DCssValue;
import org.eclipse.vjet.dsf.css.sac.helpers.DParserFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class DCssBuilder {
    private static final String PARSER = Parser.class.getName();
    private org.w3c.css.sac.Parser m_parser = null;
    private CSSStyleSheet m_parentStyleSheet = null;

    public DCssBuilder() {
        try {
            DCssBuilder.setProperty("org.w3c.css.sac.parser", PARSER);
            DParserFactory factory = new DParserFactory();
            this.m_parser = factory.makeParser();
        }
        catch (Exception exception) {}
    }

    public CSSStyleSheet parseStyleSheet(String cssText) throws IOException {
        InputSource is = new InputSource((Reader)new StringReader(cssText));
        return this.parseStyleSheet(is);
    }

    public CSSStyleSheet parseStyleSheet(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.m_parser.setDocumentHandler((DocumentHandler)handler);
        this.m_parser.parseStyleSheet(source);
        return (DCssStyleSheet)handler.getRoot();
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        DCssStyleDeclaration sd = new DCssStyleDeclaration(null);
        this.parseStyleDeclaration(sd, source);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration sd, InputSource source) throws IOException {
        Stack<Object> nodeStack = new Stack<Object>();
        nodeStack.push(sd);
        CSSOMHandler handler = new CSSOMHandler(nodeStack);
        this.m_parser.setDocumentHandler((DocumentHandler)handler);
        this.m_parser.parseStyleDeclaration(source);
    }

    public DCssValue parsePropertyValue(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.m_parser.setDocumentHandler((DocumentHandler)handler);
        return new DCssValue(this.m_parser.parsePropertyValue(source));
    }

    public CSSRule parseRule(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this.m_parser.setDocumentHandler((DocumentHandler)handler);
        this.m_parser.parseRule(source);
        return (DCssRule)handler.getRoot();
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        return this.m_parser.parseSelectors(source);
    }

    public void setParentStyleSheet(CSSStyleSheet parentStyleSheet) {
        this.m_parentStyleSheet = parentStyleSheet;
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    public void setParentRule(CSSRule parentRule) {
    }

    public static void setProperty(String key, String val) {
        Properties props = System.getProperties();
        props.put(key, val);
        System.setProperties(props);
    }

    class CSSOMHandler
    implements DocumentHandler {
        private Stack<Object> m_nodeStack;
        private Object m_root = null;

        public CSSOMHandler(Stack<Object> nodeStack) {
            this.m_nodeStack = nodeStack;
        }

        public CSSOMHandler() {
            this.m_nodeStack = new Stack();
        }

        public Object getRoot() {
            return this.m_root;
        }

        public void startDocument(InputSource source) throws CSSException {
            if (this.m_nodeStack.empty()) {
                DCssStyleSheet ss = new DCssStyleSheet();
                DCssBuilder.this.m_parentStyleSheet = ss;
                DCssRuleList rules = (DCssRuleList)ss.getCssRules();
                this.m_nodeStack.push(ss);
                this.m_nodeStack.push(rules);
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            DCssUnknownRule ir = new DCssUnknownRule(DCssBuilder.this.m_parentStyleSheet, null, atRule);
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(ir);
            } else {
                this.m_root = ir;
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            DCssImportRule ir = new DCssImportRule(DCssBuilder.this.m_parentStyleSheet, null, uri, new DCssMediaList(media));
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(ir);
            } else {
                this.m_root = ir;
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            DCssMediaRule mr = new DCssMediaRule(DCssBuilder.this.m_parentStyleSheet, null, new DCssMediaList(media));
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(mr);
            }
            DCssRuleList rules = new DCssRuleList();
            mr.setRuleList(rules);
            this.m_nodeStack.push(mr);
            this.m_nodeStack.push(rules);
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void startCharset(String name) throws CSSException {
            DCssCharsetRule rule = new DCssCharsetRule(DCssBuilder.this.m_parentStyleSheet, null, name);
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(rule);
            }
            DCssStyleDeclaration decl = new DCssStyleDeclaration(rule);
            this.m_nodeStack.push(rule);
            this.m_nodeStack.push(decl);
        }

        public void endCharset(String name) throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            DCssPageRule pr = new DCssPageRule(DCssBuilder.this.m_parentStyleSheet, null, name, pseudo_page);
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(pr);
            }
            DCssStyleDeclaration decl = new DCssStyleDeclaration(pr);
            pr.setStyle(decl);
            this.m_nodeStack.push(pr);
            this.m_nodeStack.push(decl);
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void startFontFace() throws CSSException {
            DCssFontFaceRule ffr = new DCssFontFaceRule(DCssBuilder.this.m_parentStyleSheet, null);
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(ffr);
            }
            DCssStyleDeclaration decl = new DCssStyleDeclaration(ffr);
            ffr.setStyle(decl);
            this.m_nodeStack.push(ffr);
            this.m_nodeStack.push(decl);
        }

        public void endFontFace() throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            DCssStyleRule sr = new DCssStyleRule(DCssBuilder.this.m_parentStyleSheet, null, selectors);
            if (!this.m_nodeStack.empty()) {
                ((DCssRuleList)this.m_nodeStack.peek()).add(sr);
            }
            DCssStyleDeclaration decl = new DCssStyleDeclaration(sr);
            sr.setStyle(decl);
            this.m_nodeStack.push(sr);
            this.m_nodeStack.push(decl);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.m_nodeStack.pop();
            this.m_root = this.m_nodeStack.pop();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            CSSStyleDeclaration decl = (CSSStyleDeclaration)this.m_nodeStack.peek();
            if (decl instanceof DCssStyleDeclaration) {
                ((DCssStyleDeclaration)decl).addProperty(new DCssProperty(name, new DCssValue(value), important));
            }
        }
    }
}

