/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.util.TextChildOperationUtil;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DTextArea
extends BaseAttrsHtmlElement
implements IDFormControl {
    private static final long serialVersionUID = 3257852073558357816L;

    public DTextArea() {
        super(HtmlTypeEnum.TEXTAREA);
    }

    public DTextArea(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.TEXTAREA);
    }

    public DTextArea(String textValue) {
        this();
        this.setHtmlExtTextValue(textValue);
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.TEXTAREA;
    }

    public int getHtmlCols() {
        return this.getHtmlAttributeInteger(EHtmlAttr.cols);
    }

    public DTextArea setHtmlCols(String cols) {
        return this.setHtmlCols(this.toInt("DTextArea:cols", cols));
    }

    public DTextArea setHtmlCols(int cols) {
        this.setHtmlAttribute(EHtmlAttr.cols, String.valueOf(cols));
        return this;
    }

    public boolean getHtmlDisabled() {
        return this.getHtmlAttributeExists(EHtmlAttr.disabled);
    }

    public DTextArea setHtmlDisabled(String disabled) {
        return this.setHtmlDisabled(this.toBoolean("disabled", disabled));
    }

    public DTextArea setHtmlDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        return this;
    }

    public String getHtmlName() {
        return this.getHtmlAttribute(EHtmlAttr.name);
    }

    public DTextArea setHtmlName(String name) {
        this.setHtmlAttribute(EHtmlAttr.name, name);
        return this;
    }

    public boolean getHtmlReadOnly() {
        return this.getHtmlAttributeExists(EHtmlAttr.readonly);
    }

    public DTextArea setHtmlReadOnly(String readOnly) {
        return this.setHtmlReadOnly(this.toBoolean("readonly", readOnly));
    }

    public DTextArea setHtmlReadOnly(boolean readOnly) {
        this.setHtmlAttribute(EHtmlAttr.readonly, readOnly);
        return this;
    }

    public int getHtmlRows() {
        return this.getHtmlAttributeInteger(EHtmlAttr.rows);
    }

    public DTextArea setHtmlRows(String rows) {
        return this.setHtmlRows(this.toInt("DTextArea:rows", rows));
    }

    public DTextArea setHtmlRows(int rows) {
        this.setHtmlAttribute(EHtmlAttr.rows, String.valueOf(rows));
        return this;
    }

    public String getHtmlType() {
        return this.getHtmlAttribute(EHtmlAttr.type);
    }

    public String getHtmlValue() {
        return this.getHtmlAttribute(EHtmlAttr.value);
    }

    public boolean getHtmlAutoFocus() {
        return this.getHtmlAttributeExists(EHtmlAttr.autofocus);
    }

    public DTextArea setHtmlAutoFocus(String autofocus) {
        return this.setHtmlAutoFocus(this.toBoolean("autofocus", autofocus));
    }

    public DTextArea setHtmlAutoFocus(boolean autofocus) {
        this.setHtmlAttribute(EHtmlAttr.autofocus, autofocus);
        return this;
    }

    public String getHtmlPlaceholder() {
        return this.getHtmlAttribute(EHtmlAttr.placeholder);
    }

    public DTextArea setHtmlPlaceholder(String placeholder) {
        this.setHtmlAttribute(EHtmlAttr.placeholder, placeholder);
        return this;
    }

    public boolean getHtmlRequired() {
        return this.getHtmlAttributeExists(EHtmlAttr.required);
    }

    public DTextArea setHtmlRequired(String required) {
        return this.setHtmlRequired(this.toBoolean("required", required));
    }

    public DTextArea setHtmlRequired(boolean required) {
        this.setHtmlAttribute(EHtmlAttr.required, required);
        return this;
    }

    public DTextArea setHtmlExtValue(String value) {
        NodeList list = this.getChildNodes();
        while (list.getLength() > 0) {
            this.removeChild(list.item(0));
        }
        this.add(value);
        return this;
    }

    public String getHtmlExtValue() {
        DText text = null;
        String nodeValue = "";
        NodeList list = this.getChildNodes();
        if (list.getLength() == 1) {
            text = (DText)list.item(0);
            nodeValue = text.getNodeValue();
        }
        return nodeValue;
    }

    public DTextArea setHtmlExtTextValue(String value) {
        TextChildOperationUtil.setTextValue((DNode)this, (String)value);
        return this;
    }

    public String getHtmlExtTextValue() {
        return TextChildOperationUtil.getTextValue((DNode)this);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)"accesskey", (Object)this.getHtmlAccessKey()) + Z.fmt((String)"cols", (Object)("" + this.getHtmlCols())) + Z.fmt((String)"disabled", (Object)("" + this.getHtmlDisabled())) + Z.fmt((String)"name", (Object)this.getHtmlName()) + Z.fmt((String)"readonly", (Object)("" + this.getHtmlReadOnly())) + Z.fmt((String)"tabindex", (Object)("" + this.getHtmlTabIndex())) + Z.fmt((String)"type", (Object)this.getHtmlType()) + Z.fmt((String)"value", (Object)this.getHtmlValue()) + Z.fmt((String)"autofocus", (boolean)this.getHtmlAutoFocus()) + Z.fmt((String)"placeholder", (Object)this.getHtmlPlaceholder()) + Z.fmt((String)"required", (boolean)this.getHtmlRequired());
    }

    public DTextArea add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    public DTextArea add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DTextArea addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DTextArea dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DTextArea dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DTextArea setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DTextArea cloned() {
        return (DTextArea)super.cloned();
    }

    public DTextArea setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DTextArea setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DTextArea setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DTextArea setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTextArea setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DTextArea setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DTextArea setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DTextArea setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTextArea setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTextArea setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTextArea setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTextArea setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTextArea setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTextArea setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DTextArea setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DTextArea setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DTextArea setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTextArea setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTextArea setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DTextArea setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DTextArea setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DTextArea setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTextArea setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTextArea setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DTextArea setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DTextArea setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DTextArea setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DTextArea add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DTextArea add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DTextArea add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DTextArea addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DTextArea addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DTextArea addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DTextArea addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTextArea jif(String jif) {
        super.jif(jif);
        return this;
    }
}

