/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.schemas;

import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.schemas.AttributeDataType;
import org.eclipse.vjet.dsf.html.schemas.AttributeDefault;
import org.eclipse.vjet.dsf.html.schemas.BaseSchemaEnum;
import org.eclipse.vjet.dsf.html.schemas.IAttributeInfo;

public class AttributeInfoEnumeration
implements IAttributeInfo {
    private final String m_name;
    final Class m_enumType;
    final AttributeDefault m_attrDefault;
    private final BaseSchemaEnum m_defaultValue;

    public AttributeInfoEnumeration(String name, Class enumType) {
        this(name, enumType, AttributeDefault.IMPLIED, null);
    }

    public AttributeInfoEnumeration(String name, Class enumType, AttributeDefault attrDefault, BaseSchemaEnum defaultValue) {
        if (!BaseEnum.class.isAssignableFrom(enumType)) {
            throw new DsfRuntimeException("class must be an enum, not " + enumType.getName());
        }
        this.m_name = name;
        this.m_enumType = enumType;
        this.m_attrDefault = attrDefault;
        this.m_defaultValue = defaultValue;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDefaultValue() {
        return this.m_defaultValue.getName();
    }

    public BaseSchemaEnum getDefaultEnum() {
        return this.m_defaultValue;
    }

    @Override
    public AttributeDefault getAttrDefault() {
        return this.m_attrDefault;
    }

    @Override
    public AttributeDataType getDataType() {
        return AttributeDataType.ENUMERATION;
    }

    public Class getEnumType() {
        return this.m_enumType;
    }
}

