/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.context.subctx.browser.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.common.context.subctx.browser.BrowserCapabilityRegistry;
import org.eclipse.vjet.dsf.common.context.subctx.browser.BrowserEnum;
import org.eclipse.vjet.dsf.common.context.subctx.browser.Capability;
import org.eclipse.vjet.dsf.common.context.subctx.browser.IBrowser;
import org.eclipse.vjet.dsf.common.context.subctx.browser.OsEnum;
import org.eclipse.vjet.dsf.common.context.subctx.browser.internal.BrowserSniffingUtils;

public class Browser
implements IBrowser {
    BrowserSniffingUtils _sniffingUtils;
    private Map<String, Capability> _featureCapabilities;

    public Browser(String userAgentName) {
        this._sniffingUtils = new BrowserSniffingUtils(userAgentName);
        this._featureCapabilities = new HashMap<String, Capability>();
    }

    @Override
    public String getBrowserName() {
        return this._sniffingUtils.getBrowserVendor();
    }

    @Override
    public String getBrowserMajorVersion() {
        return this._sniffingUtils.getBrowserMajorVersion();
    }

    @Override
    public String getBrowserMinorVersion() {
        return this._sniffingUtils.getBrowserMinorVersion();
    }

    @Override
    public String getOSName() {
        return this._sniffingUtils.getBrowserOS();
    }

    @Override
    public boolean isOsType(OsEnum os) {
        return this._sniffingUtils.m_osNameMap.containsKey((Object)os);
    }

    @Override
    public Capability supportFeature(String feature) {
        if (feature == null || feature.trim().length() == 0) {
            return Capability.UNKNOWN_FEATURE;
        }
        Capability c = this._featureCapabilities.get(feature);
        if (c != null) {
            return c;
        }
        c = BrowserCapabilityRegistry.getInstance().capableOf(feature, this);
        this._featureCapabilities.put(feature, c);
        return c;
    }

    @Override
    public boolean isBrowserType(BrowserEnum browser) {
        return this._sniffingUtils.m_browserMap.containsKey((Object)browser);
    }

    @Override
    public boolean isMozilla() {
        return this._sniffingUtils.isMozillaBrowser();
    }
}

