/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.dsf.common.trace.DefaultTracer;
import org.eclipse.vjet.dsf.common.trace.ITraceWriter;

public class TraceConfig {
    private static final String TRACE_PROPERTY = "trace.properties";
    private static final String PTY_ENABLED = "enabled";
    private static final String PTY_WRITERS = "writers";
    private static volatile TraceConfig s_instance;
    private boolean m_enabled = false;
    private List<ITraceWriter> m_writers = new ArrayList<ITraceWriter>(1);

    private TraceConfig() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceConfig getInstance() {
        if (s_instance != null) {
            return s_instance;
        }
        Class<TraceConfig> clazz = TraceConfig.class;
        synchronized (TraceConfig.class) {
            if (s_instance == null) {
                s_instance = new TraceConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return s_instance;
        }
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public List<ITraceWriter> getWriters() {
        return Collections.unmodifiableList(this.m_writers);
    }

    private void init() {
        try {
            URL url = ResourceUtil.getResource(DefaultTracer.class, (String)TRACE_PROPERTY);
            if (url == null) {
                throw new IOException("Error loading config trace.properties");
            }
            InputStream inputStream = url.openStream();
            Properties props = new Properties();
            props.load(inputStream);
            String enabled = props.getProperty(PTY_ENABLED);
            if (enabled != null && enabled.compareToIgnoreCase("true") == 0) {
                this.m_enabled = true;
            }
            this.initializeWriters(this.parseClassNames(props, PTY_WRITERS));
            if (this.m_writers.size() == 0) {
                this.m_enabled = false;
            }
        }
        catch (Exception exception) {}
    }

    private String[] parseClassNames(Properties props, String propertyName) {
        String hands = props.getProperty(propertyName);
        if (hands == null) {
            return new String[0];
        }
        hands = hands.trim();
        int ix = 0;
        ArrayList<String> result = new ArrayList<String>();
        while (ix < hands.length()) {
            int end = ix;
            while (end < hands.length()) {
                if (Character.isWhitespace(hands.charAt(end)) || hands.charAt(end) == ',') break;
                ++end;
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    private void initializeWriters(String[] classNames) {
        int i = 0;
        while (i < classNames.length) {
            String className = classNames[i];
            try {
                Class<?> clz = Class.forName(className);
                ITraceWriter w = (ITraceWriter)clz.newInstance();
                this.m_writers.add(w);
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

