/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.vjet.dsf.common.enums.BaseEnum;
import org.eclipse.vjet.dsf.dom.DText;

public final class DOMTypeEnum
extends BaseEnum {
    private static final long serialVersionUID = 1L;
    private static int s_currentOrdinal = 0;
    private static final Map<String, DOMTypeEnum> s_tagNameToEnum = new HashMap<String, DOMTypeEnum>();
    private static final Map<Class, DOMTypeEnum> s_classToEnum = new HashMap<Class, DOMTypeEnum>();
    public static final DOMTypeEnum TEXT = new DOMTypeEnum("text", DText.class);
    private final Class m_typeClass;
    private final char[] m_nameChars;
    private static Iterable<DOMTypeEnum> s_iterable = new Iterable<DOMTypeEnum>(){

        @Override
        public Iterator<DOMTypeEnum> iterator() {
            return DOMTypeEnum.valueIterator();
        }
    };

    private DOMTypeEnum(String name, Class typeClass) {
        super(s_currentOrdinal, name);
        ++s_currentOrdinal;
        this.m_typeClass = typeClass;
        if (name != null) {
            s_tagNameToEnum.put(name, this);
        }
        if (typeClass != null) {
            s_classToEnum.put(typeClass, this);
        }
        this.m_nameChars = (char[])(name == null ? null : name.toCharArray());
    }

    char[] getNameChars() {
        return this.m_nameChars;
    }

    public Class getTypeClass() {
        return this.m_typeClass;
    }

    public static int size() {
        return s_currentOrdinal;
    }

    public static DOMTypeEnum getEnum(String name) {
        return s_tagNameToEnum.get(name);
    }

    public static DOMTypeEnum getEnum(Class typeClass) {
        return s_classToEnum.get(typeClass);
    }

    public static Iterator<DOMTypeEnum> valueIterator() {
        ListIterator iterator = BaseEnum.getIterator(DOMTypeEnum.class);
        return iterator;
    }

    public static Iterable<DOMTypeEnum> valueIterable() {
        return s_iterable;
    }
}

